/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.plain.BinaryDVIndexFieldData;
import org.elasticsearch.index.fielddata.plain.BinaryDVNumericIndexFieldData;
import org.elasticsearch.index.fielddata.plain.NumericDVIndexFieldData;
import org.elasticsearch.index.fielddata.plain.SortedSetDVBytesIndexFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.indices.fielddata.breaker.CircuitBreakerService;

public abstract class DocValuesIndexFieldData {
    protected final Index index;
    protected final FieldMapper.Names fieldNames;

    public DocValuesIndexFieldData(Index index, FieldMapper.Names fieldNames) {
        this.index = index;
        this.fieldNames = fieldNames;
    }

    public final FieldMapper.Names getFieldNames() {
        return this.fieldNames;
    }

    public final void clear() {
    }

    public final void clear(IndexReader reader) {
    }

    public final Index index() {
        return this.index;
    }

    public static class Builder
    implements IndexFieldData.Builder {
        private static final Set<String> BINARY_INDEX_FIELD_NAMES = ImmutableSet.of("_uid", "_id");
        private static final Set<String> NUMERIC_INDEX_FIELD_NAMES = ImmutableSet.of("_timestamp");
        private IndexNumericFieldData.NumericType numericType;

        public Builder numericType(IndexNumericFieldData.NumericType type) {
            this.numericType = type;
            return this;
        }

        @Override
        public IndexFieldData<?> build(Index index, Settings indexSettings, FieldMapper<?> mapper, IndexFieldDataCache cache, CircuitBreakerService breakerService) {
            FieldMapper.Names fieldNames = mapper.names();
            Settings fdSettings = mapper.fieldDataType().getSettings();
            Map<String, Settings> filter = fdSettings.getGroups("filter");
            if (filter != null && !filter.isEmpty()) {
                throw new ElasticsearchIllegalArgumentException("Doc values field data doesn't support filters [" + fieldNames.name() + "]");
            }
            if (BINARY_INDEX_FIELD_NAMES.contains(fieldNames.indexName())) {
                assert (this.numericType == null);
                return new BinaryDVIndexFieldData(index, fieldNames);
            }
            if (NUMERIC_INDEX_FIELD_NAMES.contains(fieldNames.indexName())) {
                assert (!this.numericType.isFloatingPoint());
                return new NumericDVIndexFieldData(index, fieldNames);
            }
            if (this.numericType != null) {
                return new BinaryDVNumericIndexFieldData(index, fieldNames, this.numericType);
            }
            return new SortedSetDVBytesIndexFieldData(index, fieldNames);
        }
    }
}

