/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.fieldcomparator;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.fieldcomparator.NestedWrappableComparator;
import org.elasticsearch.index.fielddata.fieldcomparator.SortMode;

public final class BytesRefValComparator
extends NestedWrappableComparator<BytesRef> {
    private final IndexFieldData<?> indexFieldData;
    private final SortMode sortMode;
    private final BytesRef missingValue;
    private final BytesRef[] values;
    private BytesRef bottom;
    private BytesValues docTerms;

    BytesRefValComparator(IndexFieldData<?> indexFieldData, int numHits, SortMode sortMode, BytesRef missingValue) {
        this.sortMode = sortMode;
        this.values = new BytesRef[numHits];
        this.indexFieldData = indexFieldData;
        this.missingValue = missingValue;
    }

    public int compare(int slot1, int slot2) {
        BytesRef val1 = this.values[slot1];
        BytesRef val2 = this.values[slot2];
        return this.compareValues(val1, val2);
    }

    public int compareBottom(int doc) throws IOException {
        BytesRef val2 = this.sortMode.getRelevantValue(this.docTerms, doc, this.missingValue);
        return this.compareValues(this.bottom, val2);
    }

    public void copy(int slot, int doc) throws IOException {
        BytesRef relevantValue = this.sortMode.getRelevantValue(this.docTerms, doc, this.missingValue);
        if (relevantValue == this.missingValue) {
            this.values[slot] = this.missingValue;
        } else {
            if (this.values[slot] == null || this.values[slot] == this.missingValue) {
                this.values[slot] = new BytesRef();
            }
            this.values[slot].copyBytes(relevantValue);
        }
    }

    public FieldComparator<BytesRef> setNextReader(AtomicReaderContext context) throws IOException {
        this.docTerms = this.indexFieldData.load(context).getBytesValues(false);
        return this;
    }

    public void setBottom(int bottom) {
        this.bottom = this.values[bottom];
    }

    public BytesRef value(int slot) {
        return this.values[slot];
    }

    public int compareValues(BytesRef val1, BytesRef val2) {
        if (val1 == null) {
            if (val2 == null) {
                return 0;
            }
            return -1;
        }
        if (val2 == null) {
            return 1;
        }
        return val1.compareTo(val2);
    }

    public int compareDocToValue(int doc, BytesRef value) {
        return this.sortMode.getRelevantValue(this.docTerms, doc, this.missingValue).compareTo(value);
    }

    @Override
    public void missing(int slot) {
        this.values[slot] = this.missingValue;
    }

    @Override
    public int compareBottomMissing() {
        return this.compareValues(this.bottom, this.missingValue);
    }
}

