/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.cache.id.simple;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.bytes.HashedBytesArray;
import org.elasticsearch.common.hppc.ObjectIntOpenHashMap;
import org.elasticsearch.index.cache.id.IdReaderTypeCache;

public class SimpleIdReaderTypeCache
implements IdReaderTypeCache {
    private final String type;
    private final ObjectIntOpenHashMap<HashedBytesArray> idToDoc;
    private final HashedBytesArray[] docIdToId;
    private final HashedBytesArray[] parentIdsValues;
    private final int[] parentIdsOrdinals;
    private long sizeInBytes = -1L;

    public SimpleIdReaderTypeCache(String type, ObjectIntOpenHashMap<HashedBytesArray> idToDoc, HashedBytesArray[] docIdToId, HashedBytesArray[] parentIdsValues, int[] parentIdsOrdinals) {
        this.type = type;
        this.idToDoc = idToDoc;
        this.docIdToId = docIdToId;
        this.parentIdsValues = parentIdsValues;
        this.parentIdsOrdinals = parentIdsOrdinals;
    }

    public String type() {
        return this.type;
    }

    @Override
    public HashedBytesArray parentIdByDoc(int docId) {
        return this.parentIdsValues[this.parentIdsOrdinals[docId]];
    }

    @Override
    public int docById(HashedBytesArray uid) {
        return this.idToDoc.getOrDefault(uid, -1);
    }

    @Override
    public HashedBytesArray idByDoc(int docId) {
        return this.docIdToId[docId];
    }

    @Override
    public long sizeInBytes() {
        if (this.sizeInBytes == -1L) {
            this.sizeInBytes = this.computeSizeInBytes();
        }
        return this.sizeInBytes;
    }

    public HashedBytesArray canReuse(HashedBytesArray id) {
        if (this.idToDoc.containsKey(id)) {
            return this.idToDoc.lkey();
        }
        return id;
    }

    long computeSizeInBytes() {
        long sizeInBytes = 0L;
        sizeInBytes += (long)(RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + this.idToDoc.values.length * 4);
        sizeInBytes += (long)(RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + this.idToDoc.allocated.length);
        boolean[] states = this.idToDoc.allocated;
        KType[] keys = this.idToDoc.keys;
        for (int i = 0; i < states.length; ++i) {
            if (!states[i]) continue;
            HashedBytesArray bytesArray = (HashedBytesArray)keys[i];
            if (bytesArray != null) {
                sizeInBytes += (long)(RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + (bytesArray.length() + 4));
                continue;
            }
            sizeInBytes += (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF;
        }
        sizeInBytes += (long)(RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + RamUsageEstimator.NUM_BYTES_OBJECT_REF * this.docIdToId.length);
        for (HashedBytesArray bytesArray : this.parentIdsValues) {
            if (bytesArray == null) {
                sizeInBytes += (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF;
                continue;
            }
            sizeInBytes += (long)(RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + (bytesArray.length() + 4));
        }
        return sizeInBytes += RamUsageEstimator.sizeOf((int[])this.parentIdsOrdinals);
    }
}

