/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.recycler;

import java.lang.ref.SoftReference;
import org.apache.lucene.util.CloseableThreadLocal;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.collect.Queues;
import org.elasticsearch.common.hppc.hash.MurmurHash3;
import org.elasticsearch.common.recycler.ConcurrentDequeRecycler;
import org.elasticsearch.common.recycler.DequeRecycler;
import org.elasticsearch.common.recycler.FilterRecycler;
import org.elasticsearch.common.recycler.NoneRecycler;
import org.elasticsearch.common.recycler.Recycler;

public enum Recyclers {


    public static <T> Recycler<T> none(Recycler.C<T> c) {
        return new NoneRecycler<T>(c);
    }

    public static <T> Recycler<T> concurrentDeque(Recycler.C<T> c, int limit) {
        return new ConcurrentDequeRecycler<T>(c, limit);
    }

    public static <T> Recycler<T> deque(Recycler.C<T> c, int limit) {
        return new DequeRecycler<T>(c, Queues.newArrayDeque(), limit);
    }

    public static <T> Recycler.Factory<T> dequeFactory(final Recycler.C<T> c, final int limit) {
        return new Recycler.Factory<T>(){

            @Override
            public Recycler<T> build() {
                return Recyclers.deque(c, limit);
            }
        };
    }

    public static <T> Recycler<T> sizing(final Recycler<T> defaultRecycler, final Recycler<T> smallObjectRecycler, final int minSize) {
        return new FilterRecycler<T>(){

            @Override
            protected Recycler<T> getDelegate() {
                return defaultRecycler;
            }

            @Override
            public Recycler.V<T> obtain(int sizing) {
                if (sizing > 0 && sizing < minSize) {
                    return smallObjectRecycler.obtain(sizing);
                }
                return super.obtain(sizing);
            }

            @Override
            public void close() {
                defaultRecycler.close();
                smallObjectRecycler.close();
            }
        };
    }

    public static <T> Recycler<T> threadLocal(final Recycler.Factory<T> factory) {
        return new FilterRecycler<T>(){
            private final CloseableThreadLocal<Recycler<T>> recyclers = new CloseableThreadLocal<Recycler<T>>(){

                protected Recycler<T> initialValue() {
                    return factory.build();
                }
            };

            @Override
            protected Recycler<T> getDelegate() {
                return (Recycler)this.recyclers.get();
            }

            @Override
            public void close() {
                this.recyclers.close();
            }
        };
    }

    public static <T> Recycler<T> soft(final Recycler.Factory<T> factory) {
        return new FilterRecycler<T>(){
            SoftReference<Recycler<T>> ref = new SoftReference<Object>(null);

            @Override
            protected Recycler<T> getDelegate() {
                Recycler recycler = this.ref.get();
                if (recycler == null) {
                    recycler = factory.build();
                    this.ref = new SoftReference(recycler);
                }
                return recycler;
            }
        };
    }

    public static <T> Recycler.Factory<T> softFactory(final Recycler.Factory<T> factory) {
        return new Recycler.Factory<T>(){

            @Override
            public Recycler<T> build() {
                return Recyclers.soft(factory);
            }
        };
    }

    public static <T> Recycler<T> locked(final Recycler<T> recycler) {
        return new FilterRecycler<T>(){
            private final Object lock = new Object();

            @Override
            protected Recycler<T> getDelegate() {
                return recycler;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Recycler.V<T> obtain(int sizing) {
                Object object = this.lock;
                synchronized (object) {
                    return super.obtain(sizing);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Recycler.V<T> obtain() {
                Object object = this.lock;
                synchronized (object) {
                    return super.obtain();
                }
            }

            @Override
            protected Recycler.V<T> wrap(final Recycler.V<T> delegate) {
                return new Recycler.V<T>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public boolean release() throws ElasticsearchException {
                        Object object = lock;
                        synchronized (object) {
                            return delegate.release();
                        }
                    }

                    @Override
                    public T v() {
                        return delegate.v();
                    }

                    @Override
                    public boolean isRecycled() {
                        return delegate.isRecycled();
                    }
                };
            }
        };
    }

    public static <T> Recycler<T> concurrent(final Recycler.Factory<T> factory, final int concurrencyLevel) {
        if (concurrencyLevel < 1) {
            throw new ElasticsearchIllegalArgumentException("concurrencyLevel must be >= 1");
        }
        if (concurrencyLevel == 1) {
            return Recyclers.locked(factory.build());
        }
        return new FilterRecycler<T>(){
            private final Recycler<T>[] recyclers;
            {
                Recycler[] recyclers = new Recycler[concurrencyLevel];
                this.recyclers = recyclers;
                for (int i = 0; i < concurrencyLevel; ++i) {
                    recyclers[i] = Recyclers.locked(factory.build());
                }
            }

            final int slot() {
                long id = Thread.currentThread().getId();
                int slot = (int)MurmurHash3.hash(id);
                slot &= Integer.MAX_VALUE;
                return slot %= concurrencyLevel;
            }

            @Override
            protected Recycler<T> getDelegate() {
                return this.recyclers[this.slot()];
            }

            @Override
            public void close() {
                for (Recycler recycler : this.recyclers) {
                    recycler.close();
                }
            }
        };
    }

    public static <T> Recycler<T> concurrent(Recycler.Factory<T> factory) {
        return Recyclers.concurrent(factory, Runtime.getRuntime().availableProcessors());
    }
}

