/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.jackson.dataformat.yaml;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import org.elasticsearch.common.jackson.core.JsonEncoding;
import org.elasticsearch.common.jackson.core.JsonFactory;
import org.elasticsearch.common.jackson.core.JsonParseException;
import org.elasticsearch.common.jackson.core.JsonParser;
import org.elasticsearch.common.jackson.core.ObjectCodec;
import org.elasticsearch.common.jackson.core.Version;
import org.elasticsearch.common.jackson.core.format.InputAccessor;
import org.elasticsearch.common.jackson.core.format.MatchStrength;
import org.elasticsearch.common.jackson.core.io.IOContext;
import org.elasticsearch.common.jackson.dataformat.yaml.PackageVersion;
import org.elasticsearch.common.jackson.dataformat.yaml.UTF8Reader;
import org.elasticsearch.common.jackson.dataformat.yaml.UTF8Writer;
import org.elasticsearch.common.jackson.dataformat.yaml.YAMLGenerator;
import org.elasticsearch.common.jackson.dataformat.yaml.YAMLParser;
import org.elasticsearch.common.jackson.dataformat.yaml.snakeyaml.DumperOptions;

public class YAMLFactory
extends JsonFactory {
    private static final long serialVersionUID = 1171663157274350349L;
    public static final String FORMAT_NAME_YAML = "YAML";
    protected static final int DEFAULT_YAML_PARSER_FEATURE_FLAGS = YAMLParser.Feature.collectDefaults();
    protected static final int DEFAULT_YAML_GENERATOR_FEATURE_FLAGS = YAMLGenerator.Feature.collectDefaults();
    private static final byte UTF8_BOM_1 = -17;
    private static final byte UTF8_BOM_2 = -69;
    private static final byte UTF8_BOM_3 = -65;
    protected int _yamlParserFeatures = DEFAULT_YAML_PARSER_FEATURE_FLAGS;
    protected int _yamlGeneratorFeatures = DEFAULT_YAML_GENERATOR_FEATURE_FLAGS;
    protected DumperOptions.Version _version;
    protected final Charset UTF8 = Charset.forName("UTF-8");

    public YAMLFactory() {
        this(null);
    }

    public YAMLFactory(ObjectCodec objectCodec) {
        super(objectCodec);
        this._yamlParserFeatures = DEFAULT_YAML_PARSER_FEATURE_FLAGS;
        this._yamlGeneratorFeatures = DEFAULT_YAML_GENERATOR_FEATURE_FLAGS;
        this._version = null;
    }

    public YAMLFactory(YAMLFactory yAMLFactory, ObjectCodec objectCodec) {
        super(yAMLFactory, objectCodec);
        this._version = yAMLFactory._version;
        this._yamlParserFeatures = yAMLFactory._yamlParserFeatures;
        this._yamlGeneratorFeatures = yAMLFactory._yamlGeneratorFeatures;
    }

    @Override
    public YAMLFactory copy() {
        this._checkInvalidCopy(YAMLFactory.class);
        return new YAMLFactory(this, null);
    }

    @Override
    protected Object readResolve() {
        return new YAMLFactory(this, this._objectCodec);
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    @Override
    public String getFormatName() {
        return FORMAT_NAME_YAML;
    }

    @Override
    public MatchStrength hasFormat(InputAccessor inputAccessor) throws IOException {
        if (!inputAccessor.hasMoreBytes()) {
            return MatchStrength.INCONCLUSIVE;
        }
        byte by = inputAccessor.nextByte();
        if (by == -17) {
            if (!inputAccessor.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            if (inputAccessor.nextByte() != -69) {
                return MatchStrength.NO_MATCH;
            }
            if (!inputAccessor.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            if (inputAccessor.nextByte() != -65) {
                return MatchStrength.NO_MATCH;
            }
            if (!inputAccessor.hasMoreBytes()) {
                return MatchStrength.INCONCLUSIVE;
            }
            by = inputAccessor.nextByte();
        }
        if (by == 45 && inputAccessor.hasMoreBytes() && inputAccessor.nextByte() == 45 && inputAccessor.hasMoreBytes() && inputAccessor.nextByte() == 45) {
            return MatchStrength.FULL_MATCH;
        }
        return MatchStrength.INCONCLUSIVE;
    }

    public final YAMLFactory configure(YAMLParser.Feature feature, boolean bl) {
        if (bl) {
            this.enable(feature);
        } else {
            this.disable(feature);
        }
        return this;
    }

    public YAMLFactory enable(YAMLParser.Feature feature) {
        this._yamlParserFeatures |= feature.getMask();
        return this;
    }

    public YAMLFactory disable(YAMLParser.Feature feature) {
        this._yamlParserFeatures &= ~feature.getMask();
        return this;
    }

    public final boolean isEnabled(YAMLParser.Feature feature) {
        return (this._yamlParserFeatures & feature.getMask()) != 0;
    }

    public final YAMLFactory configure(YAMLGenerator.Feature feature, boolean bl) {
        if (bl) {
            this.enable(feature);
        } else {
            this.disable(feature);
        }
        return this;
    }

    public YAMLFactory enable(YAMLGenerator.Feature feature) {
        this._yamlGeneratorFeatures |= feature.getMask();
        return this;
    }

    public YAMLFactory disable(YAMLGenerator.Feature feature) {
        this._yamlGeneratorFeatures &= ~feature.getMask();
        return this;
    }

    public final boolean isEnabled(YAMLGenerator.Feature feature) {
        return (this._yamlGeneratorFeatures & feature.getMask()) != 0;
    }

    @Override
    public YAMLParser createParser(String string) throws IOException, JsonParseException {
        Reader reader = new StringReader(string);
        IOContext iOContext = this._createContext(reader, true);
        if (this._inputDecorator != null) {
            reader = this._inputDecorator.decorate(iOContext, reader);
        }
        return this._createParser(reader, iOContext);
    }

    @Override
    public YAMLParser createParser(File file) throws IOException, JsonParseException {
        IOContext iOContext = this._createContext(file, true);
        InputStream inputStream = new FileInputStream(file);
        if (this._inputDecorator != null) {
            inputStream = this._inputDecorator.decorate(iOContext, inputStream);
        }
        return this._createParser(inputStream, iOContext);
    }

    @Override
    public YAMLParser createParser(URL uRL) throws IOException, JsonParseException {
        IOContext iOContext = this._createContext(uRL, true);
        InputStream inputStream = this._optimizedStreamFromURL(uRL);
        if (this._inputDecorator != null) {
            inputStream = this._inputDecorator.decorate(iOContext, inputStream);
        }
        return this._createParser(inputStream, iOContext);
    }

    @Override
    public YAMLParser createParser(InputStream inputStream) throws IOException, JsonParseException {
        IOContext iOContext = this._createContext(inputStream, false);
        if (this._inputDecorator != null) {
            inputStream = this._inputDecorator.decorate(iOContext, inputStream);
        }
        return this._createParser(inputStream, iOContext);
    }

    @Override
    public JsonParser createParser(Reader reader) throws IOException, JsonParseException {
        IOContext iOContext = this._createContext(reader, false);
        if (this._inputDecorator != null) {
            reader = this._inputDecorator.decorate(iOContext, reader);
        }
        return this._createParser(reader, iOContext);
    }

    @Override
    public YAMLParser createParser(byte[] byArray) throws IOException, JsonParseException {
        InputStream inputStream;
        IOContext iOContext = this._createContext(byArray, true);
        if (this._inputDecorator != null && (inputStream = this._inputDecorator.decorate(iOContext, byArray, 0, byArray.length)) != null) {
            return this._createParser(inputStream, iOContext);
        }
        return this._createParser(byArray, 0, byArray.length, iOContext);
    }

    @Override
    public YAMLParser createParser(byte[] byArray, int n, int n2) throws IOException, JsonParseException {
        InputStream inputStream;
        IOContext iOContext = this._createContext(byArray, true);
        if (this._inputDecorator != null && (inputStream = this._inputDecorator.decorate(iOContext, byArray, n, n2)) != null) {
            return this._createParser(inputStream, iOContext);
        }
        return this._createParser(byArray, n, n2, iOContext);
    }

    @Override
    @Deprecated
    public YAMLParser createJsonParser(String string) throws IOException, JsonParseException {
        return this.createParser(string);
    }

    @Override
    @Deprecated
    public YAMLParser createJsonParser(File file) throws IOException, JsonParseException {
        return this.createParser(file);
    }

    @Override
    @Deprecated
    public YAMLParser createJsonParser(URL uRL) throws IOException, JsonParseException {
        return this.createParser(uRL);
    }

    @Override
    @Deprecated
    public YAMLParser createJsonParser(InputStream inputStream) throws IOException, JsonParseException {
        return this.createParser(inputStream);
    }

    @Override
    @Deprecated
    public JsonParser createJsonParser(Reader reader) throws IOException, JsonParseException {
        return this.createParser(reader);
    }

    @Override
    @Deprecated
    public YAMLParser createJsonParser(byte[] byArray) throws IOException, JsonParseException {
        return this.createParser(byArray);
    }

    @Override
    @Deprecated
    public YAMLParser createJsonParser(byte[] byArray, int n, int n2) throws IOException, JsonParseException {
        return this.createParser(byArray, n, n2);
    }

    @Override
    public YAMLGenerator createGenerator(OutputStream outputStream, JsonEncoding jsonEncoding) throws IOException {
        IOContext iOContext = this._createContext(outputStream, false);
        if (this._outputDecorator != null) {
            outputStream = this._outputDecorator.decorate(iOContext, outputStream);
        }
        return this._createGenerator(this._createWriter(outputStream, JsonEncoding.UTF8, iOContext), iOContext);
    }

    @Override
    public YAMLGenerator createGenerator(OutputStream outputStream) throws IOException {
        IOContext iOContext = this._createContext(outputStream, false);
        if (this._outputDecorator != null) {
            outputStream = this._outputDecorator.decorate(iOContext, outputStream);
        }
        return this._createGenerator(this._createWriter(outputStream, JsonEncoding.UTF8, iOContext), iOContext);
    }

    @Override
    public YAMLGenerator createGenerator(Writer writer) throws IOException {
        IOContext iOContext = this._createContext(writer, false);
        if (this._outputDecorator != null) {
            writer = this._outputDecorator.decorate(iOContext, writer);
        }
        return this._createGenerator(writer, iOContext);
    }

    @Override
    @Deprecated
    public YAMLGenerator createJsonGenerator(OutputStream outputStream, JsonEncoding jsonEncoding) throws IOException {
        return this.createGenerator(outputStream, jsonEncoding);
    }

    @Override
    @Deprecated
    public YAMLGenerator createJsonGenerator(OutputStream outputStream) throws IOException {
        return this.createGenerator(outputStream);
    }

    @Override
    @Deprecated
    public YAMLGenerator createJsonGenerator(Writer writer) throws IOException {
        return this.createGenerator(writer);
    }

    @Override
    protected YAMLParser _createParser(InputStream inputStream, IOContext iOContext) throws IOException, JsonParseException {
        Reader reader = this._createReader(inputStream, null, iOContext);
        return new YAMLParser(iOContext, this._getBufferRecycler(), this._parserFeatures, this._yamlParserFeatures, this._objectCodec, reader);
    }

    @Override
    protected YAMLParser _createParser(Reader reader, IOContext iOContext) throws IOException, JsonParseException {
        return new YAMLParser(iOContext, this._getBufferRecycler(), this._parserFeatures, this._yamlParserFeatures, this._objectCodec, reader);
    }

    @Override
    protected YAMLParser _createParser(byte[] byArray, int n, int n2, IOContext iOContext) throws IOException, JsonParseException {
        Reader reader = this._createReader(byArray, n, n2, null, iOContext);
        return new YAMLParser(iOContext, this._getBufferRecycler(), this._parserFeatures, this._yamlParserFeatures, this._objectCodec, reader);
    }

    @Override
    @Deprecated
    protected YAMLParser _createJsonParser(InputStream inputStream, IOContext iOContext) throws IOException, JsonParseException {
        return this._createParser(inputStream, iOContext);
    }

    @Override
    @Deprecated
    protected JsonParser _createJsonParser(Reader reader, IOContext iOContext) throws IOException, JsonParseException {
        return this._createParser(reader, iOContext);
    }

    @Override
    @Deprecated
    protected YAMLParser _createJsonParser(byte[] byArray, int n, int n2, IOContext iOContext) throws IOException, JsonParseException {
        return this._createParser(byArray, n, n2, iOContext);
    }

    @Override
    protected YAMLGenerator _createGenerator(Writer writer, IOContext iOContext) throws IOException {
        int n = this._yamlGeneratorFeatures;
        YAMLGenerator yAMLGenerator = new YAMLGenerator(iOContext, this._generatorFeatures, n, this._objectCodec, writer, this._version);
        return yAMLGenerator;
    }

    @Override
    @Deprecated
    protected YAMLGenerator _createJsonGenerator(Writer writer, IOContext iOContext) throws IOException {
        return this._createGenerator(writer, iOContext);
    }

    @Override
    @Deprecated
    protected YAMLGenerator _createUTF8Generator(OutputStream outputStream, IOContext iOContext) throws IOException {
        return this._createGenerator(new UTF8Writer(outputStream), iOContext);
    }

    @Override
    @Deprecated
    protected YAMLGenerator _createUTF8JsonGenerator(OutputStream outputStream, IOContext iOContext) throws IOException {
        return this._createUTF8Generator(outputStream, iOContext);
    }

    @Override
    protected Writer _createWriter(OutputStream outputStream, JsonEncoding jsonEncoding, IOContext iOContext) throws IOException {
        if (jsonEncoding == JsonEncoding.UTF8) {
            return new UTF8Writer(outputStream);
        }
        return new OutputStreamWriter(outputStream, jsonEncoding.getJavaName());
    }

    protected Reader _createReader(InputStream inputStream, JsonEncoding jsonEncoding, IOContext iOContext) throws IOException {
        if (jsonEncoding == null) {
            jsonEncoding = JsonEncoding.UTF8;
        }
        if (jsonEncoding == JsonEncoding.UTF8) {
            boolean bl = iOContext.isResourceManaged() || this.isEnabled(JsonParser.Feature.AUTO_CLOSE_SOURCE);
            return new UTF8Reader(inputStream, bl);
        }
        return new InputStreamReader(inputStream, jsonEncoding.getJavaName());
    }

    protected Reader _createReader(byte[] byArray, int n, int n2, JsonEncoding jsonEncoding, IOContext iOContext) throws IOException {
        if (jsonEncoding == null) {
            jsonEncoding = JsonEncoding.UTF8;
        }
        if (jsonEncoding == null || jsonEncoding == JsonEncoding.UTF8) {
            return new UTF8Reader(byArray, n, n2, true);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n, n2);
        return new InputStreamReader((InputStream)byteArrayInputStream, jsonEncoding.getJavaName());
    }
}

