/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core.interception;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.ReaderInterceptorContext;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public abstract class AbstractReaderInterceptorContext
implements ReaderInterceptorContext {
    protected ReaderInterceptor[] interceptors;
    protected ResteasyProviderFactory providerFactory;
    protected Class type;
    protected Type genericType;
    protected Annotation[] annotations;
    protected MediaType mediaType;
    protected MultivaluedMap<String, String> headers;
    protected InputStream inputStream;
    protected int index = 0;

    public AbstractReaderInterceptorContext(MediaType mediaType, ResteasyProviderFactory providerFactory, Annotation[] annotations, ReaderInterceptor[] interceptors, MultivaluedMap<String, String> headers, Type genericType, Class type, InputStream inputStream) {
        this.mediaType = mediaType;
        this.annotations = annotations;
        this.interceptors = interceptors;
        this.headers = headers;
        this.genericType = genericType;
        this.type = type;
        this.inputStream = inputStream;
        this.providerFactory = providerFactory;
    }

    public Object proceed() throws IOException {
        if (this.interceptors == null || this.index >= this.interceptors.length) {
            MessageBodyReader reader = this.getReader();
            return this.readFrom(reader);
        }
        return this.interceptors[this.index++].aroundReadFrom((ReaderInterceptorContext)this);
    }

    protected Object readFrom(MessageBodyReader reader) throws IOException {
        return reader.readFrom(this.type, this.genericType, this.annotations, this.mediaType, this.headers, this.inputStream);
    }

    protected MessageBodyReader getReader() {
        MessageBodyReader reader;
        MediaType mediaType = this.mediaType;
        if (this.getHeaders() != null && this.getHeaders().getFirst((Object)"Content-Type") == null && mediaType.isWildcardType()) {
            mediaType = MediaType.APPLICATION_OCTET_STREAM_TYPE;
        }
        if ((reader = this.resolveReader(mediaType)) == null) {
            this.throwReaderNotFound();
        }
        return reader;
    }

    protected abstract MessageBodyReader resolveReader(MediaType var1);

    protected abstract void throwReaderNotFound();

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream is) {
        this.inputStream = is;
    }

    public MultivaluedMap<String, String> getHeaders() {
        return this.headers;
    }

    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(Annotation[] annotations) {
        if (annotations == null) {
            throw new NullPointerException("annotations param was null");
        }
        this.annotations = annotations;
    }

    public Class getType() {
        return this.type;
    }

    public void setType(Class type) {
        this.type = type;
    }

    public Type getGenericType() {
        return this.genericType;
    }

    public void setGenericType(Type genericType) {
        this.genericType = genericType;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(MediaType mediaType) {
        this.mediaType = mediaType;
    }
}

