/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.mahout.math.function.ShortIntProcedure;
import org.apache.mahout.math.function.ShortProcedure;
import org.apache.mahout.math.list.IntArrayList;
import org.apache.mahout.math.list.ShortArrayList;
import org.apache.mahout.math.map.AbstractShortIntMap;
import org.apache.mahout.math.map.HashFunctions;

public class OpenShortIntHashMap
extends AbstractShortIntMap {
    protected static final byte FREE = 0;
    protected static final byte FULL = 1;
    protected static final byte REMOVED = 2;
    protected static final short NO_KEY_VALUE = 0;
    protected short[] table;
    protected int[] values;
    protected byte[] state;
    protected int freeEntries;

    public OpenShortIntHashMap() {
        this(277);
    }

    public OpenShortIntHashMap(int initialCapacity) {
        this(initialCapacity, 0.2, 0.5);
    }

    public OpenShortIntHashMap(int initialCapacity, double minLoadFactor, double maxLoadFactor) {
        this.setUp(initialCapacity, minLoadFactor, maxLoadFactor);
    }

    @Override
    public void clear() {
        Arrays.fill(this.state, (byte)0);
        this.distinct = 0;
        this.freeEntries = this.table.length;
        this.trimToSize();
    }

    @Override
    public Object clone() {
        OpenShortIntHashMap copy = (OpenShortIntHashMap)super.clone();
        copy.table = (short[])copy.table.clone();
        copy.values = (int[])copy.values.clone();
        copy.state = (byte[])copy.state.clone();
        return copy;
    }

    @Override
    public boolean containsKey(short key) {
        return this.indexOfKey(key) >= 0;
    }

    @Override
    public boolean containsValue(int value) {
        return this.indexOfValue(value) >= 0;
    }

    @Override
    public void ensureCapacity(int minCapacity) {
        if (this.table.length < minCapacity) {
            int newCapacity = this.nextPrime(minCapacity);
            this.rehash(newCapacity);
        }
    }

    @Override
    public boolean forEachKey(ShortProcedure procedure) {
        int i = this.table.length;
        while (i-- > 0) {
            if (this.state[i] != 1 || procedure.apply(this.table[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean forEachPair(ShortIntProcedure procedure) {
        int i = this.table.length;
        while (i-- > 0) {
            if (this.state[i] != 1 || procedure.apply(this.table[i], this.values[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int get(short key) {
        int i = this.indexOfKey(key);
        if (i < 0) {
            return 0;
        }
        return this.values[i];
    }

    protected int indexOfInsertion(short key) {
        int length = this.table.length;
        int hash = HashFunctions.hash(key) & Integer.MAX_VALUE;
        int i = hash % length;
        int decrement = hash % (length - 2);
        if (decrement == 0) {
            decrement = 1;
        }
        while (this.state[i] == 1 && this.table[i] != key) {
            if ((i -= decrement) >= 0) continue;
            i += length;
        }
        if (this.state[i] == 2) {
            int j = i;
            while (this.state[i] != 0 && (this.state[i] == 2 || this.table[i] != key)) {
                if ((i -= decrement) >= 0) continue;
                i += length;
            }
            if (this.state[i] == 0) {
                i = j;
            }
        }
        if (this.state[i] == 1) {
            return -i - 1;
        }
        return i;
    }

    protected int indexOfKey(short key) {
        int length = this.table.length;
        int hash = HashFunctions.hash(key) & Integer.MAX_VALUE;
        int i = hash % length;
        int decrement = hash % (length - 2);
        if (decrement == 0) {
            decrement = 1;
        }
        while (this.state[i] != 0 && (this.state[i] == 2 || this.table[i] != key)) {
            if ((i -= decrement) >= 0) continue;
            i += length;
        }
        if (this.state[i] == 0) {
            return -1;
        }
        return i;
    }

    protected int indexOfValue(int value) {
        int[] val = this.values;
        byte[] stat = this.state;
        int i = stat.length;
        while (--i >= 0) {
            if (stat[i] != 1 || val[i] != value) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void keys(ShortArrayList list) {
        list.setSize(this.distinct);
        short[] elements = list.elements();
        int j = 0;
        int i = this.table.length;
        while (i-- > 0) {
            if (this.state[i] != 1) continue;
            elements[j++] = this.table[i];
        }
    }

    public Iterator<MapElement> iterator() {
        return new MapIterator();
    }

    @Override
    public void pairsMatching(ShortIntProcedure condition, ShortArrayList keyList, IntArrayList valueList) {
        keyList.clear();
        valueList.clear();
        int i = this.table.length;
        while (i-- > 0) {
            if (this.state[i] != 1 || !condition.apply(this.table[i], this.values[i])) continue;
            keyList.add(this.table[i]);
            valueList.add(this.values[i]);
        }
    }

    @Override
    public boolean put(short key, int value) {
        int i = this.indexOfInsertion(key);
        if (i < 0) {
            i = -i - 1;
            this.values[i] = value;
            return false;
        }
        if (this.distinct > this.highWaterMark) {
            int newCapacity = this.chooseGrowCapacity(this.distinct + 1, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(newCapacity);
            return this.put(key, value);
        }
        this.table[i] = key;
        this.values[i] = value;
        if (this.state[i] == 0) {
            --this.freeEntries;
        }
        this.state[i] = 1;
        ++this.distinct;
        if (this.freeEntries < 1) {
            int newCapacity = this.chooseGrowCapacity(this.distinct + 1, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(newCapacity);
        }
        return true;
    }

    @Override
    public int adjustOrPutValue(short key, int newValue, int incrValue) {
        int i = this.indexOfInsertion(key);
        if (i < 0) {
            int n = i = -i - 1;
            this.values[n] = this.values[n] + incrValue;
            return this.values[i];
        }
        this.put(key, newValue);
        return newValue;
    }

    protected void rehash(int newCapacity) {
        int oldCapacity = this.table.length;
        short[] oldTable = this.table;
        int[] oldValues = this.values;
        byte[] oldState = this.state;
        this.table = new short[newCapacity];
        this.values = new int[newCapacity];
        this.state = new byte[newCapacity];
        this.lowWaterMark = this.chooseLowWaterMark(newCapacity, this.minLoadFactor);
        this.highWaterMark = this.chooseHighWaterMark(newCapacity, this.maxLoadFactor);
        this.freeEntries = newCapacity - this.distinct;
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldState[i] != 1) continue;
            short element = oldTable[i];
            int index = this.indexOfInsertion(element);
            this.table[index] = element;
            this.values[index] = oldValues[i];
            this.state[index] = 1;
        }
    }

    @Override
    public boolean removeKey(short key) {
        int i = this.indexOfKey(key);
        if (i < 0) {
            return false;
        }
        this.state[i] = 2;
        --this.distinct;
        if (this.distinct < this.lowWaterMark) {
            int newCapacity = this.chooseShrinkCapacity(this.distinct, this.minLoadFactor, this.maxLoadFactor);
            this.rehash(newCapacity);
        }
        return true;
    }

    @Override
    protected final void setUp(int initialCapacity, double minLoadFactor, double maxLoadFactor) {
        int capacity = initialCapacity;
        super.setUp(capacity, minLoadFactor, maxLoadFactor);
        capacity = this.nextPrime(capacity);
        if (capacity == 0) {
            capacity = 1;
        }
        this.table = new short[capacity];
        this.values = new int[capacity];
        this.state = new byte[capacity];
        this.minLoadFactor = minLoadFactor;
        this.maxLoadFactor = capacity == Integer.MAX_VALUE ? 1.0 : maxLoadFactor;
        this.distinct = 0;
        this.freeEntries = capacity;
        this.lowWaterMark = 0;
        this.highWaterMark = this.chooseHighWaterMark(capacity, this.maxLoadFactor);
    }

    @Override
    public void trimToSize() {
        int newCapacity = this.nextPrime((int)(1.0 + 1.2 * (double)this.size()));
        if (this.table.length > newCapacity) {
            this.rehash(newCapacity);
        }
    }

    @Override
    public void values(IntArrayList list) {
        list.setSize(this.distinct);
        int[] elements = list.elements();
        int j = 0;
        int i = this.state.length;
        while (i-- > 0) {
            if (this.state[i] != 1) continue;
            elements[j++] = this.values[i];
        }
    }

    protected void getInternalFactors(int[] capacity, double[] minLoadFactor, double[] maxLoadFactor) {
        capacity[0] = this.table.length;
        minLoadFactor[0] = this.minLoadFactor;
        maxLoadFactor[0] = this.maxLoadFactor;
    }

    public final class MapIterator
    implements Iterator<MapElement> {
        private final MapElement element;

        private MapIterator() {
            this.element = new MapElement();
        }

        @Override
        public boolean hasNext() {
            return this.element.seen < OpenShortIntHashMap.this.distinct;
        }

        @Override
        public MapElement next() {
            if (this.element.advanceOffset()) {
                return this.element;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public final class MapElement {
        private int offset = -1;
        int seen = 0;

        boolean advanceOffset() {
            ++this.offset;
            while (this.offset < OpenShortIntHashMap.this.state.length && OpenShortIntHashMap.this.state[this.offset] != 1) {
                ++this.offset;
            }
            if (this.offset < OpenShortIntHashMap.this.state.length) {
                ++this.seen;
            }
            return this.offset < OpenShortIntHashMap.this.state.length;
        }

        public int get() {
            return OpenShortIntHashMap.this.values[this.offset];
        }

        public short index() {
            return OpenShortIntHashMap.this.table[this.offset];
        }

        public void set(int value) {
            OpenShortIntHashMap.this.values[this.offset] = value;
        }
    }
}

