/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.SparseMatrix;
import org.apache.mahout.math.SparseRowMatrix;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.list.IntArrayList;

public class MatrixWritable
implements Writable {
    private static final int FLAG_DENSE = 1;
    private static final int FLAG_SEQUENTIAL = 2;
    private static final int FLAG_LABELS = 4;
    private static final int FLAG_SPARSE_ROW = 8;
    private static final int NUM_FLAGS = 4;
    private Matrix matrix;

    public MatrixWritable() {
    }

    public MatrixWritable(Matrix m) {
        this.matrix = m;
    }

    public Matrix get() {
        return this.matrix;
    }

    public void set(Matrix matrix) {
        this.matrix = matrix;
    }

    public void write(DataOutput out) throws IOException {
        MatrixWritable.writeMatrix(out, this.matrix);
    }

    public void readFields(DataInput in) throws IOException {
        this.matrix = MatrixWritable.readMatrix(in);
    }

    public static void readLabels(DataInput in, Map<String, Integer> columnLabelBindings, Map<String, Integer> rowLabelBindings) throws IOException {
        int rowSize;
        int colSize = in.readInt();
        if (colSize > 0) {
            for (int i = 0; i < colSize; ++i) {
                columnLabelBindings.put(in.readUTF(), in.readInt());
            }
        }
        if ((rowSize = in.readInt()) > 0) {
            for (int i = 0; i < rowSize; ++i) {
                rowLabelBindings.put(in.readUTF(), in.readInt());
            }
        }
    }

    public static void writeLabelBindings(DataOutput out, Map<String, Integer> columnLabelBindings, Map<String, Integer> rowLabelBindings) throws IOException {
        if (columnLabelBindings == null) {
            out.writeInt(0);
        } else {
            out.writeInt(columnLabelBindings.size());
            for (Map.Entry<String, Integer> stringIntegerEntry : columnLabelBindings.entrySet()) {
                out.writeUTF(stringIntegerEntry.getKey());
                out.writeInt(stringIntegerEntry.getValue());
            }
        }
        if (rowLabelBindings == null) {
            out.writeInt(0);
        } else {
            out.writeInt(rowLabelBindings.size());
            for (Map.Entry<String, Integer> stringIntegerEntry : rowLabelBindings.entrySet()) {
                out.writeUTF(stringIntegerEntry.getKey());
                out.writeInt(stringIntegerEntry.getValue());
            }
        }
    }

    public static Matrix readMatrix(DataInput in) throws IOException {
        DenseMatrix matrix;
        int flags = in.readInt();
        Preconditions.checkArgument((flags >> 4 == 0 ? 1 : 0) != 0, (String)"Unknown flags set: %d", (Object[])new Object[]{Integer.toString(flags, 2)});
        boolean dense = (flags & 1) != 0;
        boolean sequential = (flags & 2) != 0;
        boolean hasLabels = (flags & 4) != 0;
        boolean isSparseRowMatrix = (flags & 8) != 0;
        int rows = in.readInt();
        int columns = in.readInt();
        byte vectorFlags = in.readByte();
        if (dense) {
            matrix = new DenseMatrix(rows, columns);
            for (int row = 0; row < rows; ++row) {
                matrix.assignRow(row, VectorWritable.readVector(in, vectorFlags, columns));
            }
        } else if (isSparseRowMatrix) {
            Vector[] rowVectors = new Vector[rows];
            for (int row = 0; row < rows; ++row) {
                rowVectors[row] = VectorWritable.readVector(in, vectorFlags, columns);
            }
            matrix = new SparseRowMatrix(rows, columns, rowVectors, true, !sequential);
        } else {
            matrix = new SparseMatrix(rows, columns);
            int numNonZeroRows = in.readInt();
            int rowsRead = 0;
            while (rowsRead++ < numNonZeroRows) {
                int rowIndex = in.readInt();
                matrix.assignRow(rowIndex, VectorWritable.readVector(in, vectorFlags, columns));
            }
        }
        if (hasLabels) {
            HashMap<String, Integer> columnLabelBindings = new HashMap<String, Integer>();
            HashMap<String, Integer> rowLabelBindings = new HashMap<String, Integer>();
            MatrixWritable.readLabels(in, columnLabelBindings, rowLabelBindings);
            if (!columnLabelBindings.isEmpty()) {
                matrix.setColumnLabelBindings(columnLabelBindings);
            }
            if (!rowLabelBindings.isEmpty()) {
                matrix.setRowLabelBindings(rowLabelBindings);
            }
        }
        return matrix;
    }

    public static void writeMatrix(DataOutput out, Matrix matrix) throws IOException {
        boolean isSparseRowMatrix;
        int flags = 0;
        Vector row = matrix.viewRow(0);
        boolean isDense = row.isDense();
        if (isDense) {
            flags |= 1;
        }
        if (row.isSequentialAccess()) {
            flags |= 2;
        }
        if (matrix.getRowLabelBindings() != null || matrix.getColumnLabelBindings() != null) {
            flags |= 4;
        }
        if (isSparseRowMatrix = matrix instanceof SparseRowMatrix) {
            flags |= 8;
        }
        out.writeInt(flags);
        out.writeInt(matrix.rowSize());
        out.writeInt(matrix.columnSize());
        byte vectorFlags = VectorWritable.flags(matrix.viewRow(0), false);
        out.writeByte(vectorFlags);
        if (isDense || isSparseRowMatrix) {
            for (int i = 0; i < matrix.rowSize(); ++i) {
                VectorWritable.writeVectorContents(out, matrix.viewRow(i), vectorFlags);
            }
        } else {
            IntArrayList rowIndices = ((SparseMatrix)matrix).nonZeroRowIndices();
            int numNonZeroRows = rowIndices.size();
            out.writeInt(numNonZeroRows);
            for (int i = 0; i < numNonZeroRows; ++i) {
                int rowIndex = rowIndices.getQuick(i);
                out.writeInt(rowIndex);
                VectorWritable.writeVectorContents(out, matrix.viewRow(rowIndex), vectorFlags);
            }
        }
        if ((flags & 4) != 0) {
            MatrixWritable.writeLabelBindings(out, matrix.getColumnLabelBindings(), matrix.getRowLabelBindings());
        }
    }
}

