/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.extraction;

import java.io.File;
import java.io.InputStream;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.ContentStreamHandlerBase;
import org.apache.solr.handler.extraction.ExtractingDocumentLoader;
import org.apache.solr.handler.extraction.ParseContextConfig;
import org.apache.solr.handler.extraction.SolrContentHandlerFactory;
import org.apache.solr.handler.loader.ContentStreamLoader;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.apache.tika.config.TikaConfig;

public class ExtractingRequestHandler
extends ContentStreamHandlerBase
implements SolrCoreAware,
PermissionNameProvider {
    public static final String PARSE_CONTEXT_CONFIG = "parseContext.config";
    public static final String CONFIG_LOCATION = "tika.config";
    protected TikaConfig config;
    protected ParseContextConfig parseContextConfig;
    protected SolrContentHandlerFactory factory;

    public PermissionNameProvider.Name getPermissionName(AuthorizationContext request) {
        return PermissionNameProvider.Name.READ_PERM;
    }

    public void init(NamedList args) {
        super.init(args);
    }

    public void inform(SolrCore core) {
        try {
            String tikaConfigLoc = (String)this.initArgs.get(CONFIG_LOCATION);
            if (tikaConfigLoc == null) {
                ClassLoader classLoader = core.getResourceLoader().getClassLoader();
                try (InputStream is = classLoader.getResourceAsStream("solr-default-tika-config.xml");){
                    this.config = new TikaConfig(is);
                }
            }
            File configFile = new File(tikaConfigLoc);
            if (configFile.isAbsolute()) {
                this.config = new TikaConfig(configFile);
            } else {
                try (InputStream is = core.getResourceLoader().openResource(tikaConfigLoc);){
                    this.config = new TikaConfig(is);
                }
            }
            String parseContextConfigLoc = (String)this.initArgs.get(PARSE_CONTEXT_CONFIG);
            this.parseContextConfig = parseContextConfigLoc == null ? new ParseContextConfig() : new ParseContextConfig(core.getResourceLoader(), parseContextConfigLoc);
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to load Tika Config", (Throwable)e);
        }
        this.factory = this.createFactory();
    }

    protected SolrContentHandlerFactory createFactory() {
        return new SolrContentHandlerFactory();
    }

    protected ContentStreamLoader newLoader(SolrQueryRequest req, UpdateRequestProcessor processor) {
        return new ExtractingDocumentLoader(req, processor, this.config, this.parseContextConfig, this.factory);
    }

    public String getDescription() {
        return "Add/Update Rich document";
    }
}

