/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.misc.search;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.misc.search.DocValuesStats;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;

public class DocValuesStatsCollector
implements Collector {
    private final DocValuesStats<?> stats;

    public DocValuesStatsCollector(DocValuesStats<?> stats) {
        this.stats = stats;
    }

    public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
        boolean shouldProcess = this.stats.init(context);
        if (!shouldProcess) {
            return new LeafCollector(){

                public void setScorer(Scorable scorer) throws IOException {
                }

                public void collect(int doc) throws IOException {
                    DocValuesStatsCollector.this.stats.addMissing();
                }
            };
        }
        return new LeafCollector(){

            public void setScorer(Scorable scorer) throws IOException {
            }

            public void collect(int doc) throws IOException {
                DocValuesStatsCollector.this.stats.accumulate(doc);
            }
        };
    }

    public ScoreMode scoreMode() {
        return ScoreMode.COMPLETE_NO_SCORES;
    }
}

