/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.test.layout;

import java.io.IOException;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.impl.ContextDataFactory;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.spi.DefaultThreadContextStack;
import org.apache.logging.log4j.util.StringMap;
import org.junit.Assert;

public class LogEventFixtures {
    public static Log4jLogEvent createLogEvent() {
        Marker cMarker = MarkerManager.getMarker((String)"Marker1");
        Marker pMarker1 = MarkerManager.getMarker((String)"ParentMarker1");
        Marker pMarker2 = MarkerManager.getMarker((String)"ParentMarker2");
        Marker gfMarker = MarkerManager.getMarker((String)"GrandFatherMarker");
        Marker gmMarker = MarkerManager.getMarker((String)"GrandMotherMarker");
        cMarker.addParents(new Marker[]{pMarker1});
        cMarker.addParents(new Marker[]{pMarker2});
        pMarker1.addParents(new Marker[]{gmMarker});
        pMarker1.addParents(new Marker[]{gfMarker});
        Exception sourceHelper = new Exception();
        sourceHelper.fillInStackTrace();
        NullPointerException cause = new NullPointerException("testNPEx");
        sourceHelper.fillInStackTrace();
        StackTraceElement source = sourceHelper.getStackTrace()[0];
        IOException ioException = new IOException("testIOEx", cause);
        ioException.addSuppressed(new IndexOutOfBoundsException("I am suppressed exception 1"));
        ioException.addSuppressed(new IndexOutOfBoundsException("I am suppressed exception 2"));
        StringMap contextData = ContextDataFactory.createContextData();
        contextData.putValue("MDC.A", (Object)"A_Value");
        contextData.putValue("MDC.B", (Object)"B_Value");
        DefaultThreadContextStack contextStack = new DefaultThreadContextStack(true);
        contextStack.clear();
        contextStack.push("stack_msg1");
        contextStack.add("stack_msg2");
        Log4jLogEvent expected = Log4jLogEvent.newBuilder().setLoggerName("a.B").setMarker(cMarker).setLoggerFqcn("f.q.c.n").setLevel(Level.DEBUG).setMessage((Message)new SimpleMessage("Msg")).setThrown((Throwable)ioException).setContextData(contextData).setContextStack((ThreadContext.ContextStack)contextStack).setThreadName("MyThreadName").setSource(source).setTimeMillis(1L).build();
        return expected;
    }

    public static void assertEqualLogEvents(LogEvent expected, LogEvent actual, boolean includeSource, boolean includeContext, boolean includeStacktrace) {
        Assert.assertEquals(expected.getClass(), actual.getClass());
        Assert.assertEquals((Object)(includeContext ? expected.getContextData() : ContextDataFactory.createContextData()), (Object)actual.getContextData());
        Assert.assertEquals((Object)expected.getContextStack(), (Object)actual.getContextStack());
        Assert.assertEquals((Object)expected.getLevel(), (Object)actual.getLevel());
        Assert.assertEquals((Object)expected.getLoggerName(), (Object)actual.getLoggerName());
        Assert.assertEquals((Object)expected.getLoggerFqcn(), (Object)actual.getLoggerFqcn());
        Assert.assertEquals((Object)expected.getMarker(), (Object)actual.getMarker());
        Assert.assertEquals((Object)expected.getMessage(), (Object)actual.getMessage());
        Assert.assertEquals((long)expected.getTimeMillis(), (long)actual.getTimeMillis());
        Assert.assertEquals((Object)(includeSource ? expected.getSource() : null), (Object)actual.getSource());
        Assert.assertEquals((Object)expected.getThreadName(), (Object)actual.getThreadName());
        Assert.assertNotNull((String)"original should have an exception", (Object)expected.getThrown());
        Assert.assertNull((String)"exception should not be serialized", (Object)actual.getThrown());
        Assert.assertEquals((Object)expected.isEndOfBatch(), (Object)actual.isEndOfBatch());
        Assert.assertEquals((Object)expected.isIncludeLocation(), (Object)actual.isIncludeLocation());
        Assert.assertNotEquals((long)expected.hashCode(), (long)actual.hashCode());
        Assert.assertNotEquals((Object)expected, (Object)actual);
    }
}

