/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.rolling.action.internal;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.zip.GZIPOutputStream;
import org.apache.logging.log4j.core.appender.rolling.action.AbstractCompressAction;

public final class GzCompressAction
extends AbstractCompressAction {
    private final int compressionLevel;

    public GzCompressAction(Path source, Path destination, int compressionLevel) {
        super(source, destination);
        this.compressionLevel = compressionLevel;
    }

    @Override
    protected OutputStream wrapOutputStream(OutputStream stream) throws IOException {
        ConfigurableLevelGZIPOutputStream gzipOut = new ConfigurableLevelGZIPOutputStream(stream, 8192, this.compressionLevel);
        return new BufferedOutputStream(gzipOut, 8192);
    }

    @Override
    protected String getAlgorithmName() {
        return "GZ";
    }

    private static final class ConfigurableLevelGZIPOutputStream
    extends GZIPOutputStream {
        ConfigurableLevelGZIPOutputStream(OutputStream out, int bufSize, int level) throws IOException {
            super(out, bufSize);
            this.def.setLevel(level);
        }
    }
}

