/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.audit;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.audit.AuditEvent;
import org.apache.logging.log4j.audit.AuditExceptionHandler;
import org.apache.logging.log4j.audit.AuditLogger;
import org.apache.logging.log4j.audit.AuditMessage;
import org.apache.logging.log4j.audit.annotation.Constraint;
import org.apache.logging.log4j.audit.annotation.Constraints;
import org.apache.logging.log4j.audit.annotation.MaxLength;
import org.apache.logging.log4j.audit.annotation.RequestContext;
import org.apache.logging.log4j.audit.annotation.RequestContextConstraints;
import org.apache.logging.log4j.audit.annotation.Required;
import org.apache.logging.log4j.audit.exception.AuditException;
import org.apache.logging.log4j.audit.exception.ConstraintValidationException;
import org.apache.logging.log4j.audit.util.NamingUtils;
import org.apache.logging.log4j.catalog.api.plugins.ConstraintPlugins;
import org.apache.logging.log4j.message.StructuredDataMessage;

public class LogEventFactory {
    private static final Logger logger = LogManager.getLogger(LogEventFactory.class);
    private static final AuditLogger AUDIT_LOGGER = new AuditLogger();
    private static final int DEFAULT_MAX_LENGTH = 32;
    private static final AuditExceptionHandler DEFAULT_HANDLER = (message, ex) -> {
        throw new AuditException("Error logging event " + message.getId().getName(), ex);
    };
    private static final AuditExceptionHandler NOOP_EXCEPTION_HANDLER = (message, ex) -> {};
    private static AuditExceptionHandler defaultExceptionHandler = DEFAULT_HANDLER;
    private static ConcurrentMap<Class<?>, List<Property>> classMap = new ConcurrentHashMap();
    private static ConstraintPlugins constraintPlugins = ConstraintPlugins.getInstance();

    public static void setDefaultHandler(AuditExceptionHandler exceptionHandler) {
        defaultExceptionHandler = exceptionHandler == null ? NOOP_EXCEPTION_HANDLER : exceptionHandler;
    }

    static void resetDefaultHandler() {
        defaultExceptionHandler = DEFAULT_HANDLER;
    }

    public static <T extends AuditEvent> T getEvent(Class<T> intrface) {
        Class[] interfaces = new Class[]{intrface};
        AuditMessage msg = LogEventFactory.buildAuditMessage(intrface);
        AuditEvent audit = (AuditEvent)Proxy.newProxyInstance(intrface.getClassLoader(), interfaces, (InvocationHandler)new AuditProxy(msg, intrface, defaultExceptionHandler));
        return (T)audit;
    }

    private static <T> int getMaxLength(Class<T> intrface) {
        MaxLength maxLength = intrface.getAnnotation(MaxLength.class);
        return maxLength == null ? 32 : maxLength.value();
    }

    private static AuditMessage buildAuditMessage(Class<?> intrface) {
        String eventId = NamingUtils.lowerFirst(intrface.getSimpleName());
        int msgLength = LogEventFactory.getMaxLength(intrface);
        return new AuditMessage(eventId, msgLength);
    }

    public static void logEvent(Class<?> intrface, Map<String, String> properties) {
        LogEventFactory.logEvent(intrface, properties, DEFAULT_HANDLER);
    }

    public static void logEvent(Class<?> intrface, Map<String, String> properties, AuditExceptionHandler handler) {
        AuditMessage msg = LogEventFactory.buildAuditMessage(intrface);
        if (properties != null) {
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                msg.put(entry.getKey(), entry.getValue());
            }
        }
        LogEventFactory.validateEvent(intrface, msg);
        LogEventFactory.logEvent(msg, handler);
    }

    private static void validateEvent(Class<?> intrface, AuditMessage msg) {
        StringBuilder errors = new StringBuilder();
        LogEventFactory.validateContextConstraints(intrface, errors);
        List<Property> props = LogEventFactory.getProperties(intrface);
        HashMap<String, Property> propertyMap = new HashMap<String, Property>();
        for (Property property : props) {
            propertyMap.put(property.name, property);
            if (property.isRequired && !msg.containsKey(property.name)) {
                if (errors.length() > 0) {
                    errors.append("\n");
                }
                errors.append("Required attribute ").append(property.name).append(" is missing from ").append(msg.getId().getName());
            }
            if (!msg.containsKey(property.name)) continue;
            LogEventFactory.validateConstraints(false, property.constraints, property.name, msg, errors);
        }
        msg.forEach((key, value) -> {
            if (!propertyMap.containsKey(key) && errors.length() > 0) {
                errors.append("Attribute ").append((String)key).append(" is not defined for ").append(msg.getId().getName());
            }
        });
        if (errors.length() > 0) {
            throw new ConstraintValidationException(errors.toString());
        }
    }

    public static void logEvent(AuditMessage msg, AuditExceptionHandler handler) {
        LogEventFactory.runMessageAction(() -> AUDIT_LOGGER.logEvent(msg), msg, handler);
    }

    private static void runMessageAction(Runnable action, AuditMessage msg, AuditExceptionHandler handler) {
        try {
            action.run();
        }
        catch (Throwable ex) {
            if (handler == null) {
                handler = defaultExceptionHandler;
            }
            handler.handleException(msg, ex);
        }
    }

    public static List<String> getPropertyNames(String className) {
        ArrayList<String> names;
        Class<?> intrface = LogEventFactory.getClass(className);
        if (intrface != null) {
            List<Property> props = LogEventFactory.getProperties(intrface);
            names = new ArrayList(props.size());
            for (Property prop : props) {
                names.add(prop.name);
            }
        } else {
            names = new ArrayList<String>();
        }
        return names;
    }

    private static List<Property> getProperties(Class<?> intrface) {
        ArrayList<Property> props = (ArrayList<Property>)classMap.get(intrface);
        if (props != null) {
            return props;
        }
        props = new ArrayList<Property>();
        Method[] methods = intrface.getMethods();
        boolean isCompletionStatus = false;
        for (Method method : methods) {
            if (!method.getName().startsWith("set") || method.getName().equals("setAuditExceptionHandler")) continue;
            if (method.getName().equals("setCompletionStatus")) {
                isCompletionStatus = true;
            }
            String name = NamingUtils.lowerFirst(NamingUtils.getMethodShortName(method.getName()));
            Annotation[] annotations = method.getDeclaredAnnotations();
            ArrayList<Constraint> constraints = new ArrayList<Constraint>();
            boolean isRequired = false;
            for (Annotation annotation : annotations) {
                if (annotation instanceof Constraint) {
                    constraints.add((Constraint)annotation);
                }
                if (!(annotation instanceof Required)) continue;
                isRequired = true;
            }
            props.add(new Property(name, isRequired, constraints));
        }
        if (!isCompletionStatus) {
            props.add(new Property("completionStatus", false, new ArrayList<Constraint>()));
        }
        classMap.putIfAbsent(intrface, props);
        return (List)classMap.get(intrface);
    }

    private static Class<?> getClass(String className) {
        try {
            Class<?> intrface = Class.forName(className);
            if (AuditEvent.class.isAssignableFrom(intrface)) {
                return intrface;
            }
            logger.error(className + " is not an AuditEvent");
        }
        catch (ClassNotFoundException cnfe) {
            logger.error("Unable to locate class {}", (Object)className);
        }
        return null;
    }

    private static void validateConstraints(boolean isRequestContext, Constraint[] constraints, String name, AuditMessage msg, StringBuilder errors) {
        String value = isRequestContext ? ThreadContext.get((String)name) : msg.get(name);
        LogEventFactory.validateConstraints(isRequestContext, constraints, name, value, errors);
    }

    private static void validateConstraints(boolean isRequestContext, Constraint[] constraints, String name, String value, StringBuilder errors) {
        for (Constraint constraint : constraints) {
            constraintPlugins.validateConstraint(isRequestContext, constraint.constraintType(), name, value, constraint.constraintValue(), errors);
        }
    }

    private static void validateContextConstraints(Class<?> intrface, StringBuilder buffer) {
        RequestContextConstraints reqCtxConstraints = intrface.getAnnotation(RequestContextConstraints.class);
        if (reqCtxConstraints != null) {
            for (RequestContext ctx : reqCtxConstraints.value()) {
                LogEventFactory.validateContextConstraint(ctx, buffer);
            }
        } else {
            RequestContext ctx = intrface.getAnnotation(RequestContext.class);
            LogEventFactory.validateContextConstraint(ctx, buffer);
        }
    }

    private static void validateContextConstraint(RequestContext constraint, StringBuilder errors) {
        if (constraint == null) {
            return;
        }
        String value = ThreadContext.get((String)constraint.key());
        if (value != null) {
            LogEventFactory.validateConstraints(true, constraint.constraints(), constraint.key(), value, errors);
        } else if (constraint.required()) {
            org.apache.logging.log4j.catalog.api.util.StringUtils.appendNewline((StringBuilder)errors);
            errors.append("ThreadContext does not contain required key ").append(constraint.key());
        }
    }

    private static boolean isBlank(String value) {
        return value != null && value.length() > 0;
    }

    private static class Property {
        private final String name;
        private final boolean isRequired;
        private final Constraint[] constraints;

        public Property(String name, boolean isRequired, List<Constraint> constraints) {
            this.name = name;
            this.constraints = constraints.toArray(new Constraint[constraints.size()]);
            this.isRequired = isRequired;
        }
    }

    private static class AuditProxy
    implements InvocationHandler {
        private final AuditMessage msg;
        private final Class<?> intrface;
        private AuditExceptionHandler auditExceptionHandler;

        AuditProxy(AuditMessage msg, Class<?> intrface, AuditExceptionHandler auditExceptionHandler) {
            this.msg = msg;
            this.intrface = intrface;
            this.auditExceptionHandler = auditExceptionHandler;
        }

        public AuditMessage getMessage() {
            return this.msg;
        }

        @Override
        public Object invoke(Object o, Method method, Object[] objects) {
            if (method.getName().equals("toString") && method.getParameterCount() == 0) {
                return this.msg.toString();
            }
            if (method.getName().equals("logEvent")) {
                LogEventFactory.runMessageAction(() -> LogEventFactory.validateEvent(this.intrface, this.msg), this.msg, this.auditExceptionHandler);
                LogEventFactory.logEvent(this.msg, this.auditExceptionHandler);
                return null;
            }
            if (method.getName().equals("setCompletionStatus")) {
                if (objects == null || objects[0] == null) {
                    throw new IllegalArgumentException("Missing completion status");
                }
                String name = NamingUtils.lowerFirst(NamingUtils.getMethodShortName(method.getName()));
                this.msg.put(name, objects[0].toString());
                return null;
            }
            if (method.getName().equals("setAuditExceptionHandler")) {
                if (objects == null || objects[0] == null) {
                    this.auditExceptionHandler = NOOP_EXCEPTION_HANDLER;
                } else if (objects[0] instanceof AuditExceptionHandler) {
                    this.auditExceptionHandler = (AuditExceptionHandler)objects[0];
                } else {
                    throw new IllegalArgumentException(objects[0] + " is not an " + AuditExceptionHandler.class.getName());
                }
                return null;
            }
            if (method.getName().startsWith("set")) {
                LogEventFactory.runMessageAction(() -> this.setProperty(method, objects), this.msg, this.auditExceptionHandler);
                return null;
            }
            return null;
        }

        private void setProperty(Method method, Object[] objects) {
            String result;
            Annotation[] annotations;
            String name = NamingUtils.lowerFirst(NamingUtils.getMethodShortName(method.getName()));
            if (objects == null || objects[0] == null) {
                throw new IllegalArgumentException("No value to be set for " + name);
            }
            StringBuilder errors = new StringBuilder();
            for (Annotation annotation : annotations = method.getDeclaredAnnotations()) {
                if (annotation instanceof Constraints) {
                    Constraints constraints = (Constraints)annotation;
                    LogEventFactory.validateConstraints(false, constraints.value(), name, objects[0].toString(), errors);
                    continue;
                }
                if (!(annotation instanceof Constraint)) continue;
                Constraint constraint = (Constraint)annotation;
                constraintPlugins.validateConstraint(false, constraint.constraintType(), name, objects[0].toString(), constraint.constraintValue(), errors);
            }
            if (errors.length() > 0) {
                throw new ConstraintValidationException(errors.toString());
            }
            if (objects[0] instanceof List) {
                result = StringUtils.join((Object[])objects, (String)", ");
            } else {
                if (objects[0] instanceof Map) {
                    StructuredDataMessage extra = new StructuredDataMessage(name, null, null);
                    extra.putAll((Map)objects[0]);
                    this.msg.addContent(name, extra);
                    return;
                }
                result = objects[0].toString();
            }
            this.msg.put(name, result);
        }
    }
}

