/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.linkis.monitor.jobhistory.entity;

import org.apache.linkis.monitor.jobhistory.QueryUtils;

import java.util.Date;

public class JobHistory {

  private Long id;

  private String jobReqId;

  private String submitUser;

  private String executeUser;

  private String source;

  private String labels;

  private String params;

  private String progress;

  private String status;

  private String logPath;

  private Integer errorCode;

  private String errorDesc;

  private Date createdTime;

  private Date updatedTime;

  private String updateTimeMills;

  private String instances;

  private String metrics;

  private String engineType;

  private String executionCode;

  private String observeInfo;

  private String orgId;

  private String orgName;

  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  public String getJobReqId() {
    return jobReqId;
  }

  public void setJobReqId(String jobReqId) {
    this.jobReqId = jobReqId;
  }

  public String getSubmitUser() {
    return submitUser;
  }

  public void setSubmitUser(String submitUser) {
    this.submitUser = submitUser;
  }

  public String getExecuteUser() {
    return executeUser;
  }

  public void setExecuteUser(String executeUser) {
    this.executeUser = executeUser;
  }

  public String getSource() {
    return source;
  }

  public void setSource(String source) {
    this.source = source;
  }

  public String getLabels() {
    return labels;
  }

  public void setLabels(String labels) {
    this.labels = labels;
  }

  public String getParams() {
    return params;
  }

  public void setParams(String params) {
    this.params = params;
  }

  public String getProgress() {
    return progress;
  }

  public void setProgress(String progress) {
    this.progress = progress;
  }

  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }

  public String getLogPath() {
    return logPath;
  }

  public void setLogPath(String logPath) {
    this.logPath = logPath;
  }

  public Integer getErrorCode() {
    return errorCode;
  }

  public void setErrorCode(Integer errorCode) {
    this.errorCode = errorCode;
  }

  public String getErrorDesc() {
    return errorDesc;
  }

  public void setErrorDesc(String errorDesc) {
    this.errorDesc = errorDesc;
  }

  public Date getCreatedTime() {
    return createdTime;
  }

  public void setCreatedTime(Date createdTime) {
    this.createdTime = createdTime;
  }

  public Date getUpdatedTime() {
    return updatedTime;
  }

  public void setUpdatedTime(Date updatedTime) {
    this.updatedTime = updatedTime;
  }

  public String getInstances() {
    return instances;
  }

  public void setInstances(String instances) {
    this.instances = instances;
  }

  public String getMetrics() {
    return metrics;
  }

  public void setMetrics(String metrics) {
    this.metrics = metrics;
  }

  public String getEngineType() {
    return engineType;
  }

  public void setEngineType(String engineType) {
    this.engineType = engineType;
  }

  public String getExecutionCode() {
    return executionCode;
  }

  public void setExecutionCode(String executionCode) {
    this.executionCode = executionCode;
  }

  public String getUpdateTimeMills() {
    return QueryUtils.dateToString(getUpdatedTime());
  }

  public String getObserveInfo() {
    return observeInfo;
  }

  public void setObserveInfo(String observeInfo) {
    this.observeInfo = observeInfo;
  }

  public String getOrgId() {
    return orgId;
  }

  public void setOrgId(String orgId) {
    this.orgId = orgId;
  }

  public String getOrgName() {
    return orgName;
  }

  public void setOrgName(String orgName) {
    this.orgName = orgName;
  }

  @Override
  public String toString() {
    return "JobHistory{"
        + "id="
        + id
        + ", jobReqId='"
        + jobReqId
        + '\''
        + ", submitUser='"
        + submitUser
        + '\''
        + ", executeUser='"
        + executeUser
        + '\''
        + ", source='"
        + source
        + '\''
        + ", labels='"
        + labels
        + '\''
        + ", params='"
        + params
        + '\''
        + ", progress='"
        + progress
        + '\''
        + ", status='"
        + status
        + '\''
        + ", logPath='"
        + logPath
        + '\''
        + ", errorCode="
        + errorCode
        + ", errorDesc='"
        + errorDesc
        + '\''
        + ", createdTime="
        + createdTime
        + ", updatedTime="
        + updatedTime
        + ", updateTimeMills='"
        + updateTimeMills
        + '\''
        + ", instances='"
        + instances
        + '\''
        + ", metrics='"
        + metrics
        + '\''
        + ", engineType='"
        + engineType
        + '\''
        + ", executionCode='"
        + executionCode
        + '\''
        + ", observeInfo='"
        + observeInfo
        + '\''
        + '}';
  }
}
