/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine.jdbc.phoenix;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.BitSet;
import org.apache.hive.service.rpc.thrift.TBoolColumn;
import org.apache.hive.service.rpc.thrift.TBoolValue;
import org.apache.hive.service.rpc.thrift.TByteColumn;
import org.apache.hive.service.rpc.thrift.TByteValue;
import org.apache.hive.service.rpc.thrift.TColumn;
import org.apache.hive.service.rpc.thrift.TColumnValue;
import org.apache.hive.service.rpc.thrift.TDoubleColumn;
import org.apache.hive.service.rpc.thrift.TDoubleValue;
import org.apache.hive.service.rpc.thrift.TI16Column;
import org.apache.hive.service.rpc.thrift.TI16Value;
import org.apache.hive.service.rpc.thrift.TI32Column;
import org.apache.hive.service.rpc.thrift.TI32Value;
import org.apache.hive.service.rpc.thrift.TI64Column;
import org.apache.hive.service.rpc.thrift.TI64Value;
import org.apache.hive.service.rpc.thrift.TStringColumn;
import org.apache.hive.service.rpc.thrift.TStringValue;
import org.apache.kyuubi.engine.jdbc.schema.Column;
import org.apache.kyuubi.engine.jdbc.schema.RowSetHelper;
import org.apache.kyuubi.util.RowSetUtils$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00194A!\u0002\u0004\u0001'!)!\u0004\u0001C\u00017!)a\u0004\u0001C\t?!)\u0001\n\u0001C\t\u0013\")\u0011\f\u0001C\t5\n\u0019\u0002\u000b[8f]&D(k\\<TKRDU\r\u001c9fe*\u0011q\u0001C\u0001\ba\"|WM\\5y\u0015\tI!\"\u0001\u0003kI\n\u001c'BA\u0006\r\u0003\u0019)gnZ5oK*\u0011QBD\u0001\u0007Wf,XOY5\u000b\u0005=\u0001\u0012AB1qC\u000eDWMC\u0001\u0012\u0003\ry'oZ\u0002\u0001'\t\u0001A\u0003\u0005\u0002\u001615\taC\u0003\u0002\u0018\u0011\u000511o\u00195f[\u0006L!!\u0007\f\u0003\u0019I{woU3u\u0011\u0016d\u0007/\u001a:\u0002\rqJg.\u001b;?)\u0005a\u0002CA\u000f\u0001\u001b\u00051\u0011!\u0003;p)\u000e{G.^7o)\u0011\u0001C&\u0011$\u0011\u0005\u0005RS\"\u0001\u0012\u000b\u0005\r\"\u0013A\u0002;ie&4GO\u0003\u0002&M\u0005\u0019!\u000f]2\u000b\u0005\u001dB\u0013aB:feZL7-\u001a\u0006\u0003S9\tA\u0001[5wK&\u00111F\t\u0002\b)\u000e{G.^7o\u0011\u0015i#\u00011\u0001/\u0003\u0011\u0011xn^:\u0011\u0007=JDH\u0004\u00021m9\u0011\u0011\u0007N\u0007\u0002e)\u00111GE\u0001\u0007yI|w\u000e\u001e \n\u0003U\nQa]2bY\u0006L!a\u000e\u001d\u0002\u000fA\f7m[1hK*\tQ'\u0003\u0002;w\t\u00191+Z9\u000b\u0005]B\u0004cA\u0018:{A\u0011ahP\u0007\u0002q%\u0011\u0001\t\u000f\u0002\u0004\u0003:L\b\"\u0002\"\u0003\u0001\u0004\u0019\u0015aB8sI&t\u0017\r\u001c\t\u0003}\u0011K!!\u0012\u001d\u0003\u0007%sG\u000fC\u0003H\u0005\u0001\u00071)A\u0004tc2$\u0016\u0010]3\u0002\u001dQ|GkQ8mk6tg+\u00197vKR!!*\u0014(T!\t\t3*\u0003\u0002ME\taAkQ8mk6tg+\u00197vK\")!i\u0001a\u0001\u0007\")qj\u0001a\u0001!\u0006\u0019!o\\<\u0011\u0007=\nV(\u0003\u0002Sw\t!A*[:u\u0011\u0015!6\u00011\u0001V\u0003\u0015!\u0018\u0010]3t!\ry\u0013K\u0016\t\u0003+]K!\u0001\u0017\f\u0003\r\r{G.^7o\u00031!x\u000eS5wKN#(/\u001b8h)\rY6-\u001a\t\u00039\u0002t!!\u00180\u0011\u0005EB\u0014BA09\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011M\u0019\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005}C\u0004\"\u00023\u0005\u0001\u0004i\u0014\u0001\u00023bi\u0006DQa\u0012\u0003A\u0002\r\u0003")
public class PhoenixRowSetHelper
extends RowSetHelper {
    @Override
    public TColumn toTColumn(Seq<Seq<Object>> rows, int ordinal, int sqlType) {
        BitSet nulls = new BitSet();
        int n2 = sqlType;
        switch (n2) {
            case -7: {
                java.util.List<Boolean> values = this.getOrSetAsNull(rows, ordinal, nulls, Predef$.MODULE$.boolean2Boolean(true));
                return TColumn.boolVal((TBoolColumn)new TBoolColumn(values, RowSetUtils$.MODULE$.bitSetToBuffer(nulls)));
            }
            case -6: {
                java.util.List<Byte> values = this.getOrSetAsNull(rows, ordinal, nulls, Predef$.MODULE$.byte2Byte((byte)0));
                return TColumn.byteVal((TByteColumn)new TByteColumn(values, RowSetUtils$.MODULE$.bitSetToBuffer(nulls)));
            }
            case 5: {
                java.util.List<Short> values = this.getOrSetAsNull(rows, ordinal, nulls, Predef$.MODULE$.short2Short((short)0));
                return TColumn.i16Val((TI16Column)new TI16Column(values, RowSetUtils$.MODULE$.bitSetToBuffer(nulls)));
            }
            case 4: {
                java.util.List<Integer> values = this.getOrSetAsNull(rows, ordinal, nulls, Predef$.MODULE$.int2Integer(0));
                return TColumn.i32Val((TI32Column)new TI32Column(values, RowSetUtils$.MODULE$.bitSetToBuffer(nulls)));
            }
            case -5: {
                java.util.List<Long> values = this.getOrSetAsNull(rows, ordinal, nulls, Predef$.MODULE$.long2Long(0L));
                return TColumn.i64Val((TI64Column)new TI64Column(values, RowSetUtils$.MODULE$.bitSetToBuffer(nulls)));
            }
            case 7: {
                java.util.List values = (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.getOrSetAsNull(rows, ordinal, nulls, Predef$.MODULE$.float2Float(0.0f))).asScala()).map((Function1 & Serializable & scala.Serializable)n -> Double.valueOf(n.toString()), Buffer$.MODULE$.canBuildFrom())).asJava();
                return TColumn.doubleVal((TDoubleColumn)new TDoubleColumn(values, RowSetUtils$.MODULE$.bitSetToBuffer(nulls)));
            }
            case 8: {
                java.util.List<Double> values = this.getOrSetAsNull(rows, ordinal, nulls, Predef$.MODULE$.double2Double(0.0));
                return TColumn.doubleVal((TDoubleColumn)new TDoubleColumn(values, RowSetUtils$.MODULE$.bitSetToBuffer(nulls)));
            }
            case 1: 
            case 12: {
                java.util.List<String> values = this.getOrSetAsNull(rows, ordinal, nulls, "");
                return TColumn.stringVal((TStringColumn)new TStringColumn(values, RowSetUtils$.MODULE$.bitSetToBuffer(nulls)));
            }
        }
        int rowSize = rows.length();
        ArrayList<String> values = new ArrayList<String>(rowSize);
        for (int i = 0; i < rowSize; ++i) {
            Seq row = (Seq)rows.apply(i);
            nulls.set(i, row.apply(ordinal) == null);
            String value = row.apply(ordinal) == null ? "" : this.toHiveString(row.apply(ordinal), sqlType);
            values.add(value);
        }
        return TColumn.stringVal((TStringColumn)new TStringColumn(values, RowSetUtils$.MODULE$.bitSetToBuffer(nulls)));
    }

    @Override
    public TColumnValue toTColumnValue(int ordinal, List<Object> row, List<Column> types) {
        TStringValue tStrValue;
        block18: {
            int n = ((Column)types.apply(ordinal)).sqlType();
            switch (n) {
                case -7: {
                    TBoolValue boolValue = new TBoolValue();
                    if (row.apply(ordinal) != null) {
                        boolValue.setValue(BoxesRunTime.unboxToBoolean((Object)row.apply(ordinal)));
                    }
                    return TColumnValue.boolVal((TBoolValue)boolValue);
                }
                case -6: {
                    TByteValue byteValue = new TByteValue();
                    if (row.apply(ordinal) != null) {
                        byteValue.setValue(BoxesRunTime.unboxToByte((Object)row.apply(ordinal)));
                    }
                    return TColumnValue.byteVal((TByteValue)byteValue);
                }
                case 5: {
                    TI16Value tI16Value = new TI16Value();
                    if (row.apply(ordinal) != null) {
                        tI16Value.setValue(BoxesRunTime.unboxToShort((Object)row.apply(ordinal)));
                    }
                    return TColumnValue.i16Val((TI16Value)tI16Value);
                }
                case 4: {
                    TI32Value tI32Value = new TI32Value();
                    if (row.apply(ordinal) != null) {
                        tI32Value.setValue(BoxesRunTime.unboxToInt((Object)row.apply(ordinal)));
                    }
                    return TColumnValue.i32Val((TI32Value)tI32Value);
                }
                case -5: {
                    TI64Value tI64Value = new TI64Value();
                    if (row.apply(ordinal) != null) {
                        tI64Value.setValue(BoxesRunTime.unboxToLong((Object)row.apply(ordinal)));
                    }
                    return TColumnValue.i64Val((TI64Value)tI64Value);
                }
                case 7: {
                    TDoubleValue tDoubleValue = new TDoubleValue();
                    if (row.apply(ordinal) != null) {
                        Double doubleValue = Double.valueOf(Float.toString(BoxesRunTime.unboxToFloat((Object)row.apply(ordinal))));
                        tDoubleValue.setValue(Predef$.MODULE$.Double2double(doubleValue));
                    }
                    return TColumnValue.doubleVal((TDoubleValue)tDoubleValue);
                }
                case 8: {
                    TDoubleValue tDoubleValue = new TDoubleValue();
                    if (row.apply(ordinal) != null) {
                        tDoubleValue.setValue(BoxesRunTime.unboxToDouble((Object)row.apply(ordinal)));
                    }
                    return TColumnValue.doubleVal((TDoubleValue)tDoubleValue);
                }
                case 1: 
                case 12: {
                    TStringValue tStringValue = new TStringValue();
                    if (row.apply(ordinal) != null) {
                        tStringValue.setValue((String)row.apply(ordinal));
                    }
                    return TColumnValue.stringVal((TStringValue)tStringValue);
                }
            }
            tStrValue = new TStringValue();
            if (row.apply(ordinal) == null) break block18;
            tStrValue.setValue(this.toHiveString(row.apply(ordinal), ((Column)types.apply(ordinal)).sqlType()));
        }
        return TColumnValue.stringVal((TStringValue)tStrValue);
    }

    public String toHiveString(Object data, int sqlType) {
        Tuple2 tuple2 = new Tuple2(data, (Object)BoxesRunTime.boxToInteger((int)sqlType));
        if (tuple2 != null) {
            Object date = tuple2._1();
            int n = tuple2._2$mcI$sp();
            if (date instanceof Date) {
                Date date2 = (Date)date;
                if (91 == n) {
                    return RowSetUtils$.MODULE$.formatDate((java.util.Date)date2);
                }
            }
        }
        if (tuple2 != null) {
            Object dateTime = tuple2._1();
            int n = tuple2._2$mcI$sp();
            if (dateTime instanceof LocalDateTime) {
                LocalDateTime localDateTime = (LocalDateTime)dateTime;
                if (93 == n) {
                    return RowSetUtils$.MODULE$.formatLocalDateTime(localDateTime);
                }
            }
        }
        if (tuple2 != null) {
            Object decimal = tuple2._1();
            int n = tuple2._2$mcI$sp();
            if (decimal instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)decimal;
                if (3 == n) {
                    return bigDecimal.toPlainString();
                }
            }
        }
        if (tuple2 != null) {
            Object other = tuple2._1();
            return other.toString();
        }
        throw new MatchError((Object)tuple2);
    }
}

