/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.sql.zorder;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Locale;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.commons.codec.binary.Hex;
import org.apache.kyuubi.sql.KyuubiSQLConf$;
import org.apache.kyuubi.sql.zorder.OptimizeZorderStatementBase;
import org.apache.kyuubi.sql.zorder.ZorderBase;
import org.apache.kyuubi.sql.zorder.ZorderSqlExtensionsBaseVisitor;
import org.apache.kyuubi.sql.zorder.ZorderSqlExtensionsParser;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedStar;
import org.apache.spark.sql.catalyst.expressions.And;
import org.apache.spark.sql.catalyst.expressions.Ascending$;
import org.apache.spark.sql.catalyst.expressions.EqualNullSafe;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GreaterThan;
import org.apache.spark.sql.catalyst.expressions.GreaterThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.LessThan;
import org.apache.spark.sql.catalyst.expressions.LessThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Not;
import org.apache.spark.sql.catalyst.expressions.NullOrdering;
import org.apache.spark.sql.catalyst.expressions.NullsLast$;
import org.apache.spark.sql.catalyst.expressions.Or;
import org.apache.spark.sql.catalyst.expressions.SortDirection;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.catalyst.parser.ParserUtils$;
import org.apache.spark.sql.catalyst.plans.logical.Filter;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.plans.logical.Sort;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.sql.hive.HiveAnalysis$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Array$;
import scala.Double$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\t%e!\u0002\u000f\u001e\u0003\u0003A\u0003\"B\u001a\u0001\t\u0003!\u0004\"\u0002\u001c\u0001\r\u00039\u0004\"\u0002+\u0001\r\u0003)\u0006\"\u00028\u0001\t#y\u0007\"\u0002?\u0001\t#i\bBB@\u0001\t\u0003\n\t\u0001C\u0004\u0002(\u0001!\t%!\u000b\t\u000f\u0005M\u0002\u0001\"\u0011\u00026!9\u0011q\b\u0001\u0005B\u0005\u0005\u0003bBA&\u0001\u0011\u0005\u0013Q\n\u0005\b\u0003/\u0002A\u0011IA-\u0011\u001d\t\u0019\u0007\u0001C!\u0003KBq!! \u0001\t\u0003\ny\bC\u0004\u0002\u0010\u0002!\t%!%\t\u000f\u0005m\u0005\u0001\"\u0011\u0002\u001e\"9\u0011q\u0015\u0001\u0005B\u0005%\u0006bBAZ\u0001\u0011\u0005\u0013Q\u0017\u0005\b\u0003\u007f\u0003A\u0011BAa\u0011\u001d\t\u0019\u0010\u0001C!\u0003kDq!a@\u0001\t\u0003\u0012\t\u0001C\u0004\u0003\f\u0001!\tE!\u0004\t\u000f\t]\u0001\u0001\"\u0011\u0003\u001a!9!1\u0005\u0001\u0005B\t\u0015\u0002b\u0002B\u0018\u0001\u0011\u0005#\u0011\u0007\u0005\b\u0005w\u0001A\u0011\u0002B\u001f\u0011\u001d\u0011\t\u0005\u0001C\u0005\u0005\u0007BqA!\u001a\u0001\t\u0013\u00119GA\f[_J$WM]*rY\u0006\u001bHOQ;jY\u0012,'OQ1tK*\u0011adH\u0001\u0007u>\u0014H-\u001a:\u000b\u0005\u0001\n\u0013aA:rY*\u0011!eI\u0001\u0007Wf,XOY5\u000b\u0005\u0011*\u0013AB1qC\u000eDWMC\u0001'\u0003\ry'oZ\u0002\u0001'\t\u0001\u0011\u0006E\u0002+W5j\u0011!H\u0005\u0003Yu\u0011aDW8sI\u0016\u00148+\u001d7FqR,gn]5p]N\u0014\u0015m]3WSNLGo\u001c:\u0011\u00059\nT\"A\u0018\u000b\u0003A\nQa]2bY\u0006L!AM\u0018\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tQ\u0007\u0005\u0002+\u0001\u0005Y!-^5mIj{'\u000fZ3s)\tA4\b\u0005\u0002+s%\u0011!(\b\u0002\u000b5>\u0014H-\u001a:CCN,\u0007\"\u0002\u001f\u0003\u0001\u0004i\u0014!B2iS2$\u0007c\u0001 G\u0013:\u0011q\b\u0012\b\u0003\u0001\u000ek\u0011!\u0011\u0006\u0003\u0005\u001e\na\u0001\u0010:p_Rt\u0014\"\u0001\u0019\n\u0005\u0015{\u0013a\u00029bG.\fw-Z\u0005\u0003\u000f\"\u00131aU3r\u0015\t)u\u0006\u0005\u0002K%6\t1J\u0003\u0002M\u001b\u0006YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\tqu*\u0001\u0005dCR\fG._:u\u0015\t\u0001\u0003K\u0003\u0002RG\u0005)1\u000f]1sW&\u00111k\u0013\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017\u0001\b2vS2$w\n\u001d;j[&TXMW8sI\u0016\u00148\u000b^1uK6,g\u000e\u001e\u000b\u0004-f#\u0007C\u0001\u0016X\u0013\tAVDA\u000ePaRLW.\u001b>f5>\u0014H-\u001a:Ti\u0006$X-\\3oi\n\u000b7/\u001a\u0005\u00065\u000e\u0001\raW\u0001\u0010i\u0006\u0014G.Z%eK:$\u0018NZ5feB\u0019aH\u0012/\u0011\u0005u\u000bgB\u00010`!\t\u0001u&\u0003\u0002a_\u00051\u0001K]3eK\u001aL!AY2\u0003\rM#(/\u001b8h\u0015\t\u0001w\u0006C\u0003f\u0007\u0001\u0007a-A\u0003rk\u0016\u0014\u0018\u0010\u0005\u0002hY6\t\u0001N\u0003\u0002jU\u00069An\\4jG\u0006d'BA6N\u0003\u0015\u0001H.\u00198t\u0013\ti\u0007NA\u0006M_\u001eL7-\u00197QY\u0006t\u0017AC3yaJ,7o]5p]R\u0011\u0011\n\u001d\u0005\u0006c\u0012\u0001\rA]\u0001\u0004GRD\bCA:{\u001b\u0005!(BA;w\u0003\u001d\u0011XO\u001c;j[\u0016T!a\u001e=\u0002\u0005Y$$BA=&\u0003\u0015\tg\u000e\u001e7s\u0013\tYHOA\tQCJ\u001cXM\u001d*vY\u0016\u001cuN\u001c;fqR\f\u0011\"\\;mi&\u0004\u0016M\u001d;\u0015\u0005ms\b\"B9\u0006\u0001\u0004\u0011\u0018\u0001\u0006<jg&$8+\u001b8hY\u0016\u001cF/\u0019;f[\u0016tG\u000fF\u0002g\u0003\u0007Aa!\u001d\u0004A\u0002\u0005\u0015\u0001\u0003BA\u0004\u0003CqA!!\u0003\u0002\u001e9!\u00111BA\u000e\u001d\u0011\ti!!\u0007\u000f\t\u0005=\u0011q\u0003\b\u0005\u0003#\t)BD\u0002A\u0003'I\u0011AJ\u0005\u0003I\u0015J!AI\u0012\n\u0005\u0001\n\u0013B\u0001\u0010 \u0013\r\ty\"H\u0001\u001a5>\u0014H-\u001a:Tc2,\u0005\u0010^3og&|gn\u001d)beN,'/\u0003\u0003\u0002$\u0005\u0015\"AF*j]\u001edWm\u0015;bi\u0016lWM\u001c;D_:$X\r\u001f;\u000b\u0007\u0005}Q$A\nwSNLGo\u00149uS6L'0\u001a.pe\u0012,'\u000fF\u0002g\u0003WAa!]\u0004A\u0002\u00055\u0002\u0003BA\u0004\u0003_IA!!\r\u0002&\t)r\n\u001d;j[&TXMW8sI\u0016\u00148i\u001c8uKb$\u0018\u0001\u0005<jg&$\b+Y:t)\"\u0014x.^4i)\r1\u0017q\u0007\u0005\u0007c\"\u0001\r!!\u000f\u0011\t\u0005\u001d\u00111H\u0005\u0005\u0003{\t)C\u0001\nQCN\u001cH\u000b\u001b:pk\u001eD7i\u001c8uKb$\u0018A\u0003<jg&$\u0018+^3ssR\u0019\u0011*a\u0011\t\rEL\u0001\u0019AA#!\u0011\t9!a\u0012\n\t\u0005%\u0013Q\u0005\u0002\r#V,'/_\"p]R,\u0007\u0010^\u0001\u0013m&\u001c\u0018\u000e\u001e'pO&\u001c\u0017\r\u001c\"j]\u0006\u0014\u0018\u0010F\u0002J\u0003\u001fBa!\u001d\u0006A\u0002\u0005E\u0003\u0003BA\u0004\u0003'JA!!\u0016\u0002&\t!Bj\\4jG\u0006d')\u001b8bef\u001cuN\u001c;fqR\f\u0001D^5tSRlU\u000f\u001c;ja\u0006\u0014H/\u00133f]RLg-[3s)\rY\u00161\f\u0005\u0007c.\u0001\r!!\u0018\u0011\t\u0005\u001d\u0011qL\u0005\u0005\u0003C\n)C\u0001\u000eNk2$\u0018\u000e]1si&#WM\u001c;jM&,'oQ8oi\u0016DH/A\twSNLGOW8sI\u0016\u00148\t\\1vg\u0016$B!a\u001a\u0002vA!aHRA5!\u0011\tY'!\u001d\u000e\u0005\u00055$bAA8\u001b\u0006A\u0011M\\1msNL7/\u0003\u0003\u0002t\u00055$aE+oe\u0016\u001cx\u000e\u001c<fI\u0006#HO]5ckR,\u0007BB9\r\u0001\u0004\t9\b\u0005\u0003\u0002\b\u0005e\u0014\u0002BA>\u0003K\u00111CW8sI\u0016\u00148\t\\1vg\u0016\u001cuN\u001c;fqR\f\u0001C^5tSRtU\u000f\u001c7MSR,'/\u00197\u0015\t\u0005\u0005\u0015q\u0011\t\u0004\u0015\u0006\r\u0015bAAC\u0017\n9A*\u001b;fe\u0006d\u0007BB9\u000e\u0001\u0004\tI\t\u0005\u0003\u0002\b\u0005-\u0015\u0002BAG\u0003K\u0011!CT;mY2KG/\u001a:bY\u000e{g\u000e^3yi\u0006\u0019b/[:ji\n{w\u000e\\3b]2KG/\u001a:bYR!\u0011\u0011QAJ\u0011\u0019\th\u00021\u0001\u0002\u0016B!\u0011qAAL\u0013\u0011\tI*!\n\u0003+\t{w\u000e\\3b]2KG/\u001a:bY\u000e{g\u000e^3yi\u0006!b/[:jiRK\b/Z\"p]N$(/^2u_J$B!!!\u0002 \"1\u0011o\u0004a\u0001\u0003C\u0003B!a\u0002\u0002$&!\u0011QUA\u0013\u0005Y!\u0016\u0010]3D_:\u001cHO];di>\u00148i\u001c8uKb$\u0018A\u0005<jg&$8\u000b\u001e:j]\u001ed\u0015\u000e^3sC2$B!!!\u0002,\"1\u0011\u000f\u0005a\u0001\u0003[\u0003B!a\u0002\u00020&!\u0011\u0011WA\u0013\u0005Q\u0019FO]5oO2KG/\u001a:bY\u000e{g\u000e^3yi\u0006\u0019b/[:ji\u0012+7-[7bY2KG/\u001a:bYR!\u0011\u0011QA\\\u0011\u0019\t\u0018\u00031\u0001\u0002:B!\u0011qAA^\u0013\u0011\ti,!\n\u0003+\u0011+7-[7bY2KG/\u001a:bY\u000e{g\u000e^3yi\u0006qa.^7fe&\u001cG*\u001b;fe\u0006dG\u0003DAb\u0003+\fi.!9\u0002l\u0006=H\u0003BAA\u0003\u000bDq!a2\u0013\u0001\u0004\tI-A\u0005d_:4XM\u001d;feB1a&a3]\u0003\u001fL1!!40\u0005%1UO\\2uS>t\u0017\u0007E\u0002/\u0003#L1!a50\u0005\r\te.\u001f\u0005\u0007cJ\u0001\r!a6\u0011\t\u0005\u001d\u0011\u0011\\\u0005\u0005\u00037\f)CA\u0007Ok6\u0014WM]\"p]R,\u0007\u0010\u001e\u0005\u0007\u0003?\u0014\u0002\u0019\u0001/\u0002)I\fwo\u0015;sSB\u0004X\rZ)vC2Lg-[3s\u0011\u001d\t\u0019O\u0005a\u0001\u0003K\f\u0001\"\\5o-\u0006dW/\u001a\t\u0004}\u0005\u001d\u0018bAAu\u0011\nQ!)[4EK\u000eLW.\u00197\t\u000f\u00055(\u00031\u0001\u0002f\u0006AQ.\u0019=WC2,X\r\u0003\u0004\u0002rJ\u0001\r\u0001X\u0001\tif\u0004XMT1nK\u0006\u0019b/[:jiRKg._%oi2KG/\u001a:bYR!\u0011\u0011QA|\u0011\u0019\t8\u00031\u0001\u0002zB!\u0011qAA~\u0013\u0011\ti0!\n\u0003+QKg._%oi2KG/\u001a:bY\u000e{g\u000e^3yi\u0006\u0019b/[:ji&sG/Z4fe2KG/\u001a:bYR!\u0011\u0011\u0011B\u0002\u0011\u0019\tH\u00031\u0001\u0003\u0006A!\u0011q\u0001B\u0004\u0013\u0011\u0011I!!\n\u0003+%sG/Z4fe2KG/\u001a:bY\u000e{g\u000e^3yi\u0006!b/[:jiNk\u0017\r\u001c7J]Rd\u0015\u000e^3sC2$B!!!\u0003\u0010!1\u0011/\u0006a\u0001\u0005#\u0001B!a\u0002\u0003\u0014%!!QCA\u0013\u0005Y\u0019V.\u00197m\u0013:$H*\u001b;fe\u0006d7i\u001c8uKb$\u0018A\u0005<jg&$()[4J]Rd\u0015\u000e^3sC2$B!!!\u0003\u001c!1\u0011O\u0006a\u0001\u0005;\u0001B!a\u0002\u0003 %!!\u0011EA\u0013\u0005Q\u0011\u0015nZ%oi2KG/\u001a:bY\u000e{g\u000e^3yi\u0006\u0011b/[:ji\u0012{WO\u00197f\u0019&$XM]1m)\u0011\t\tIa\n\t\rE<\u0002\u0019\u0001B\u0015!\u0011\t9Aa\u000b\n\t\t5\u0012Q\u0005\u0002\u0015\t>,(\r\\3MSR,'/\u00197D_:$X\r\u001f;\u0002-YL7/\u001b;CS\u001e$UmY5nC2d\u0015\u000e^3sC2$B!!!\u00034!1\u0011\u000f\u0007a\u0001\u0005k\u0001B!a\u0002\u00038%!!\u0011HA\u0013\u0005a\u0011\u0015n\u001a#fG&l\u0017\r\u001c'ji\u0016\u0014\u0018\r\\\"p]R,\u0007\u0010^\u0001\rGJ,\u0017\r^3TiJLgn\u001a\u000b\u00049\n}\u0002BB9\u001a\u0001\u0004\ti+\u0001\u0006usB,GMV5tSR,BA!\u0012\u0003LQ!!q\tB,!\u0011\u0011IEa\u0013\r\u0001\u00119!Q\n\u000eC\u0002\t=#!\u0001+\u0012\t\tE\u0013q\u001a\t\u0004]\tM\u0013b\u0001B+_\t9aj\u001c;iS:<\u0007BB9\u001b\u0001\u0004\u0011I\u0006\u0005\u0003\u0003\\\t\u0005TB\u0001B/\u0015\r\u0011y\u0006^\u0001\u0005iJ,W-\u0003\u0003\u0003d\tu#!\u0003)beN,GK]3f\u00031\u0019HO]5oOR{G)\u0019;f)\u0011\u0011IG!\u001e\u0011\u000b9\u0012YGa\u001c\n\u0007\t5tF\u0001\u0004PaRLwN\u001c\t\u0004]\tE\u0014b\u0001B:_\t\u0019\u0011J\u001c;\t\u000f\t]4\u00041\u0001\u0003z\u0005\t1\u000f\u0005\u0003\u0003|\t\u0015UB\u0001B?\u0015\u0011\u0011yH!!\u0002\u000bQL\b/Z:\u000b\u0007\t\r\u0005+\u0001\u0004v]N\fg-Z\u0005\u0005\u0005\u000f\u0013iH\u0001\u0006V)\u001aC4\u000b\u001e:j]\u001e\u0004")
public abstract class ZorderSqlAstBuilderBase
extends ZorderSqlExtensionsBaseVisitor<Object> {
    public abstract ZorderBase buildZorder(Seq<Expression> var1);

    public abstract OptimizeZorderStatementBase buildOptimizeZorderStatement(Seq<String> var1, LogicalPlan var2);

    public Expression expression(ParserRuleContext ctx) {
        return (Expression)this.typedVisit((ParseTree)ctx);
    }

    public Seq<String> multiPart(ParserRuleContext ctx) {
        return (Seq)this.typedVisit((ParseTree)ctx);
    }

    @Override
    public LogicalPlan visitSingleStatement(ZorderSqlExtensionsParser.SingleStatementContext ctx) {
        return (LogicalPlan)this.visit((ParseTree)ctx.statement());
    }

    @Override
    public LogicalPlan visitOptimizeZorder(ZorderSqlExtensionsParser.OptimizeZorderContext ctx) {
        return (LogicalPlan)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> {
            UnresolvedRelation unresolvedRelation;
            Seq<String> tableIdent = this.multiPart(ctx.multipartIdentifier());
            UnresolvedRelation table = new UnresolvedRelation(tableIdent, UnresolvedRelation$.MODULE$.apply$default$2(), UnresolvedRelation$.MODULE$.apply$default$3());
            Object whereClause = ctx.whereClause() == null ? None$.MODULE$ : Option$.MODULE$.apply((Object)this.expression(ctx.whereClause().booleanExpression()));
            None$ none$ = whereClause;
            if (none$ instanceof Some) {
                Some some = (Some)none$;
                Expression expr = (Expression)some.value();
                unresolvedRelation = new Filter(expr, (LogicalPlan)table);
            } else if (None$.MODULE$.equals(none$)) {
                unresolvedRelation = table;
            } else {
                throw new MatchError((Object)none$);
            }
            UnresolvedRelation tableWithFilter = unresolvedRelation;
            Seq zorderCols = ((SeqLike)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(ctx$1.zorderClause().order).asScala()).map((Function1 & Serializable & scala.Serializable)ctx -> this.visitMultipartIdentifier((ZorderSqlExtensionsParser.MultipartIdentifierContext)((Object)((Object)ctx))), Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$1 -> new UnresolvedAttribute(x$1), Buffer$.MODULE$.canBuildFrom())).toSeq();
            Expression orderExpr = zorderCols.length() == 1 ? (Expression)zorderCols.head() : this.buildZorder((Seq<Expression>)zorderCols);
            SortOrder sortOrder = new SortOrder(orderExpr, (SortDirection)Ascending$.MODULE$, (NullOrdering)NullsLast$.MODULE$, (Seq)Nil$.MODULE$);
            Sort query = new Sort((Seq)Nil$.MODULE$.$colon$colon((Object)sortOrder), BoxesRunTime.unboxToBoolean((Object)HiveAnalysis$.MODULE$.conf().getConf(KyuubiSQLConf$.MODULE$.ZORDER_GLOBAL_SORT_ENABLED())), (LogicalPlan)new Project((Seq)new .colon.colon((Object)new UnresolvedStar((Option)None$.MODULE$), (List)Nil$.MODULE$), (LogicalPlan)tableWithFilter));
            return this.buildOptimizeZorderStatement(tableIdent, (LogicalPlan)query);
        });
    }

    @Override
    public LogicalPlan visitPassThrough(ZorderSqlExtensionsParser.PassThroughContext ctx) {
        return null;
    }

    @Override
    public Expression visitQuery(ZorderSqlExtensionsParser.QueryContext ctx) {
        return (Expression)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> {
            EqualTo equalTo;
            UnresolvedAttribute left = new UnresolvedAttribute(this.multiPart(ctx.multipartIdentifier()));
            Expression right = this.expression(ctx.constant());
            TerminalNode operator = (TerminalNode)ctx.comparisonOperator().getChild(0);
            int n = operator.getSymbol().getType();
            if (ZorderSqlExtensionsParser.EQ == n) {
                equalTo = new EqualTo((Expression)left, right);
            } else if (ZorderSqlExtensionsParser.NSEQ == n) {
                equalTo = new EqualNullSafe((Expression)left, right);
            } else {
                boolean bl = ZorderSqlExtensionsParser.NEQ == n ? true : ZorderSqlExtensionsParser.NEQJ == n;
                if (bl) {
                    equalTo = new Not((Expression)new EqualTo((Expression)left, right));
                } else if (ZorderSqlExtensionsParser.LT == n) {
                    equalTo = new LessThan((Expression)left, right);
                } else if (ZorderSqlExtensionsParser.LTE == n) {
                    equalTo = new LessThanOrEqual((Expression)left, right);
                } else if (ZorderSqlExtensionsParser.GT == n) {
                    equalTo = new GreaterThan((Expression)left, right);
                } else if (ZorderSqlExtensionsParser.GTE == n) {
                    equalTo = new GreaterThanOrEqual((Expression)left, right);
                } else {
                    throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                }
            }
            return equalTo;
        });
    }

    @Override
    public Expression visitLogicalBinary(ZorderSqlExtensionsParser.LogicalBinaryContext ctx) {
        return (Expression)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> {
            Function2 & Serializable & scala.Serializable intersect;
            int expressionType = ctx$3.operator.getType();
            int n = expressionType;
            if (ZorderSqlExtensionsParser.AND == n) {
                intersect = (Function2 & Serializable & scala.Serializable)(left, right) -> new And(left, right);
            } else if (ZorderSqlExtensionsParser.OR == n) {
                intersect = (Function2 & Serializable & scala.Serializable)(left, right) -> new Or(left, right);
            } else {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
            Function2 & Serializable & scala.Serializable expressionCombiner = intersect;
            ArrayBuffer contexts = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ZorderSqlExtensionsParser.BooleanExpressionContext[]{ctx$3.right}));
            ObjectRef current = ObjectRef.create((Object)((Object)ctx$3.left));
            while (ZorderSqlAstBuilderBase.collectContexts$1(current, expressionType, contexts)) {
            }
            ArrayBuffer expressions = (ArrayBuffer)contexts.reverseMap((Function1 & Serializable & scala.Serializable)ctx -> this.expression((ParserRuleContext)ctx), ArrayBuffer$.MODULE$.canBuildFrom());
            return ZorderSqlAstBuilderBase.reduceToExpressionTree$1(0, expressions.size() - 1, expressions, expressionCombiner);
        });
    }

    @Override
    public Seq<String> visitMultipartIdentifier(ZorderSqlExtensionsParser.MultipartIdentifierContext ctx) {
        return (Seq)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> (Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(ctx$4.parts).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getText(), Buffer$.MODULE$.canBuildFrom()));
    }

    @Override
    public Seq<UnresolvedAttribute> visitZorderClause(ZorderSqlExtensionsParser.ZorderClauseContext ctx) {
        return (Seq)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> {
            void var1_1;
            ListBuffer res = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            ctx.multipartIdentifier().forEach(identifier -> res.$plus$eq((Object)new UnresolvedAttribute((Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(identifier.parts).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getText(), Buffer$.MODULE$.canBuildFrom()))));
            return var1_1;
        });
    }

    @Override
    public Literal visitNullLiteral(ZorderSqlExtensionsParser.NullLiteralContext ctx) {
        return (Literal)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> Literal$.MODULE$.apply(null));
    }

    @Override
    public Literal visitBooleanLiteral(ZorderSqlExtensionsParser.BooleanLiteralContext ctx) {
        return (Literal)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(ctx.getText())).toBoolean() ? Literal$.MODULE$.TrueLiteral() : Literal$.MODULE$.FalseLiteral());
    }

    @Override
    public Literal visitTypeConstructor(ZorderSqlExtensionsParser.TypeConstructorContext ctx) {
        return (Literal)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> {
            Literal literal;
            String value = ParserUtils$.MODULE$.string(ctx.STRING());
            String valueType = ctx.identifier().getText().toUpperCase(Locale.ROOT);
            try {
                Literal literal2;
                String string = valueType;
                if ("DATE".equals(string)) {
                    literal2 = ZorderSqlAstBuilderBase.toLiteral$1((Function1 & Serializable & scala.Serializable)s -> this.stringToDate((UTF8String)s), (DataType)DateType$.MODULE$, value, valueType, ctx);
                } else if ("TIMESTAMP".equals(string)) {
                    ZoneId zoneId = DateTimeUtils$.MODULE$.getZoneId(SQLConf$.MODULE$.get().sessionLocalTimeZone());
                    literal2 = ZorderSqlAstBuilderBase.toLiteral$1((Function1 & Serializable & scala.Serializable)x$6 -> DateTimeUtils$.MODULE$.stringToTimestamp(x$6, zoneId), (DataType)TimestampType$.MODULE$, value, valueType, ctx);
                } else if ("INTERVAL".equals(string)) {
                    CalendarInterval calendarInterval;
                    try {
                        calendarInterval = IntervalUtils$.MODULE$.stringToInterval(UTF8String.fromString((String)value));
                    }
                    catch (IllegalArgumentException e) {
                        ParseException ex = new ParseException(new StringBuilder(33).append("Cannot parse the INTERVAL value: ").append(value).toString(), (ParserRuleContext)ctx);
                        ex.setStackTrace(e.getStackTrace());
                        throw ex;
                    }
                    CalendarInterval interval = calendarInterval;
                    literal2 = new Literal((Object)interval, (DataType)CalendarIntervalType$.MODULE$);
                } else if ("X".equals(string)) {
                    String padding = value.length() % 2 != 0 ? "0" : "";
                    literal2 = Literal$.MODULE$.apply((Object)Hex.decodeHex((String)new StringBuilder(0).append(padding).append(value).toString()));
                } else {
                    throw new ParseException(new StringBuilder(48).append("Literals of type '").append(string).append("' are currently not supported.").toString(), (ParserRuleContext)ctx);
                }
                literal = literal2;
            }
            catch (IllegalArgumentException e) {
                String message = (String)Option$.MODULE$.apply((Object)e.getMessage()).getOrElse((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Exception parsing ").append(valueType).toString());
                throw new ParseException(message, (ParserRuleContext)ctx);
            }
            return literal;
        });
    }

    @Override
    public Literal visitStringLiteral(ZorderSqlExtensionsParser.StringLiteralContext ctx) {
        return (Literal)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> Literal$.MODULE$.apply((Object)this.createString(ctx)));
    }

    @Override
    public Literal visitDecimalLiteral(ZorderSqlExtensionsParser.DecimalLiteralContext ctx) {
        return (Literal)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> Literal$.MODULE$.apply((Object)package$.MODULE$.BigDecimal().apply(ctx.getText()).underlying()));
    }

    private Literal numericLiteral(ZorderSqlExtensionsParser.NumberContext ctx, String rawStrippedQualifier, BigDecimal minValue, BigDecimal maxValue, String typeName, Function1<String, Object> converter) {
        return (Literal)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> {
            Literal literal;
            try {
                BigDecimal rawBigDecimal = package$.MODULE$.BigDecimal().apply(rawStrippedQualifier);
                if (rawBigDecimal.$less((Object)minValue) || rawBigDecimal.$greater((Object)maxValue)) {
                    throw new ParseException(new StringBuilder(53).append("Numeric literal ").append(rawStrippedQualifier).append(" does not ").append("fit in range [").append(minValue).append(", ").append(maxValue).append("] for type ").append(typeName).toString(), (ParserRuleContext)ctx);
                }
                literal = Literal$.MODULE$.apply(converter.apply((Object)rawStrippedQualifier));
            }
            catch (NumberFormatException e) {
                throw new ParseException(e.getMessage(), (ParserRuleContext)ctx);
            }
            return literal;
        });
    }

    @Override
    public Literal visitTinyIntLiteral(ZorderSqlExtensionsParser.TinyIntLiteralContext ctx) {
        String rawStrippedQualifier = ctx.getText().substring(0, ctx.getText().length() - 1);
        return this.numericLiteral(ctx, rawStrippedQualifier, BigDecimal$.MODULE$.int2bigDecimal(-128), BigDecimal$.MODULE$.int2bigDecimal(127), ByteType$.MODULE$.simpleString(), (Function1<String, Object>)(Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToByte((byte)ZorderSqlAstBuilderBase.$anonfun$visitTinyIntLiteral$1(x$7)));
    }

    @Override
    public Literal visitIntegerLiteral(ZorderSqlExtensionsParser.IntegerLiteralContext ctx) {
        return (Literal)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> {
            BigDecimal bigDecimal = package$.MODULE$.BigDecimal().apply(ctx.getText());
            Literal literal = bigDecimal.isValidInt() ? Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)bigDecimal.intValue())) : (bigDecimal.isValidLong() ? Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)bigDecimal.longValue())) : Literal$.MODULE$.apply((Object)bigDecimal.underlying()));
            return literal;
        });
    }

    @Override
    public Literal visitSmallIntLiteral(ZorderSqlExtensionsParser.SmallIntLiteralContext ctx) {
        String rawStrippedQualifier = ctx.getText().substring(0, ctx.getText().length() - 1);
        return this.numericLiteral(ctx, rawStrippedQualifier, BigDecimal$.MODULE$.int2bigDecimal(Short.MIN_VALUE), BigDecimal$.MODULE$.int2bigDecimal(Short.MAX_VALUE), ShortType$.MODULE$.simpleString(), (Function1<String, Object>)(Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToShort((short)ZorderSqlAstBuilderBase.$anonfun$visitSmallIntLiteral$1(x$8)));
    }

    @Override
    public Literal visitBigIntLiteral(ZorderSqlExtensionsParser.BigIntLiteralContext ctx) {
        String rawStrippedQualifier = ctx.getText().substring(0, ctx.getText().length() - 1);
        return this.numericLiteral(ctx, rawStrippedQualifier, BigDecimal$.MODULE$.long2bigDecimal(Long.MIN_VALUE), BigDecimal$.MODULE$.long2bigDecimal(Long.MAX_VALUE), LongType$.MODULE$.simpleString(), (Function1<String, Object>)(Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong((long)ZorderSqlAstBuilderBase.$anonfun$visitBigIntLiteral$1(x$9)));
    }

    @Override
    public Literal visitDoubleLiteral(ZorderSqlExtensionsParser.DoubleLiteralContext ctx) {
        String rawStrippedQualifier = ctx.getText().substring(0, ctx.getText().length() - 1);
        return this.numericLiteral(ctx, rawStrippedQualifier, BigDecimal$.MODULE$.double2bigDecimal(Double$.MODULE$.MinValue()), BigDecimal$.MODULE$.double2bigDecimal(Double.MAX_VALUE), DoubleType$.MODULE$.simpleString(), (Function1<String, Object>)(Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToDouble((double)ZorderSqlAstBuilderBase.$anonfun$visitDoubleLiteral$1(x$10)));
    }

    @Override
    public Literal visitBigDecimalLiteral(ZorderSqlExtensionsParser.BigDecimalLiteralContext ctx) {
        Literal literal;
        String raw = ctx.getText().substring(0, ctx.getText().length() - 2);
        try {
            literal = Literal$.MODULE$.apply((Object)package$.MODULE$.BigDecimal().apply(raw).underlying());
        }
        catch (AnalysisException e) {
            throw new ParseException(e.message(), (ParserRuleContext)ctx);
        }
        return literal;
    }

    private String createString(ZorderSqlExtensionsParser.StringLiteralContext ctx) {
        return HiveAnalysis$.MODULE$.conf().escapedStringLiterals() ? ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(ctx.STRING()).asScala()).map((Function1 & Serializable & scala.Serializable)node -> ParserUtils$.MODULE$.stringWithoutUnescape(node), Buffer$.MODULE$.canBuildFrom())).mkString() : ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(ctx.STRING()).asScala()).map((Function1 & Serializable & scala.Serializable)node -> ParserUtils$.MODULE$.string(node), Buffer$.MODULE$.canBuildFrom())).mkString();
    }

    private <T> T typedVisit(ParseTree ctx) {
        return (T)ctx.accept((ParseTreeVisitor)this);
    }

    private Option<Object> stringToDate(UTF8String s) {
        Some some;
        int j;
        if (s == null || s.trimAll().numBytes() == 0) {
            return None$.MODULE$;
        }
        int[] segments = (int[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 1, 1}), ClassTag$.MODULE$.Int());
        int sign = 1;
        int i = 0;
        int currentSegmentValue = 0;
        int currentSegmentDigits = 0;
        byte[] bytes = s.trimAll().getBytes();
        if (bytes[j = 0] == 45 || bytes[j] == 43) {
            sign = bytes[j] == 45 ? -1 : 1;
            ++j;
        }
        while (j < bytes.length && i < 3 && bytes[j] != 32 && bytes[j] != 84) {
            byte b = bytes[j];
            if (i < 2 && b == 45) {
                if (!ZorderSqlAstBuilderBase.isValidDigits$1(i, currentSegmentDigits)) {
                    return None$.MODULE$;
                }
                segments[i] = currentSegmentValue;
                currentSegmentValue = 0;
                currentSegmentDigits = 0;
                ++i;
            } else {
                int parsedValue = b - (byte)48;
                if (parsedValue < 0 || parsedValue > 9) {
                    return None$.MODULE$;
                }
                currentSegmentValue = currentSegmentValue * 10 + parsedValue;
                ++currentSegmentDigits;
            }
            ++j;
        }
        if (!ZorderSqlAstBuilderBase.isValidDigits$1(i, currentSegmentDigits)) {
            return None$.MODULE$;
        }
        if (i < 2 && j < bytes.length) {
            return None$.MODULE$;
        }
        segments[i] = currentSegmentValue;
        try {
            LocalDate localDate = LocalDate.of(sign * segments[0], segments[1], segments[2]);
            some = new Some((Object)BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.localDateToDays(localDate)));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            None$ none$ = None$.MODULE$;
            some = none$;
        }
        return some;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean collectContexts$1(ObjectRef current$1, int expressionType$1, ArrayBuffer contexts$1) {
        ZorderSqlExtensionsParser.BooleanExpressionContext booleanExpressionContext = (ZorderSqlExtensionsParser.BooleanExpressionContext)((Object)current$1.elem);
        if (booleanExpressionContext instanceof ZorderSqlExtensionsParser.LogicalBinaryContext) {
            ZorderSqlExtensionsParser.LogicalBinaryContext logicalBinaryContext = (ZorderSqlExtensionsParser.LogicalBinaryContext)booleanExpressionContext;
            if (logicalBinaryContext.operator.getType() == expressionType$1) {
                contexts$1.$plus$eq((Object)logicalBinaryContext.right);
                current$1.elem = logicalBinaryContext.left;
                return true;
            }
        }
        contexts$1.$plus$eq((Object)((ZorderSqlExtensionsParser.BooleanExpressionContext)((Object)current$1.elem)));
        return false;
    }

    private static final Expression reduceToExpressionTree$1(int low, int high, ArrayBuffer expressions$1, Function2 expressionCombiner$1) {
        Expression expression;
        int n = high - low;
        switch (n) {
            case 0: {
                expression = (Expression)expressions$1.apply(low);
                break;
            }
            case 1: {
                expression = (Expression)expressionCombiner$1.apply(expressions$1.apply(low), expressions$1.apply(high));
                break;
            }
            default: {
                int mid = low + n / 2;
                expression = (Expression)expressionCombiner$1.apply((Object)ZorderSqlAstBuilderBase.reduceToExpressionTree$1(low, mid, expressions$1, expressionCombiner$1), (Object)ZorderSqlAstBuilderBase.reduceToExpressionTree$1(mid + 1, high, expressions$1, expressionCombiner$1));
                break;
            }
        }
        return expression;
    }

    private static final Literal toLiteral$1(Function1 f, DataType t, String value$1, String valueType$1, ZorderSqlExtensionsParser.TypeConstructorContext ctx$7) {
        return (Literal)((Option)f.apply((Object)UTF8String.fromString((String)value$1))).map((Function1 & Serializable & scala.Serializable)x$5 -> new Literal(x$5, t)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new ParseException(new StringBuilder(25).append("Cannot parse the ").append(valueType$1).append(" value: ").append(value$1).toString(), (ParserRuleContext)ctx$7);
        });
    }

    public static final /* synthetic */ byte $anonfun$visitTinyIntLiteral$1(String x$7) {
        return new StringOps(Predef$.MODULE$.augmentString(x$7)).toByte();
    }

    public static final /* synthetic */ short $anonfun$visitSmallIntLiteral$1(String x$8) {
        return new StringOps(Predef$.MODULE$.augmentString(x$8)).toShort();
    }

    public static final /* synthetic */ long $anonfun$visitBigIntLiteral$1(String x$9) {
        return new StringOps(Predef$.MODULE$.augmentString(x$9)).toLong();
    }

    public static final /* synthetic */ double $anonfun$visitDoubleLiteral$1(String x$10) {
        return new StringOps(Predef$.MODULE$.augmentString(x$10)).toDouble();
    }

    private static final boolean isValidDigits$1(int segment, int digits) {
        int maxDigitsYear = 7;
        return segment == 0 && digits >= 4 && digits <= maxDigitsYear || segment != 0 && digits > 0 && digits <= 2;
    }
}

