/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.session;

import com.codahale.metrics.MetricRegistry;
import java.io.Serializable;
import java.nio.file.Path;
import org.apache.hive.service.rpc.thrift.TProtocolVersion;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.Utils$;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.credentials.HadoopCredentialsManager;
import org.apache.kyuubi.metrics.MetricsConstants$;
import org.apache.kyuubi.metrics.MetricsSystem;
import org.apache.kyuubi.metrics.MetricsSystem$;
import org.apache.kyuubi.operation.KyuubiOperationManager;
import org.apache.kyuubi.service.Service;
import org.apache.kyuubi.session.KyuubiSessionImpl;
import org.apache.kyuubi.session.Session;
import org.apache.kyuubi.session.SessionHandle;
import org.apache.kyuubi.session.SessionManager;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001I4A\u0001D\u0007\u0001-!A1\u0004\u0001B\u0001B\u0003%A\u0004C\u0003*\u0001\u0011%!\u0006C\u0003*\u0001\u0011\u0005Q\u0006C\u0004/\u0001\t\u0007I\u0011A\u0018\t\rY\u0002\u0001\u0015!\u00031\u0011\u001d9\u0004A1A\u0005\u0002aBaa\u0010\u0001!\u0002\u0013I\u0004\"\u0002!\u0001\t\u0003\n\u0005\"\u0002(\u0001\t\u0003z\u0005\"B6\u0001\t\u0003b\u0007\"B7\u0001\t#r'\u0001F&zkV\u0014\u0017nU3tg&|g.T1oC\u001e,'O\u0003\u0002\u000f\u001f\u000591/Z:tS>t'B\u0001\t\u0012\u0003\u0019Y\u00170^;cS*\u0011!cE\u0001\u0007CB\f7\r[3\u000b\u0003Q\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\f\u0011\u0005aIR\"A\u0007\n\u0005ii!AD*fgNLwN\\'b]\u0006<WM]\u0001\u0005]\u0006lW\r\u0005\u0002\u001eM9\u0011a\u0004\n\t\u0003?\tj\u0011\u0001\t\u0006\u0003CU\ta\u0001\u0010:p_Rt$\"A\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0012\u0013A\u0002)sK\u0012,g-\u0003\u0002(Q\t11\u000b\u001e:j]\u001eT!!\n\u0012\u0002\rqJg.\u001b;?)\tYC\u0006\u0005\u0002\u0019\u0001!)1D\u0001a\u00019Q\t1&\u0001\tpa\u0016\u0014\u0018\r^5p]6\u000bg.Y4feV\t\u0001\u0007\u0005\u00022i5\t!G\u0003\u00024\u001f\u0005Iq\u000e]3sCRLwN\\\u0005\u0003kI\u0012acS=vk\nLw\n]3sCRLwN\\'b]\u0006<WM]\u0001\u0012_B,'/\u0019;j_:l\u0015M\\1hKJ\u0004\u0013AE2sK\u0012,g\u000e^5bYNl\u0015M\\1hKJ,\u0012!\u000f\t\u0003uuj\u0011a\u000f\u0006\u0003y=\t1b\u0019:fI\u0016tG/[1mg&\u0011ah\u000f\u0002\u0019\u0011\u0006$wn\u001c9De\u0016$WM\u001c;jC2\u001cX*\u00198bO\u0016\u0014\u0018aE2sK\u0012,g\u000e^5bYNl\u0015M\\1hKJ\u0004\u0013AC5oSRL\u0017\r\\5{KR\u0011!I\u0012\t\u0003\u0007\u0012k\u0011AI\u0005\u0003\u000b\n\u0012A!\u00168ji\")q\t\u0003a\u0001\u0011\u0006!1m\u001c8g!\tIE*D\u0001K\u0015\tYu\"\u0001\u0004d_:4\u0017nZ\u0005\u0003\u001b*\u0013!bS=vk\nL7i\u001c8g\u0003-y\u0007/\u001a8TKN\u001c\u0018n\u001c8\u0015\rA\u001b\u0016mY3h!\tA\u0012+\u0003\u0002S\u001b\ti1+Z:tS>t\u0007*\u00198eY\u0016DQ\u0001V\u0005A\u0002U\u000b\u0001\u0002\u001d:pi>\u001cw\u000e\u001c\t\u0003-~k\u0011a\u0016\u0006\u00031f\u000ba\u0001\u001e5sS\u001a$(B\u0001.\\\u0003\r\u0011\bo\u0019\u0006\u00039v\u000bqa]3sm&\u001cWM\u0003\u0002_#\u0005!\u0001.\u001b<f\u0013\t\u0001wK\u0001\tU!J|Go\\2pYZ+'o]5p]\")!-\u0003a\u00019\u0005!Qo]3s\u0011\u0015!\u0017\u00021\u0001\u001d\u0003!\u0001\u0018m]:x_J$\u0007\"\u00024\n\u0001\u0004a\u0012!C5q\u0003\u0012$'/Z:t\u0011\u00159\u0015\u00021\u0001i!\u0011i\u0012\u000e\b\u000f\n\u0005)D#aA'ba\u0006)1\u000f^1siR\t!)\u0001\u0005jgN+'O^3s+\u0005y\u0007CA\"q\u0013\t\t(EA\u0004C_>dW-\u00198")
public class KyuubiSessionManager
extends SessionManager {
    private final KyuubiOperationManager operationManager = new KyuubiOperationManager();
    private final HadoopCredentialsManager credentialsManager = new HadoopCredentialsManager();

    public KyuubiOperationManager operationManager() {
        return this.operationManager;
    }

    public HadoopCredentialsManager credentialsManager() {
        return this.credentialsManager;
    }

    public void initialize(KyuubiConf conf) {
        this.addService((Service)this.credentialsManager());
        Path absPath = Utils$.MODULE$.getAbsolutePathFromWork((String)conf.get(KyuubiConf$.MODULE$.SERVER_OPERATION_LOG_DIR_ROOT()), Utils$.MODULE$.getAbsolutePathFromWork$default$2());
        this._operationLogRoot_$eq((Option)new Some((Object)((Object)absPath.toAbsolutePath()).toString()));
        super.initialize(conf);
    }

    public SessionHandle openSession(TProtocolVersion protocol, String user, String password, String ipAddress, Map<String, String> conf) {
        SessionHandle sessionHandle;
        String username = (String)Option$.MODULE$.apply((Object)user).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)KyuubiSessionManager.$anonfun$openSession$1(x$1))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "anonymous");
        KyuubiSessionImpl sessionImpl = new KyuubiSessionImpl(protocol, username, password, ipAddress, conf, this, this.getConf().getUserDefaults(user));
        try {
            sessionImpl.open();
            SessionHandle handle = sessionImpl.handle();
            this.setSession(handle, (Session)sessionImpl);
            this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append(username).append("'s session with ").append(handle).append(" is opened, current opening sessions").append(" ").append(this.getOpenSessionCount()).toString());
            sessionHandle = handle;
        }
        catch (Throwable e) {
            MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)ms -> {
                KyuubiSessionManager.$anonfun$openSession$4(user, ms);
                return BoxedUnit.UNIT;
            });
            try {
                sessionImpl.close();
            }
            catch (Throwable t) {
                this.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Error closing session for ").append(username).append(" client ip: ").append(ipAddress).toString(), t);
            }
            throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(46).append("Error opening session for ").append(username).append(" client ip ").append(ipAddress).append(", due to ").append(e.getMessage()).toString(), e, KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
        }
        return sessionHandle;
    }

    public synchronized void start() {
        MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)ms -> {
            KyuubiSessionManager.$anonfun$start$1(this, ms);
            return BoxedUnit.UNIT;
        });
        super.start();
    }

    public boolean isServer() {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$openSession$1(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$openSession$4(String user$1, MetricsSystem ms) {
        ms.incCount(MetricsConstants$.MODULE$.CONN_FAIL());
        ms.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.CONN_FAIL(), (String[])new String[]{user$1}));
    }

    public static final /* synthetic */ void $anonfun$start$1(KyuubiSessionManager $this, MetricsSystem ms) {
        ms.registerGauge(MetricsConstants$.MODULE$.CONN_OPEN(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> $this.getOpenSessionCount(), (Object)BoxesRunTime.boxToInteger((int)0));
        ms.registerGauge(MetricsConstants$.MODULE$.EXEC_POOL_ALIVE(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> $this.getExecPoolSize(), (Object)BoxesRunTime.boxToInteger((int)0));
        ms.registerGauge(MetricsConstants$.MODULE$.EXEC_POOL_ACTIVE(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> $this.getActiveCount(), (Object)BoxesRunTime.boxToInteger((int)0));
    }

    private KyuubiSessionManager(String name) {
        super(name);
    }

    public KyuubiSessionManager() {
        this(KyuubiSessionManager.class.getSimpleName());
    }
}

