/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.server.mysql;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hive.service.rpc.thrift.TProtocolVersion;
import org.apache.hive.service.rpc.thrift.TRowSet;
import org.apache.hive.service.rpc.thrift.TTableSchema;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.operation.FetchOrientation$;
import org.apache.kyuubi.operation.OperationHandle;
import org.apache.kyuubi.operation.OperationState$;
import org.apache.kyuubi.operation.OperationStatus;
import org.apache.kyuubi.server.mysql.MySQLComInitDbPacket;
import org.apache.kyuubi.server.mysql.MySQLComPingPacket;
import org.apache.kyuubi.server.mysql.MySQLComQueryPacket;
import org.apache.kyuubi.server.mysql.MySQLComQuitPacket;
import org.apache.kyuubi.server.mysql.MySQLCommandHandler$;
import org.apache.kyuubi.server.mysql.MySQLCommandPacket;
import org.apache.kyuubi.server.mysql.MySQLDialectHelper$;
import org.apache.kyuubi.server.mysql.MySQLErrPacket;
import org.apache.kyuubi.server.mysql.MySQLErrPacket$;
import org.apache.kyuubi.server.mysql.MySQLOKPacket;
import org.apache.kyuubi.server.mysql.MySQLOKPacket$;
import org.apache.kyuubi.server.mysql.MySQLPacket;
import org.apache.kyuubi.server.mysql.MySQLQueryResult;
import org.apache.kyuubi.server.mysql.MySQLQueryResult$;
import org.apache.kyuubi.server.mysql.MySQLThriftQueryResult;
import org.apache.kyuubi.server.mysql.constant.MySQLCtxAttrKey$;
import org.apache.kyuubi.service.BackendService;
import org.apache.kyuubi.session.SessionHandle;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0005Uw!\u0002\u000f\u001e\u0011\u0003Ac!\u0002\u0016\u001e\u0011\u0003Y\u0003\"\u0002\u001a\u0002\t\u0003\u0019\u0004b\u0002\u001b\u0002\u0005\u0004%\t!\u000e\u0005\u0007\u0005\u0006\u0001\u000b\u0011\u0002\u001c\t\u000f\r\u000b!\u0019!C\u0001\t\"1!+\u0001Q\u0001\n\u00153AAK\u000f\u0001'\"AQm\u0002B\u0001B\u0003%a\r\u0003\u0005m\u000f\t\u0005\t\u0015!\u0003n\u0011\u0015\u0011t\u0001\"\u0001q\u0011\u001d!xA1A\u0005\fUDaa_\u0004!\u0002\u00131\bb\u0002?\b\u0001\u0004%I! \u0005\n\u0003\u00079\u0001\u0019!C\u0005\u0003\u000bAq!!\u0005\bA\u0003&a\u0010C\u0004\u0002\u001c\u001d!\t%!\b\t\u000f\u0005%r\u0001\"\u0011\u0002,!9\u00111J\u0004\u0005B\u00055\u0003bBA+\u000f\u0011\u0005\u0011q\u000b\u0005\b\u00037:A\u0011AA/\u0011\u001d\t\tg\u0002C\u0001\u0003GBq!a\u001a\b\t\u0003\tI\u0007C\u0004\u0002\u0004\u001e!\t!!\"\t\u000f\u0005Eu\u0001\"\u0001\u0002\u0014\"9\u0011qT\u0004\u0005\u0002\u0005\u0005\u0006bBAW\u000f\u0011\u0005\u0011q\u0016\u0005\b\u0003\u001b<A\u0011BAh\u0003Mi\u0015pU)M\u0007>lW.\u00198e\u0011\u0006tG\r\\3s\u0015\tqr$A\u0003nsN\fHN\u0003\u0002!C\u000511/\u001a:wKJT!AI\u0012\u0002\r-LX/\u001e2j\u0015\t!S%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002M\u0005\u0019qN]4\u0004\u0001A\u0011\u0011&A\u0007\u0002;\t\u0019R*_*R\u0019\u000e{W.\\1oI\"\u000bg\u000e\u001a7feN\u0011\u0011\u0001\f\t\u0003[Aj\u0011A\f\u0006\u0002_\u0005)1oY1mC&\u0011\u0011G\f\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005A\u0013!D2p]:LEmQ8v]R,'/F\u00017!\t9\u0004)D\u00019\u0015\tI$(\u0001\u0004bi>l\u0017n\u0019\u0006\u0003wq\n!bY8oGV\u0014(/\u001a8u\u0015\tid(\u0001\u0003vi&d'\"A \u0002\t)\fg/Y\u0005\u0003\u0003b\u0012Q\"\u0011;p[&\u001c\u0017J\u001c;fO\u0016\u0014\u0018AD2p]:LEmQ8v]R,'\u000fI\u0001\u0013G>tg.\u00133U_N+7o\u001d%b]\u0012dW-F\u0001F!\u00111u)\u0013'\u000e\u0003iJ!\u0001\u0013\u001e\u0003#\r{gnY;se\u0016tG\u000fS1tQ6\u000b\u0007\u000f\u0005\u0002.\u0015&\u00111J\f\u0002\u0004\u0013:$\bCA'Q\u001b\u0005q%BA(\"\u0003\u001d\u0019Xm]:j_:L!!\u0015(\u0003\u001bM+7o]5p]\"\u000bg\u000e\u001a7f\u0003M\u0019wN\u001c8JIR{7+Z:t\u0011\u0006tG\r\\3!'\r9A+\u0019\t\u0004+rsV\"\u0001,\u000b\u0005]C\u0016aB2iC:tW\r\u001c\u0006\u00033j\u000bQA\\3uifT\u0011aW\u0001\u0003S>L!!\u0018,\u00037MKW\u000e\u001d7f\u0007\"\fgN\\3m\u0013:\u0014w.\u001e8e\u0011\u0006tG\r\\3s!\tIs,\u0003\u0002a;\t\u0011R*_*R\u0019\u000e{W.\\1oIB\u000b7m[3u!\t\u00117-D\u0001\"\u0013\t!\u0017EA\u0004M_\u001e<\u0017N\\4\u0002\u0005\t,\u0007CA4k\u001b\u0005A'BA5\"\u0003\u001d\u0019XM\u001d<jG\u0016L!a\u001b5\u0003\u001d\t\u000b7m[3oIN+'O^5dK\u0006AQ\r_3d!>|G\u000e\u0005\u0002G]&\u0011qN\u000f\u0002\u0013)\"\u0014X-\u00193Q_>dW\t_3dkR|'\u000fF\u0002reN\u0004\"!K\u0004\t\u000b\u0015T\u0001\u0019\u00014\t\u000b1T\u0001\u0019A7\u0002\u0005\u0015\u001cW#\u0001<\u0011\u0005]LX\"\u0001=\u000b\u0005mr\u0013B\u0001>y\u0005a)\u00050Z2vi&|gnQ8oi\u0016DH/\u0012=fGV$xN]\u0001\u0004K\u000e\u0004\u0013AB2m_N,G-F\u0001\u007f!\tis0C\u0002\u0002\u00029\u0012qAQ8pY\u0016\fg.\u0001\u0006dY>\u001cX\rZ0%KF$B!a\u0002\u0002\u000eA\u0019Q&!\u0003\n\u0007\u0005-aF\u0001\u0003V]&$\b\u0002CA\b\u001d\u0005\u0005\t\u0019\u0001@\u0002\u0007a$\u0013'A\u0004dY>\u001cX\r\u001a\u0011)\u0007=\t)\u0002E\u0002.\u0003/I1!!\u0007/\u0005!1x\u000e\\1uS2,\u0017aD2iC:tW\r\\%oC\u000e$\u0018N^3\u0015\t\u0005\u001d\u0011q\u0004\u0005\b\u0003C\u0001\u0002\u0019AA\u0012\u0003\r\u0019G\u000f\u001f\t\u0004+\u0006\u0015\u0012bAA\u0014-\n)2\t[1o]\u0016d\u0007*\u00198eY\u0016\u00148i\u001c8uKb$\u0018aD3yG\u0016\u0004H/[8o\u0007\u0006,x\r\u001b;\u0015\r\u0005\u001d\u0011QFA\u0018\u0011\u001d\t\t#\u0005a\u0001\u0003GAq!!\r\u0012\u0001\u0004\t\u0019$A\u0003dCV\u001cX\r\u0005\u0003\u00026\u0005\u0015c\u0002BA\u001c\u0003\u0003rA!!\u000f\u0002@5\u0011\u00111\b\u0006\u0004\u0003{9\u0013A\u0002\u001fs_>$h(C\u00010\u0013\r\t\u0019EL\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t9%!\u0013\u0003\u0013QC'o\\<bE2,'bAA\"]\u0005a1\r[1o]\u0016d'+Z1eaQ1\u0011qAA(\u0003#Bq!!\t\u0013\u0001\u0004\t\u0019\u0003\u0003\u0004\u0002TI\u0001\rAX\u0001\u0007a\u0006\u001c7.\u001a;\u0002'\u0015t7/\u001e:f'\u0016\u001c8/[8o\u001fB,g.\u001a3\u0015\t\u0005\u001d\u0011\u0011\f\u0005\b\u0003C\u0019\u0002\u0019AA\u0012\u0003-y\u0007/\u001a8TKN\u001c\u0018n\u001c8\u0015\u00071\u000by\u0006C\u0004\u0002\"Q\u0001\r!a\t\u0002\u0019\rdwn]3TKN\u001c\u0018n\u001c8\u0015\t\u0005\u001d\u0011Q\r\u0005\b\u0003C)\u0002\u0019AA\u0012\u0003)A\u0017M\u001c3mKBKgn\u001a\u000b\u0007\u0003W\n9(!\u001f\u0011\r\u0005U\u0012QNA9\u0013\u0011\ty'!\u0013\u0003\u0007M+\u0017\u000fE\u0002*\u0003gJ1!!\u001e\u001e\u0005-i\u0015pU)M!\u0006\u001c7.\u001a;\t\u000f\u0005\u0005b\u00031\u0001\u0002$!9\u00111\u0010\fA\u0002\u0005u\u0014a\u00019lOB\u0019\u0011&a \n\u0007\u0005\u0005UD\u0001\nNsN\u000bFjQ8n!&tw\rU1dW\u0016$\u0018\u0001\u00045b]\u0012dW-\u00138ji\u0012\u0013GCBA6\u0003\u000f\u000bI\tC\u0004\u0002\"]\u0001\r!a\t\t\u000f\u0005mt\u00031\u0001\u0002\fB\u0019\u0011&!$\n\u0007\u0005=UD\u0001\u000bNsN\u000bFjQ8n\u0013:LG\u000f\u00122QC\u000e\\W\r^\u0001\u000bQ\u0006tG\r\\3Rk&$HCBA6\u0003+\u000b9\nC\u0004\u0002\"a\u0001\r!a\t\t\u000f\u0005m\u0004\u00041\u0001\u0002\u001aB\u0019\u0011&a'\n\u0007\u0005uUD\u0001\nNsN\u000bFjQ8n#VLG\u000fU1dW\u0016$\u0018a\u00035b]\u0012dW-U;fef$b!a\u001b\u0002$\u0006\u0015\u0006bBA\u00113\u0001\u0007\u00111\u0005\u0005\b\u0003wJ\u0002\u0019AAT!\rI\u0013\u0011V\u0005\u0004\u0003Wk\"aE'z'Fc5i\\7Rk\u0016\u0014\u0018\u0010U1dW\u0016$\u0018\u0001E3yK\u000e,H/Z*uCR,W.\u001a8u)\u0019\t\t,a.\u0002:B\u0019\u0011&a-\n\u0007\u0005UVD\u0001\tNsN\u000bF*U;fef\u0014Vm];mi\"9\u0011\u0011\u0005\u000eA\u0002\u0005\r\u0002bBA^5\u0001\u0007\u0011QX\u0001\u0004gFd\u0007\u0003BA`\u0003\u000ftA!!1\u0002DB\u0019\u0011\u0011\b\u0018\n\u0007\u0005\u0015g&\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0013\fYM\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u000bt\u0013A\u00052f\u000bb,7-\u001e;f'R\fG/Z7f]R$b!!-\u0002R\u0006M\u0007bBA\u00117\u0001\u0007\u00111\u0005\u0005\b\u0003w[\u0002\u0019AA_\u0001")
public class MySQLCommandHandler
extends SimpleChannelInboundHandler<MySQLCommandPacket>
implements Logging {
    private final BackendService be;
    private final ExecutionContextExecutor ec;
    private volatile boolean closed;
    private transient Logger org$apache$kyuubi$Logging$$log_;

    public static ConcurrentHashMap<Object, SessionHandle> connIdToSessHandle() {
        return MySQLCommandHandler$.MODULE$.connIdToSessHandle();
    }

    public static AtomicInteger connIdCounter() {
        return MySQLCommandHandler$.MODULE$.connIdCounter();
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    private ExecutionContextExecutor ec() {
        return this.ec;
    }

    private boolean closed() {
        return this.closed;
    }

    private void closed_$eq(boolean x$1) {
        this.closed = x$1;
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        this.closeSession(ctx);
        super.channelInactive(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        Integer connectionId = (Integer)ctx.channel().attr(MySQLCtxAttrKey$.MODULE$.CONNECTION_ID()).get();
        MySQLErrPacket errPacket = MySQLErrPacket$.MODULE$.apply(cause);
        this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(14).append("Connection: ").append(connectionId).append(", ").append(errPacket).toString());
        if (ctx.channel().isActive()) {
            ctx.writeAndFlush((Object)errPacket);
        } else {
            this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Ignore error packet for inactivated connection: ").append(connectionId).toString());
        }
    }

    public void channelRead0(ChannelHandlerContext ctx, MySQLCommandPacket packet) {
        Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Seq<MySQLPacket> seq;
            this.ensureSessionOpened(ctx);
            MySQLCommandPacket mySQLCommandPacket = packet;
            if (mySQLCommandPacket instanceof MySQLComPingPacket) {
                MySQLComPingPacket mySQLComPingPacket = (MySQLComPingPacket)mySQLCommandPacket;
                seq = this.handlePing(ctx, mySQLComPingPacket);
            } else if (mySQLCommandPacket instanceof MySQLComInitDbPacket) {
                MySQLComInitDbPacket mySQLComInitDbPacket = (MySQLComInitDbPacket)mySQLCommandPacket;
                seq = this.handleInitDb(ctx, mySQLComInitDbPacket);
            } else if (mySQLCommandPacket instanceof MySQLComQuitPacket) {
                MySQLComQuitPacket mySQLComQuitPacket = (MySQLComQuitPacket)mySQLCommandPacket;
                seq = this.handleQuit(ctx, mySQLComQuitPacket);
            } else if (mySQLCommandPacket instanceof MySQLComQueryPacket) {
                MySQLComQueryPacket mySQLComQueryPacket = (MySQLComQueryPacket)mySQLCommandPacket;
                seq = this.handleQuery(ctx, mySQLComQueryPacket);
            } else {
                throw new UnsupportedOperationException(mySQLCommandPacket.getClass().getSimpleName());
            }
            return seq;
        }, (ExecutionContext)this.ec()).onComplete((Function1 & Serializable & scala.Serializable)x0$1 -> {
            BoxedUnit boxedUnit;
            Try try_ = x0$1;
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                Seq responsePackets = (Seq)success.value();
                Channel channel = ctx.channel();
                responsePackets.foreach((Function1 & Serializable & scala.Serializable)x$1 -> channel.write(x$1));
                boxedUnit = ctx.channel().flush();
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable cause = failure.exception();
                this.exceptionCaught(ctx, cause);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)try_);
            }
            return boxedUnit;
        }, (ExecutionContext)this.ec());
    }

    public void ensureSessionOpened(ChannelHandlerContext ctx) {
        if (ctx.channel().attr(MySQLCtxAttrKey$.MODULE$.SESSION_HANDLE()).get() == null) {
            MySQLCommandHandler mySQLCommandHandler = this;
            synchronized (mySQLCommandHandler) {
                BoxedUnit boxedUnit;
                if (ctx.channel().attr(MySQLCtxAttrKey$.MODULE$.SESSION_HANDLE()).get() == null) {
                    SessionHandle sessionHandle = this.openSession(ctx);
                    ctx.channel().attr(MySQLCtxAttrKey$.MODULE$.SESSION_HANDLE()).set((Object)sessionHandle);
                    Integer connectionId = (Integer)ctx.channel().attr(MySQLCtxAttrKey$.MODULE$.CONNECTION_ID()).get();
                    boxedUnit = MySQLCommandHandler$.MODULE$.connIdToSessHandle().put(BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(connectionId)), sessionHandle);
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
        }
    }

    public synchronized SessionHandle openSession(ChannelHandlerContext ctx) {
        SessionHandle sessionHandle;
        try {
            SessionHandle sessionHandle2;
            Map map;
            String user = (String)ctx.channel().attr(MySQLCtxAttrKey$.MODULE$.USER()).get();
            String remoteIp = (String)ctx.channel().attr(MySQLCtxAttrKey$.MODULE$.REMOTE_IP()).get();
            Option option = Option$.MODULE$.apply(ctx.channel().attr(MySQLCtxAttrKey$.MODULE$.DATABASE()).get());
            if (option instanceof Some) {
                Some some = (Some)option;
                String db = (String)some.value();
                map = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"use:database"), (Object)db)}));
            } else if (None$.MODULE$.equals(option)) {
                map = Predef$.MODULE$.Map().empty();
            } else {
                throw new MatchError((Object)option);
            }
            Map sessionConf = map;
            TProtocolVersion proto = TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V1;
            sessionHandle = sessionHandle2 = this.be.openSession(proto, user, "", remoteIp, sessionConf);
        }
        catch (Exception rethrow) {
            this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Error opening session: ").append(rethrow.getMessage()).toString());
            throw rethrow;
        }
        return sessionHandle;
    }

    public synchronized void closeSession(ChannelHandlerContext ctx) {
        block6: {
            if (this.closed()) break block6;
            SessionHandle handle = (SessionHandle)ctx.channel().attr(MySQLCtxAttrKey$.MODULE$.SESSION_HANDLE()).get();
            this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Received request of closing ").append(handle).toString());
            try {
                try {
                    this.be.closeSession(handle);
                }
                catch (Exception rethrow) {
                    this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Error closing session: ").append(rethrow.getMessage()).toString());
                    throw rethrow;
                }
            }
            finally {
                Integer connectionId = (Integer)ctx.channel().attr(MySQLCtxAttrKey$.MODULE$.CONNECTION_ID()).getAndSet(null);
                ctx.channel().attr(MySQLCtxAttrKey$.MODULE$.SESSION_HANDLE()).set(null);
                MySQLCommandHandler$.MODULE$.connIdToSessHandle().remove(connectionId);
            }
            this.closed_$eq(true);
            this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Finished closing ").append(handle).toString());
        }
    }

    public Seq<MySQLPacket> handlePing(ChannelHandlerContext ctx, MySQLComPingPacket pkg) {
        MySQLOKPacket mySQLOKPacket = new MySQLOKPacket(1, MySQLOKPacket$.MODULE$.apply$default$2(), MySQLOKPacket$.MODULE$.apply$default$3());
        return Nil$.MODULE$.$colon$colon((Object)mySQLOKPacket);
    }

    public Seq<MySQLPacket> handleInitDb(ChannelHandlerContext ctx, MySQLComInitDbPacket pkg) {
        this.beExecuteStatement(ctx, new StringBuilder(4).append("use ").append(pkg.database()).toString());
        MySQLOKPacket mySQLOKPacket = new MySQLOKPacket(1, MySQLOKPacket$.MODULE$.apply$default$2(), MySQLOKPacket$.MODULE$.apply$default$3());
        return Nil$.MODULE$.$colon$colon((Object)mySQLOKPacket);
    }

    public Seq<MySQLPacket> handleQuit(ChannelHandlerContext ctx, MySQLComQuitPacket pkg) {
        this.closeSession(ctx);
        MySQLOKPacket mySQLOKPacket = new MySQLOKPacket(1, MySQLOKPacket$.MODULE$.apply$default$2(), MySQLOKPacket$.MODULE$.apply$default$3());
        return Nil$.MODULE$.$colon$colon((Object)mySQLOKPacket);
    }

    public Seq<MySQLPacket> handleQuery(ChannelHandlerContext ctx, MySQLComQueryPacket pkg) {
        this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("Receive query: ").append(pkg.sql()).toString());
        return this.executeStatement(ctx, pkg.sql()).toPackets();
    }

    public MySQLQueryResult executeStatement(ChannelHandlerContext ctx, String sql) {
        String newSQL = MySQLDialectHelper$.MODULE$.convertQuery(sql);
        String string = sql;
        String string2 = newSQL;
        if (string == null ? string2 != null : !string.equals(string2)) {
            this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(13).append("Converted to ").append(newSQL).toString());
        }
        return MySQLDialectHelper$.MODULE$.shouldExecuteLocal(newSQL) ? MySQLDialectHelper$.MODULE$.localExecuteStatement(ctx, newSQL) : this.beExecuteStatement(ctx, newSQL);
    }

    private MySQLQueryResult beExecuteStatement(ChannelHandlerContext ctx, String sql) {
        MySQLThriftQueryResult mySQLThriftQueryResult;
        try {
            SessionHandle ssHandle = (SessionHandle)ctx.channel().attr(MySQLCtxAttrKey$.MODULE$.SESSION_HANDLE()).get();
            OperationHandle opHandle = this.be.executeStatement(ssHandle, sql, false, 0L);
            OperationStatus opStatus = this.be.getOperationStatus(opHandle);
            Enumeration.Value value = opStatus.state();
            Enumeration.Value value2 = OperationState$.MODULE$.FINISHED();
            if (value == null ? value2 != null : !value.equals(value2)) {
                throw (Throwable)opStatus.exception().getOrElse((Function0 & Serializable & scala.Serializable)() -> KyuubiSQLException$.MODULE$.apply(new StringBuilder(21).append("Error operator state ").append(opStatus.state()).toString(), KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4()));
            }
            TTableSchema tableSchema = this.be.getResultSetMetadata(opHandle);
            TRowSet rowSet = this.be.fetchResults(opHandle, FetchOrientation$.MODULE$.FETCH_NEXT(), Integer.MAX_VALUE, false);
            mySQLThriftQueryResult = MySQLQueryResult$.MODULE$.apply(tableSchema, rowSet);
        }
        catch (Exception rethrow) {
            this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Error executing statement: ", rethrow);
            throw rethrow;
        }
        return mySQLThriftQueryResult;
    }

    public MySQLCommandHandler(BackendService be, ThreadPoolExecutor execPool) {
        this.be = be;
        Logging.$init$((Logging)this);
        this.ec = ExecutionContext$.MODULE$.fromExecutor((Executor)execPool);
        this.closed = false;
    }
}

