/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.vertx.core.impl.transports;

import java.net.SocketAddress;
import java.util.concurrent.ThreadFactory;
import org.apache.kyuubi.shade.io.netty.bootstrap.Bootstrap;
import org.apache.kyuubi.shade.io.netty.bootstrap.ServerBootstrap;
import org.apache.kyuubi.shade.io.netty.channel.Channel;
import org.apache.kyuubi.shade.io.netty.channel.ChannelFactory;
import org.apache.kyuubi.shade.io.netty.channel.EventLoopGroup;
import org.apache.kyuubi.shade.io.netty.channel.ServerChannel;
import org.apache.kyuubi.shade.io.netty.channel.epoll.Epoll;
import org.apache.kyuubi.shade.io.netty.channel.epoll.EpollChannelOption;
import org.apache.kyuubi.shade.io.netty.channel.epoll.EpollDatagramChannel;
import org.apache.kyuubi.shade.io.netty.channel.epoll.EpollDomainSocketChannel;
import org.apache.kyuubi.shade.io.netty.channel.epoll.EpollEventLoopGroup;
import org.apache.kyuubi.shade.io.netty.channel.epoll.EpollServerDomainSocketChannel;
import org.apache.kyuubi.shade.io.netty.channel.epoll.EpollServerSocketChannel;
import org.apache.kyuubi.shade.io.netty.channel.epoll.EpollSocketChannel;
import org.apache.kyuubi.shade.io.netty.channel.socket.DatagramChannel;
import org.apache.kyuubi.shade.io.netty.channel.socket.InternetProtocolFamily;
import org.apache.kyuubi.shade.io.netty.channel.unix.DomainSocketAddress;
import org.apache.kyuubi.shade.io.vertx.core.datagram.DatagramSocketOptions;
import org.apache.kyuubi.shade.io.vertx.core.net.ClientOptionsBase;
import org.apache.kyuubi.shade.io.vertx.core.net.NetServerOptions;
import org.apache.kyuubi.shade.io.vertx.core.net.impl.SocketAddressImpl;
import org.apache.kyuubi.shade.io.vertx.core.spi.transport.Transport;

public class EpollTransport
implements Transport {
    private static volatile int pendingFastOpenRequestsThreshold = 256;

    public static int getPendingFastOpenRequestsThreshold() {
        return pendingFastOpenRequestsThreshold;
    }

    public static void setPendingFastOpenRequestsThreshold(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("Invalid " + value);
        }
        pendingFastOpenRequestsThreshold = value;
    }

    @Override
    public boolean supportsDomainSockets() {
        return true;
    }

    @Override
    public SocketAddress convert(org.apache.kyuubi.shade.io.vertx.core.net.SocketAddress address) {
        if (address.isDomainSocket()) {
            return new DomainSocketAddress(address.path());
        }
        return Transport.super.convert(address);
    }

    @Override
    public org.apache.kyuubi.shade.io.vertx.core.net.SocketAddress convert(SocketAddress address) {
        if (address instanceof DomainSocketAddress) {
            return new SocketAddressImpl(((DomainSocketAddress)address).path());
        }
        return Transport.super.convert(address);
    }

    @Override
    public boolean isAvailable() {
        return Epoll.isAvailable();
    }

    @Override
    public Throwable unavailabilityCause() {
        return Epoll.unavailabilityCause();
    }

    @Override
    public EventLoopGroup eventLoopGroup(int type, int nThreads, ThreadFactory threadFactory, int ioRatio) {
        EpollEventLoopGroup eventLoopGroup = new EpollEventLoopGroup(nThreads, threadFactory);
        eventLoopGroup.setIoRatio(ioRatio);
        return eventLoopGroup;
    }

    @Override
    public DatagramChannel datagramChannel() {
        return new EpollDatagramChannel();
    }

    @Override
    public DatagramChannel datagramChannel(InternetProtocolFamily family) {
        return new EpollDatagramChannel();
    }

    @Override
    public ChannelFactory<? extends Channel> channelFactory(boolean domainSocket) {
        if (domainSocket) {
            return EpollDomainSocketChannel::new;
        }
        return EpollSocketChannel::new;
    }

    @Override
    public ChannelFactory<? extends ServerChannel> serverChannelFactory(boolean domainSocket) {
        if (domainSocket) {
            return EpollServerDomainSocketChannel::new;
        }
        return EpollServerSocketChannel::new;
    }

    @Override
    public void configure(DatagramChannel channel, DatagramSocketOptions options) {
        channel.config().setOption(EpollChannelOption.SO_REUSEPORT, options.isReusePort());
        Transport.super.configure(channel, options);
    }

    @Override
    public void configure(NetServerOptions options, boolean domainSocket, ServerBootstrap bootstrap) {
        if (!domainSocket) {
            bootstrap.option(EpollChannelOption.SO_REUSEPORT, options.isReusePort());
            if (options.isTcpFastOpen()) {
                bootstrap.option(EpollChannelOption.TCP_FASTOPEN, options.isTcpFastOpen() ? pendingFastOpenRequestsThreshold : 0);
            }
            bootstrap.childOption(EpollChannelOption.TCP_QUICKACK, options.isTcpQuickAck());
            bootstrap.childOption(EpollChannelOption.TCP_CORK, options.isTcpCork());
        }
        Transport.super.configure(options, domainSocket, bootstrap);
    }

    @Override
    public void configure(ClientOptionsBase options, boolean domainSocket, Bootstrap bootstrap) {
        if (!domainSocket) {
            if (options.isTcpFastOpen()) {
                bootstrap.option(EpollChannelOption.TCP_FASTOPEN_CONNECT, options.isTcpFastOpen());
            }
            bootstrap.option(EpollChannelOption.TCP_USER_TIMEOUT, options.getTcpUserTimeout());
            bootstrap.option(EpollChannelOption.TCP_QUICKACK, options.isTcpQuickAck());
            bootstrap.option(EpollChannelOption.TCP_CORK, options.isTcpCork());
        }
        Transport.super.configure(options, domainSocket, bootstrap);
    }
}

