/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.etcd.jetcd.options;

import java.util.Objects;
import java.util.Optional;
import org.apache.kyuubi.shade.io.etcd.jetcd.ByteSequence;
import org.apache.kyuubi.shade.io.etcd.jetcd.options.OptionsUtil;

public final class DeleteOption {
    public static final DeleteOption DEFAULT = DeleteOption.builder().build();
    private final ByteSequence endKey;
    private final boolean prevKV;
    private final boolean prefix;

    private DeleteOption(ByteSequence endKey, boolean prevKV, boolean prefix) {
        this.endKey = endKey;
        this.prevKV = prevKV;
        this.prefix = prefix;
    }

    public Optional<ByteSequence> getEndKey() {
        return Optional.ofNullable(this.endKey);
    }

    public boolean isPrevKV() {
        return this.prevKV;
    }

    public boolean isPrefix() {
        return this.prefix;
    }

    @Deprecated
    public static Builder newBuilder() {
        return DeleteOption.builder();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ByteSequence endKey;
        private boolean prevKV = false;
        private boolean prefix = false;

        private Builder() {
        }

        public Builder withRange(ByteSequence endKey) {
            this.endKey = endKey;
            return this;
        }

        public Builder isPrefix(boolean prefix) {
            this.prefix = prefix;
            return this;
        }

        @Deprecated
        public Builder withPrefix(ByteSequence prefix) {
            Objects.requireNonNull(prefix, "prefix should not be null");
            ByteSequence prefixEnd = OptionsUtil.prefixEndOf(prefix);
            this.withRange(prefixEnd);
            return this;
        }

        public Builder withPrevKV(boolean prevKV) {
            this.prevKV = prevKV;
            return this;
        }

        public DeleteOption build() {
            return new DeleteOption(this.endKey, this.prevKV, this.prefix);
        }
    }
}

