/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.steps;

import java.util.List;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.engine.flink.IFlinkOutput;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.DefaultChainedExecutable;
import org.apache.kylin.storage.hbase.steps.HBaseFlinkSteps;
import org.apache.kylin.storage.hbase.steps.HBaseJobSteps;
import org.apache.kylin.storage.hbase.steps.HBaseMRSteps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseFlinkOutputTransition
implements IFlinkOutput {
    private static final Logger logger = LoggerFactory.getLogger(HBaseFlinkOutputTransition.class);

    public IFlinkOutput.IFlinkBatchCubingOutputSide getBatchCubingOutputSide(final CubeSegment seg) {
        final HBaseJobSteps steps = this.buildHBaseJobSteps(seg);
        return new IFlinkOutput.IFlinkBatchCubingOutputSide(){

            public void addStepPhase2_BuildDictionary(DefaultChainedExecutable jobFlow) {
                jobFlow.addTask((AbstractExecutable)steps.createCreateHTableStep(jobFlow.getId()));
            }

            public void addStepPhase3_BuildCube(DefaultChainedExecutable jobFlow) {
                jobFlow.addTask(steps.createConvertCuboidToHfileStep(jobFlow.getId()));
                if (seg.getConfig().isHFileDistCP()) {
                    jobFlow.addTask(steps.createDistcpHFileStep(jobFlow.getId()));
                }
                jobFlow.addTask((AbstractExecutable)steps.createBulkLoadStep(jobFlow.getId()));
            }

            public void addStepPhase4_Cleanup(DefaultChainedExecutable jobFlow) {
            }
        };
    }

    public IFlinkOutput.IFlinkBatchMergeOutputSide getBatchMergeOutputSide(final CubeSegment seg) {
        return new IFlinkOutput.IFlinkBatchMergeOutputSide(){
            final HBaseJobSteps steps;
            {
                this.steps = HBaseFlinkOutputTransition.this.buildHBaseJobSteps(seg);
            }

            public void addStepPhase1_MergeDictionary(DefaultChainedExecutable jobFlow) {
                jobFlow.addTask((AbstractExecutable)this.steps.createCreateHTableStep(jobFlow.getId()));
            }

            public void addStepPhase2_BuildCube(CubeSegment seg2, List<CubeSegment> mergingSegments, DefaultChainedExecutable jobFlow) {
                jobFlow.addTask(this.steps.createConvertCuboidToHfileStep(jobFlow.getId()));
                if (seg2.getConfig().isHFileDistCP()) {
                    jobFlow.addTask(this.steps.createDistcpHFileStep(jobFlow.getId()));
                }
                jobFlow.addTask((AbstractExecutable)this.steps.createBulkLoadStep(jobFlow.getId()));
            }

            public void addStepPhase3_Cleanup(DefaultChainedExecutable jobFlow) {
                this.steps.addMergingGarbageCollectionSteps(jobFlow);
            }
        };
    }

    public IFlinkOutput.IFlinkBatchOptimizeOutputSide getBatchOptimizeOutputSide(CubeSegment seg) {
        return null;
    }

    private HBaseJobSteps buildHBaseJobSteps(CubeSegment seg) {
        if (seg.getConfig().isFlinkCubeHFileEnable()) {
            return new HBaseFlinkSteps(seg);
        }
        return new HBaseMRSteps(seg);
    }
}

