/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.measure.dim;

import java.util.Set;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.shaded.com.google.common.collect.Sets;

public class DimCountDistinctCounter {
    private final Set container;
    private final int MAX_CARD;

    public DimCountDistinctCounter() {
        this.container = Sets.newHashSet();
        this.MAX_CARD = KylinConfig.getInstanceFromEnv().getDimCountDistinctMaxCardinality();
    }

    public DimCountDistinctCounter(Set container, int MAX_CARD) {
        this.container = container;
        this.MAX_CARD = MAX_CARD;
    }

    public DimCountDistinctCounter(DimCountDistinctCounter other) {
        this.container = Sets.newHashSet(other.container);
        this.MAX_CARD = KylinConfig.getInstanceFromEnv().getDimCountDistinctMaxCardinality();
    }

    public void add(Object v) {
        if (this.container.size() >= this.MAX_CARD) {
            throw new RuntimeException("Cardinality of dimension exceeds the threshold: " + this.MAX_CARD);
        }
        this.container.add(v);
    }

    public void addAll(DimCountDistinctCounter counter) {
        if (this.container.size() + counter.container.size() >= this.MAX_CARD) {
            throw new RuntimeException("Cardinality of dimension exceeds the threshold: " + this.MAX_CARD);
        }
        this.container.addAll(counter.container);
    }

    public long result() {
        return this.container.size();
    }

    public int estimateSize() {
        return 20 * this.container.size();
    }

    public Set getContainer() {
        return this.container;
    }

    public int getMAX_CARD() {
        return this.MAX_CARD;
    }
}

