/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.inmemcubing;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.kylin.common.util.MemoryBudgetController;
import org.apache.kylin.gridtable.GTInfo;
import org.apache.kylin.gridtable.GTRecord;
import org.apache.kylin.gridtable.GTScanRequest;
import org.apache.kylin.gridtable.IGTScanner;
import org.apache.kylin.gridtable.IGTStore;
import org.apache.kylin.gridtable.IGTWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemDiskStore
implements IGTStore,
Closeable {
    private static final Logger logger = LoggerFactory.getLogger(MemDiskStore.class);
    private static final boolean debug = false;
    private static final int STREAM_BUFFER_SIZE = 8192;
    private static final int MEM_CHUNK_SIZE_MB = 5;
    private final GTInfo info;
    private final Object lock;
    private final MemPart memPart;
    private final DiskPart diskPart;
    private final boolean delOnClose;
    private Writer ongoingWriter;

    public MemDiskStore(GTInfo info, MemoryBudgetController budgetCtrl) throws IOException {
        this(info, budgetCtrl, File.createTempFile("MemDiskStore", ""), true);
    }

    public MemDiskStore(GTInfo info, MemoryBudgetController budgetCtrl, File diskFile) throws IOException {
        this(info, budgetCtrl, diskFile, false);
    }

    private MemDiskStore(GTInfo info, MemoryBudgetController budgetCtrl, File diskFile, boolean delOnClose) throws IOException {
        this.info = info;
        this.lock = this;
        this.memPart = new MemPart(budgetCtrl);
        this.diskPart = new DiskPart(diskFile);
        this.delOnClose = delOnClose;
        if (delOnClose) {
            diskFile.deleteOnExit();
        }
    }

    @Override
    public GTInfo getInfo() {
        return this.info;
    }

    @Override
    public IGTWriter rebuild() throws IOException {
        return this.newWriter(0L);
    }

    @Override
    public IGTWriter append() throws IOException {
        return this.newWriter(this.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Writer newWriter(long startOffset) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.ongoingWriter != null) {
                throw new IllegalStateException();
            }
            this.ongoingWriter = new Writer(startOffset);
            return this.ongoingWriter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IGTScanner scan(GTScanRequest scanRequest) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            return new Reader();
        }
    }

    @Override
    public void close() throws IOException {
        this.memPart.close();
        this.diskPart.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long length() {
        Object object = this.lock;
        synchronized (object) {
            return Math.max(this.memPart.tailOffset(), this.diskPart.tailOffset);
        }
    }

    public String toString() {
        return "MemDiskStore@" + (this.info.getTableName() == null ? Integer.valueOf(this.hashCode()) : this.info.getTableName());
    }

    private class DiskPart
    implements Closeable {
        final File diskFile;
        FileChannel writeChannel;
        FileChannel readChannel;
        int readerCount = 0;
        long tailOffset;

        DiskPart(File diskFile) throws IOException {
            this.diskFile = diskFile;
            this.tailOffset = diskFile.length();
        }

        public void openRead() throws IOException {
            if (this.readChannel == null) {
                this.readChannel = FileChannel.open(this.diskFile.toPath(), StandardOpenOption.READ);
            }
            ++this.readerCount;
        }

        public int read(long diskOffset, byte[] bytes, int offset, int length) throws IOException {
            return this.readChannel.read(ByteBuffer.wrap(bytes, offset, length), diskOffset);
        }

        public void closeRead() throws IOException {
            this.closeRead(false);
        }

        private void closeRead(boolean force) throws IOException {
            --this.readerCount;
            if ((this.readerCount == 0 || force) && this.readChannel != null) {
                this.readChannel.close();
                this.readChannel = null;
            }
        }

        public void openWrite(boolean append) throws IOException {
            if (append) {
                this.writeChannel = FileChannel.open(this.diskFile.toPath(), StandardOpenOption.CREATE, StandardOpenOption.APPEND, StandardOpenOption.WRITE);
                this.tailOffset = this.diskFile.length();
            } else {
                this.diskFile.delete();
                this.writeChannel = FileChannel.open(this.diskFile.toPath(), StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
                this.tailOffset = 0L;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int write(long diskOffset, byte[] bytes, int offset, int length) throws IOException {
            Object object = MemDiskStore.this.lock;
            synchronized (object) {
                int n = this.writeChannel.write(ByteBuffer.wrap(bytes, offset, length), diskOffset);
                this.tailOffset = Math.max(diskOffset + (long)n, this.tailOffset);
                return n;
            }
        }

        public void closeWrite() throws IOException {
            if (this.writeChannel != null) {
                this.writeChannel.close();
                this.writeChannel = null;
            }
        }

        public void clear() throws IOException {
            this.diskFile.delete();
            this.tailOffset = 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            Object object = MemDiskStore.this.lock;
            synchronized (object) {
                this.closeWrite();
                this.closeRead(true);
                if (MemDiskStore.this.delOnClose) {
                    this.diskFile.delete();
                }
            }
        }
    }

    private class MemPart
    implements Closeable,
    MemoryBudgetController.MemoryConsumer {
        final MemoryBudgetController budgetCtrl;
        volatile boolean writeActivated;
        MemChunk firstChunk;
        MemChunk lastChunk;
        int chunkCount;
        Thread asyncFlusher;
        MemChunk asyncFlushChunk;
        long asyncFlushDiskOffset;
        Throwable asyncFlushException;

        MemPart(MemoryBudgetController budgetCtrl) {
            this.budgetCtrl = budgetCtrl;
        }

        long headOffset() {
            return this.firstChunk == null ? 0L : this.firstChunk.headOffset();
        }

        long tailOffset() {
            return this.lastChunk == null ? 0L : this.lastChunk.tailOffset();
        }

        public MemChunk seekMemChunk(long diskOffset) {
            MemChunk c = this.firstChunk;
            while (c != null && c.headOffset() <= diskOffset && diskOffset >= c.tailOffset()) {
                c = c.next;
            }
            return c;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int write(byte[] bytes, int offset, int length, long diskOffset) {
            int needMoreMem = 0;
            Object object = MemDiskStore.this.lock;
            synchronized (object) {
                if (!this.writeActivated) {
                    return 0;
                }
                if (diskOffset != this.tailOffset()) {
                    return 0;
                }
                if (this.chunkCount == 0 || this.lastChunk.isFull()) {
                    needMoreMem = (this.chunkCount + 1) * 5;
                }
            }
            if (needMoreMem > 0) {
                try {
                    this.budgetCtrl.reserve(this, needMoreMem);
                }
                catch (MemoryBudgetController.NotEnoughBudgetException ex) {
                    this.deactivateMemWrite();
                    return 0;
                }
            }
            object = MemDiskStore.this.lock;
            synchronized (object) {
                if (needMoreMem > 0 && (this.chunkCount == 0 || this.lastChunk.isFull())) {
                    MemChunk chunk = new MemChunk();
                    chunk.diskOffset = diskOffset;
                    chunk.data = new byte[5242832];
                    if (this.chunkCount == 0) {
                        this.firstChunk = this.lastChunk = chunk;
                    } else {
                        this.lastChunk.next = chunk;
                        this.lastChunk = chunk;
                    }
                    ++this.chunkCount;
                }
                int n = Math.min(this.lastChunk.freeSpace(), length);
                System.arraycopy(bytes, offset, this.lastChunk.data, this.lastChunk.length, n);
                this.lastChunk.length += n;
                if (n > 0) {
                    this.asyncFlush(this.lastChunk, diskOffset, n);
                }
                return n;
            }
        }

        private void asyncFlush(MemChunk lastChunk, long diskOffset, int n) {
            if (this.asyncFlushChunk == null) {
                this.asyncFlushChunk = lastChunk;
                this.asyncFlushDiskOffset = diskOffset;
            }
            if (this.asyncFlusher == null) {
                this.asyncFlusher = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        MemPart.this.asyncFlushException = null;
                        try {
                            while (MemPart.this.writeActivated) {
                                MemPart.this.flushToDisk();
                                Thread.sleep(10L);
                            }
                            MemPart.this.flushToDisk();
                            Object object = MemDiskStore.this.lock;
                            synchronized (object) {
                                MemPart.this.asyncFlusher = null;
                                MemPart.this.asyncFlushChunk = null;
                                if (((MemDiskStore)MemDiskStore.this).ongoingWriter.closed) {
                                    MemDiskStore.this.ongoingWriter.close();
                                }
                            }
                        }
                        catch (Throwable ex) {
                            MemPart.this.asyncFlushException = ex;
                        }
                    }
                };
                this.asyncFlusher.start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void flushToDisk() throws IOException {
            int offset = 0;
            int length = 0;
            int flushedLen = 0;
            while (true) {
                byte[] data = null;
                Object object = MemDiskStore.this.lock;
                synchronized (object) {
                    this.asyncFlushDiskOffset += (long)flushedLen;
                    if (this.asyncFlushChunk != null && this.asyncFlushChunk.tailOffset() == this.asyncFlushDiskOffset) {
                        this.asyncFlushChunk = this.asyncFlushChunk.next;
                    }
                    if (this.asyncFlushChunk != null) {
                        data = this.asyncFlushChunk.data;
                        offset = (int)(this.asyncFlushDiskOffset - this.asyncFlushChunk.headOffset());
                        length = this.asyncFlushChunk.length - offset;
                    }
                }
                if (data == null) break;
                flushedLen = MemDiskStore.this.diskPart.write(this.asyncFlushDiskOffset, data, offset, length);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int freeUp(int mb) {
            Object object = MemDiskStore.this.lock;
            synchronized (object) {
                int mbReleased = 0;
                while (this.chunkCount > 0 && mbReleased < mb && this.firstChunk != this.asyncFlushChunk) {
                    mbReleased += 5;
                    --this.chunkCount;
                    if (this.chunkCount == 0) {
                        this.lastChunk = null;
                        this.firstChunk = null;
                        continue;
                    }
                    MemChunk next = this.firstChunk.next;
                    this.firstChunk.next = null;
                    this.firstChunk = next;
                }
                return mbReleased;
            }
        }

        public void activateMemWrite() {
            if (this.budgetCtrl.getTotalBudgetMB() > 0) {
                this.writeActivated = true;
            }
        }

        public void deactivateMemWrite() {
            this.writeActivated = false;
        }

        public void clear() {
            this.chunkCount = 0;
            this.lastChunk = null;
            this.firstChunk = null;
            this.budgetCtrl.reserve(this, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            Object object = MemDiskStore.this.lock;
            synchronized (object) {
                if (this.asyncFlushException != null) {
                    this.throwAsyncException(this.asyncFlushException);
                }
            }
            try {
                this.asyncFlusher.join();
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.warn("async join interrupted", (Throwable)e);
            }
            object = MemDiskStore.this.lock;
            synchronized (object) {
                if (this.asyncFlushException != null) {
                    this.throwAsyncException(this.asyncFlushException);
                }
                this.clear();
            }
        }

        private void throwAsyncException(Throwable ex) throws IOException {
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            throw new IOException(ex);
        }

        public String toString() {
            return MemDiskStore.this.toString();
        }
    }

    private static class MemChunk {
        long diskOffset;
        int length;
        byte[] data;
        MemChunk next;

        private MemChunk() {
        }

        boolean isFull() {
            return this.length == this.data.length;
        }

        long headOffset() {
            return this.diskOffset;
        }

        long tailOffset() {
            return this.diskOffset + (long)this.length;
        }

        int freeSpace() {
            return this.data.length - this.length;
        }
    }

    private class Writer
    implements IGTWriter {
        final DataOutputStream dout;
        final ByteBuffer buf;
        long writeOffset;
        long memWrite = 0L;
        long diskWrite = 0L;
        int nWriteCalls;
        boolean closed = false;

        Writer(long startOffset) throws IOException {
            this.buf = ByteBuffer.allocate(MemDiskStore.this.info.getMaxRecordLength());
            this.writeOffset = 0L;
            MemDiskStore.this.memPart.clear();
            MemDiskStore.this.diskPart.clear();
            MemDiskStore.this.diskPart.openWrite(false);
            MemDiskStore.this.memPart.activateMemWrite();
            OutputStream out = new OutputStream(){
                byte[] tmp = new byte[1];
                boolean memPartActivated = true;

                @Override
                public void write(int b) throws IOException {
                    this.tmp[0] = (byte)b;
                    this.write(this.tmp, 0, 1);
                }

                @Override
                public void write(byte[] bytes, int offset, int length) throws IOException {
                    ++Writer.this.nWriteCalls;
                    while (length > 0) {
                        int n;
                        if (this.memPartActivated) {
                            n = MemDiskStore.this.memPart.write(bytes, offset, length, Writer.this.writeOffset);
                            Writer.this.memWrite += (long)n;
                            if (n == 0) {
                                this.memPartActivated = false;
                            }
                        } else {
                            n = MemDiskStore.this.diskPart.write(Writer.this.writeOffset, bytes, offset, length);
                            Writer.this.diskWrite += (long)n;
                        }
                        offset += n;
                        length -= n;
                        Writer.this.writeOffset += (long)n;
                    }
                }
            };
            this.dout = new DataOutputStream(new BufferedOutputStream(out, 8192));
        }

        @Override
        public void write(GTRecord rec) throws IOException {
            this.buf.clear();
            rec.exportColumns(MemDiskStore.this.info.getAllColumns(), this.buf);
            int len = this.buf.position();
            this.dout.writeInt(len);
            this.dout.write(this.buf.array(), this.buf.arrayOffset(), len);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            Object object = MemDiskStore.this.lock;
            synchronized (object) {
                if (!this.closed) {
                    this.dout.close();
                    MemDiskStore.this.memPart.deactivateMemWrite();
                }
                if (((MemDiskStore)MemDiskStore.this).memPart.asyncFlusher == null) {
                    assert (this.writeOffset == ((MemDiskStore)MemDiskStore.this).diskPart.tailOffset);
                    MemDiskStore.this.diskPart.closeWrite();
                    MemDiskStore.this.ongoingWriter = null;
                }
                this.closed = true;
            }
        }
    }

    private class Reader
    implements IGTScanner {
        final DataInputStream din;
        long readOffset = 0L;
        long memRead = 0L;
        long diskRead = 0L;
        int nReadCalls = 0;
        int count = 0;

        Reader() throws IOException {
            MemDiskStore.this.diskPart.openRead();
            InputStream in = new InputStream(){
                byte[] tmp = new byte[1];
                MemChunk memChunk;

                @Override
                public int read() throws IOException {
                    int n = this.read(this.tmp, 0, 1);
                    if (n <= 0) {
                        return -1;
                    }
                    return this.tmp[0];
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public int read(byte[] b, int off, int len) throws IOException {
                    Object object = MemDiskStore.this.lock;
                    synchronized (object) {
                        ++Reader.this.nReadCalls;
                        if (this.available() <= 0) {
                            return -1;
                        }
                        if (this.memChunk == null && MemDiskStore.this.memPart.headOffset() <= Reader.this.readOffset && Reader.this.readOffset < MemDiskStore.this.memPart.tailOffset()) {
                            this.memChunk = MemDiskStore.this.memPart.seekMemChunk(Reader.this.readOffset);
                        }
                        int lenToGo = Math.min(this.available(), len);
                        int nRead = 0;
                        while (lenToGo > 0) {
                            int n;
                            if (this.memChunk != null) {
                                if (this.memChunk.headOffset() > Reader.this.readOffset) {
                                    this.memChunk = null;
                                    continue;
                                }
                                if (Reader.this.readOffset >= this.memChunk.tailOffset()) {
                                    this.memChunk = this.memChunk.next;
                                    continue;
                                }
                                int chunkOffset = (int)(Reader.this.readOffset - this.memChunk.headOffset());
                                n = Math.min((int)(this.memChunk.tailOffset() - Reader.this.readOffset), lenToGo);
                                System.arraycopy(this.memChunk.data, chunkOffset, b, off, n);
                                Reader.this.memRead += (long)n;
                            } else {
                                n = MemDiskStore.this.diskPart.read(Reader.this.readOffset, b, off, lenToGo);
                                Reader.this.diskRead += (long)n;
                            }
                            lenToGo -= n;
                            nRead += n;
                            off += n;
                            Reader.this.readOffset += (long)n;
                        }
                        return nRead;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public int available() throws IOException {
                    Object object = MemDiskStore.this.lock;
                    synchronized (object) {
                        return (int)(MemDiskStore.this.length() - Reader.this.readOffset);
                    }
                }
            };
            this.din = new DataInputStream(new BufferedInputStream(in, 8192));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            Object object = MemDiskStore.this.lock;
            synchronized (object) {
                this.din.close();
                MemDiskStore.this.diskPart.closeRead();
            }
        }

        @Override
        public Iterator<GTRecord> iterator() {
            this.count = 0;
            return new Iterator<GTRecord>(){
                GTRecord record;
                GTRecord next;
                ByteBuffer buf;
                {
                    this.record = new GTRecord(MemDiskStore.this.info);
                    this.buf = ByteBuffer.allocate(MemDiskStore.this.info.getMaxRecordLength());
                }

                @Override
                public boolean hasNext() {
                    if (this.next != null) {
                        return true;
                    }
                    try {
                        if (Reader.this.din.available() > 0) {
                            int len = Reader.this.din.readInt();
                            Reader.this.din.read(this.buf.array(), this.buf.arrayOffset(), len);
                            this.buf.clear();
                            this.buf.limit(len);
                            this.record.loadColumns(MemDiskStore.this.info.getAllColumns(), this.buf);
                            this.next = this.record;
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    return this.next != null;
                }

                @Override
                public GTRecord next() {
                    if (this.next == null) {
                        this.hasNext();
                        if (this.next == null) {
                            throw new NoSuchElementException();
                        }
                    }
                    GTRecord r = this.next;
                    this.next = null;
                    ++Reader.this.count;
                    return r;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public GTInfo getInfo() {
            return MemDiskStore.this.info;
        }
    }
}

