/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.metrics;

import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.CsvReporter;
import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jvm.CachedThreadStatesGaugeSet;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import java.io.File;
import java.util.concurrent.TimeUnit;
import org.apache.kylin.common.KylinConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingMetrics {
    public static final String CONSUME_RATE_PFX = "streaming.events.consume.cnt";
    private static Logger logger = LoggerFactory.getLogger(StreamingMetrics.class);
    private static final String METRICS_OPTION = KylinConfig.getInstanceFromEnv().getStreamMetrics();
    private static final long STREAM_METRICS_INTERVAL = KylinConfig.getInstanceFromEnv().getStreamMetricsInterval();
    private final MetricRegistry metricRegistry = new MetricRegistry();
    private static StreamingMetrics instance = new StreamingMetrics();

    private StreamingMetrics() {
        if (METRICS_OPTION != null && !METRICS_OPTION.isEmpty()) {
            this.metricRegistry.register("gc", (Metric)new GarbageCollectorMetricSet());
            this.metricRegistry.register("threads", (Metric)new CachedThreadStatesGaugeSet(10L, TimeUnit.SECONDS));
            this.metricRegistry.register("memory", (Metric)new MemoryUsageGaugeSet());
        }
    }

    public static StreamingMetrics getInstance() {
        return instance;
    }

    public static Meter newMeter(String name) {
        MetricRegistry metrics = StreamingMetrics.getInstance().getMetricRegistry();
        return metrics.meter(name);
    }

    public MetricRegistry getMetricRegistry() {
        return this.metricRegistry;
    }

    public void start() {
        switch (METRICS_OPTION) {
            case "": {
                logger.info("Skip streaming metricRegistry because it is empty.");
                break;
            }
            case "console": {
                logger.info("Use console to collect streaming metricRegistry.");
                ConsoleReporter consoleReporter = ConsoleReporter.forRegistry((MetricRegistry)this.metricRegistry).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
                consoleReporter.start(STREAM_METRICS_INTERVAL, TimeUnit.SECONDS);
                break;
            }
            case "csv": {
                boolean res;
                File metricsFolder = new File("stream_metrics_csv");
                if (!metricsFolder.exists() && !(res = metricsFolder.mkdirs())) {
                    logger.error("Cannot create dir for stream_metrics_csv");
                    break;
                }
                logger.info("Collect streaming metricRegistry in csv format.");
                CsvReporter scvReporter = CsvReporter.forRegistry((MetricRegistry)this.metricRegistry).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build(metricsFolder);
                scvReporter.start(STREAM_METRICS_INTERVAL, TimeUnit.SECONDS);
                break;
            }
            case "jmx": {
                JmxReporter jmxReporter = JmxReporter.forRegistry((MetricRegistry)this.metricRegistry).build();
                jmxReporter.start();
                break;
            }
            default: {
                logger.info("Skip metricRegistry because the option {} is not identified.", (Object)METRICS_OPTION);
            }
        }
    }
}

