/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.client;

import java.io.IOException;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.stream.core.client.ReceiverAdminClient;
import org.apache.kylin.stream.core.model.AssignRequest;
import org.apache.kylin.stream.core.model.ConsumerStatsResponse;
import org.apache.kylin.stream.core.model.HealthCheckInfo;
import org.apache.kylin.stream.core.model.Node;
import org.apache.kylin.stream.core.model.PauseConsumersRequest;
import org.apache.kylin.stream.core.model.ResumeConsumerRequest;
import org.apache.kylin.stream.core.model.StartConsumersRequest;
import org.apache.kylin.stream.core.model.StopConsumersRequest;
import org.apache.kylin.stream.core.model.UnAssignRequest;
import org.apache.kylin.stream.core.model.stats.ReceiverCubeStats;
import org.apache.kylin.stream.core.model.stats.ReceiverStats;
import org.apache.kylin.stream.core.util.RestService;
import org.apache.kylin.stream.core.util.RetryCallable;
import org.apache.kylin.stream.core.util.RetryCaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpReceiverAdminClient
implements ReceiverAdminClient {
    private static final Logger logger = LoggerFactory.getLogger(HttpReceiverAdminClient.class);
    private RestService restService;
    private int maxRetry;
    private int retryPauseTime;
    private RetryCaller retryCaller;

    public HttpReceiverAdminClient() {
        int connectionTimeout = KylinConfig.getInstanceFromEnv().getReceiverHttpClientTimeout();
        int readTimeout = 30000;
        this.maxRetry = 3;
        this.retryPauseTime = 1000;
        this.retryCaller = new RetryCaller(this.maxRetry, this.retryPauseTime);
        this.restService = new RestService(connectionTimeout, readTimeout);
    }

    @Override
    public void assign(Node receiver, AssignRequest assignRequest) throws IOException {
        logger.info("send assign request:{} to receiver:{}", (Object)assignRequest, (Object)receiver);
        String url = "http://" + receiver.getHost() + ":" + receiver.getPort() + "/kylin/api/admin/assign";
        String content = JsonUtil.writeValueAsString(assignRequest);
        this.retryPostRequest(url, content);
    }

    @Override
    public void unAssign(Node receiver, UnAssignRequest unAssignRequest) throws IOException {
        logger.info("send unAssign request:{} to receiver:{}", (Object)unAssignRequest, (Object)receiver);
        String url = "http://" + receiver.getHost() + ":" + receiver.getPort() + "/kylin/api/admin/unAssign";
        String content = JsonUtil.writeValueAsString(unAssignRequest);
        this.retryPostRequest(url, content);
    }

    @Override
    public void startConsumers(Node receiver, StartConsumersRequest startRequest) throws IOException {
        logger.info("send start request:{} to receiver:{}", (Object)startRequest, (Object)receiver);
        String url = "http://" + receiver.getHost() + ":" + receiver.getPort() + "/kylin/api/admin/consumers/start";
        String content = JsonUtil.writeValueAsString(startRequest);
        this.retryPostRequest(url, content);
    }

    @Override
    public ConsumerStatsResponse stopConsumers(Node receiver, StopConsumersRequest stopRequest) throws IOException {
        logger.info("send stop consume request:{} to receiver:{}", (Object)stopRequest, (Object)receiver);
        String url = "http://" + receiver.getHost() + ":" + receiver.getPort() + "/kylin/api/admin/consumers/stop";
        String content = JsonUtil.writeValueAsString(stopRequest);
        String retMsg = this.retryPostRequest(url, content);
        return JsonUtil.readValue(retMsg, ConsumerStatsResponse.class);
    }

    @Override
    public ConsumerStatsResponse pauseConsumers(Node receiver, PauseConsumersRequest suspendRequest) throws IOException {
        logger.info("send pause consumer request:{} to receiver:{}", (Object)suspendRequest, (Object)receiver);
        String url = "http://" + receiver.getHost() + ":" + receiver.getPort() + "/kylin/api/admin/consumers/pause";
        String content = JsonUtil.writeValueAsString(suspendRequest);
        String retMsg = this.retryPostRequest(url, content);
        return JsonUtil.readValue(retMsg, ConsumerStatsResponse.class);
    }

    @Override
    public ConsumerStatsResponse resumeConsumers(Node receiver, ResumeConsumerRequest resumeRequest) throws IOException {
        logger.info("send resume consumer request:{} to receiver:{}", (Object)resumeRequest, (Object)receiver);
        String url = "http://" + receiver.getHost() + ":" + receiver.getPort() + "/kylin/api/admin/consumers/resume";
        String content = JsonUtil.writeValueAsString(resumeRequest);
        String retMsg = this.retryPostRequest(url, content);
        return JsonUtil.readValue(retMsg, ConsumerStatsResponse.class);
    }

    @Override
    public void removeCubeSegment(Node receiver, String cubeName, String segmentName) throws IOException {
        logger.info("send request to receiver:{} to remove cube segment: {}", (Object)receiver, (Object)(cubeName + "-" + segmentName));
        String url = "http://" + receiver.getHost() + ":" + receiver.getPort() + "/kylin/api/admin/data/" + cubeName + "/" + segmentName;
        this.retryDeleteRequest(url);
    }

    @Override
    public void makeCubeImmutable(Node receiver, String cubeName) throws IOException {
        logger.info("send request to receiver:{} to make cube immutable: {}", (Object)receiver, (Object)cubeName);
        String url = "http://" + receiver.getHost() + ":" + receiver.getPort() + "/kylin/api/admin/data/" + cubeName + "/immutable";
        this.retryPutRequest(url);
    }

    @Override
    public void segmentBuildComplete(Node receiver, String cubeName, String segmentName) throws IOException {
        logger.info("send request to receiver:{} to notify cube segment build complete: {}", (Object)receiver, (Object)(cubeName + "-" + segmentName));
        String url = "http://" + receiver.getHost() + ":" + receiver.getPort() + "/kylin/api/admin/segment_build_complete/" + cubeName + "/" + segmentName;
        this.retryPutRequest(url);
    }

    @Override
    public void addToReplicaSet(Node receiver, int replicaSetID) throws IOException {
        logger.info("send request to receiver:{} to add to replica set: {}", (Object)receiver, (Object)replicaSetID);
        String url = "http://" + receiver.getHost() + ":" + receiver.getPort() + "/kylin/api/admin/replica_set/" + replicaSetID + "/add";
        this.retryPutRequest(url);
    }

    @Override
    public void removeFromReplicaSet(Node receiver) throws IOException {
        logger.info("send request to receiver:{} to remove receiver from replica set", (Object)receiver);
        String url = "http://" + receiver.getHost() + ":" + receiver.getPort() + "/kylin/api/admin/replica_set/remove";
        this.retryPutRequest(url);
    }

    @Override
    public ReceiverStats getReceiverStats(Node receiver) throws IOException {
        logger.info("send request to receiver:{} to get receiver stats ", (Object)receiver);
        String url = "http://" + receiver.getHost() + ":" + receiver.getPort() + "/kylin/api/stats";
        String msg = this.restService.getRequest(url);
        return JsonUtil.readValue(msg, ReceiverStats.class);
    }

    @Override
    public ReceiverCubeStats getReceiverCubeStats(Node receiver, String cubeName) throws IOException {
        logger.info("send request to receiver:{} to get cube stats for cube:{}", (Object)receiver, (Object)cubeName);
        String url = "http://" + receiver.getHost() + ":" + receiver.getPort() + "/kylin/api/stats/cubes/" + cubeName;
        String msg = this.retryGetRequest(url);
        return JsonUtil.readValue(msg, ReceiverCubeStats.class);
    }

    @Override
    public HealthCheckInfo healthCheck(Node receiver) throws IOException {
        logger.info("send request to receiver:{} to do health check", (Object)receiver);
        String url = "http://" + receiver.getHost() + ":" + receiver.getPort() + "/kylin/api/stats/healthCheck";
        String msg = this.restService.getRequest(url);
        return JsonUtil.readValue(msg, HealthCheckInfo.class);
    }

    private String retryPostRequest(final String url, final String postContent) throws IOException {
        return this.retryCaller.call(new RetryCallable<String>(){

            @Override
            public String call() throws Exception {
                return HttpReceiverAdminClient.this.restService.postRequest(url, postContent);
            }

            @Override
            public boolean isResultExpected(String result) {
                return true;
            }

            @Override
            public void update() {
            }
        });
    }

    private String retryDeleteRequest(final String url) throws IOException {
        return this.retryCaller.call(new RetryCallable<String>(){

            @Override
            public String call() throws Exception {
                return HttpReceiverAdminClient.this.restService.deleteRequest(url);
            }

            @Override
            public boolean isResultExpected(String result) {
                return true;
            }

            @Override
            public void update() {
            }
        });
    }

    private String retryGetRequest(final String url) throws IOException {
        return this.retryCaller.call(new RetryCallable<String>(){

            @Override
            public String call() throws Exception {
                return HttpReceiverAdminClient.this.restService.getRequest(url);
            }

            @Override
            public boolean isResultExpected(String result) {
                return true;
            }

            @Override
            public void update() {
            }
        });
    }

    private String retryPutRequest(final String url) throws IOException {
        return this.retryCaller.call(new RetryCallable<String>(){

            @Override
            public String call() throws Exception {
                return HttpReceiverAdminClient.this.restService.putRequest(url);
            }

            @Override
            public boolean isResultExpected(String result) {
                return true;
            }

            @Override
            public void update() {
            }
        });
    }
}

