/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.expression;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import org.apache.kylin.common.util.DecimalUtil;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.datatype.DataTypeSerializer;
import org.apache.kylin.metadata.expression.ExpressionVisitor;
import org.apache.kylin.metadata.filter.IFilterCodeSystem;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.tuple.IEvaluatableTuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TupleExpression {
    static final Logger logger = LoggerFactory.getLogger(TupleExpression.class);
    protected final ExpressionOperatorEnum operator;
    protected final List<TupleExpression> children;
    protected final DataType dataType;
    protected final DataTypeSerializer serializer;
    protected String digest;
    protected Boolean ifAbleToPushDown = null;

    protected TupleExpression(DataType dataType, ExpressionOperatorEnum op, List<TupleExpression> exprs) {
        this.dataType = dataType;
        this.serializer = dataType == null || TblColRef.InnerDataTypeEnum.contains(dataType.getName()) || dataType.equals(DataType.ANY) ? null : DataTypeSerializer.create(dataType);
        this.operator = op;
        this.children = exprs;
    }

    protected boolean ifAbleToPushDown() {
        if (this.ifAbleToPushDown == null) {
            for (TupleExpression child : this.children) {
                this.ifAbleToPushDown = child.ifAbleToPushDown();
                if (this.ifAbleToPushDown.booleanValue()) continue;
                break;
            }
            if (this.ifAbleToPushDown == null) {
                this.ifAbleToPushDown = true;
            }
        }
        return this.ifAbleToPushDown;
    }

    public boolean ifForDynamicColumn() {
        return false;
    }

    public abstract void verify();

    public abstract Object calculate(IEvaluatableTuple var1, IFilterCodeSystem<?> var2);

    public abstract TupleExpression accept(ExpressionVisitor var1);

    public abstract void serialize(IFilterCodeSystem<?> var1, ByteBuffer var2);

    public abstract void deserialize(IFilterCodeSystem<?> var1, ByteBuffer var2);

    public DataType getDataType() {
        return this.dataType;
    }

    public ExpressionOperatorEnum getOperator() {
        return this.operator;
    }

    public void setDigest(String digest) {
        this.digest = digest;
    }

    public String getDigest() {
        return this.digest;
    }

    public boolean hasChildren() {
        return this.children != null && !this.children.isEmpty();
    }

    public List<? extends TupleExpression> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public void addChild(TupleExpression child) {
        this.children.add(child);
    }

    public Object referValue(Object value) {
        return TupleExpression.referValue(value, this.dataType);
    }

    public static DataType referDataType(DataType dt1, DataType dt2) {
        if (dt1 == null || dt2 == null) {
            DataType dt;
            DataType dataType = dt = dt1 == null ? dt2 : dt1;
            if (dt == null) {
                return null;
            }
            if (dt.isNumberFamily()) {
                if (dt.isIntegerFamily()) {
                    return DataType.getType("bigint");
                }
                if (dt.isDecimal()) {
                    return DataType.getType("decimal");
                }
                return DataType.getType("double");
            }
            return dt;
        }
        if (dt1.isNumberFamily() && dt2.isNumberFamily()) {
            if (dt1.isIntegerFamily() && dt2.isIntegerFamily()) {
                return DataType.getType("bigint");
            }
            if (dt1.isDecimal() || dt2.isDecimal()) {
                return DataType.getType("decimal");
            }
            return DataType.getType("double");
        }
        assert (dt1.equals(dt2));
        return dt1;
    }

    public static Object referValue(Object value, DataType dt) {
        if (value == null) {
            return null;
        }
        if (dt != null && dt.isNumberFamily()) {
            Number number = (Number)value;
            if (dt.isIntegerFamily()) {
                return number.longValue();
            }
            if (dt.isDecimal()) {
                return DecimalUtil.toBigDecimal(number);
            }
            return number.doubleValue();
        }
        return value;
    }

    public static enum ExpressionOperatorEnum {
        PLUS(0, "+"),
        MINUS(1, "-"),
        MULTIPLE(2, "*"),
        DIVIDE(3, "/"),
        CASE(10, "Case"),
        COLUMN(20, "InputRef"),
        CONSTANT(21, "Constant"),
        REXCALL(30, "RexCall"),
        NONE(31, "NONE");

        private final int value;
        private final String name;

        private ExpressionOperatorEnum(int value, String name) {
            this.value = value;
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public int getValue() {
            return this.value;
        }
    }
}

