/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.engine.mr.KylinReducer;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.measure.BufferedMeasureCodec;
import org.apache.kylin.measure.MeasureAggregators;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CuboidReducer
extends KylinReducer<Text, Text, Text, Text> {
    private static final Logger logger = LoggerFactory.getLogger(CuboidReducer.class);
    private String cubeName;
    private CubeDesc cubeDesc;
    private List<MeasureDesc> measuresDescs;
    private BufferedMeasureCodec codec;
    private MeasureAggregators aggs;
    private int cuboidLevel;
    private int[] needAggrMeasures;
    private Object[] input;
    private Object[] result;
    private int vcounter;
    private Text outputValue = new Text();

    @Override
    protected void doSetup(Reducer.Context context) throws IOException {
        int i;
        super.bindCurrentConfiguration(context.getConfiguration());
        this.cubeName = context.getConfiguration().get("cube.name").toUpperCase(Locale.ROOT);
        this.cuboidLevel = context.getConfiguration().getInt("cube.cuboid.level", 0);
        KylinConfig config = AbstractHadoopJob.loadKylinPropsAndMetadata();
        this.cubeDesc = CubeManager.getInstance(config).getCube(this.cubeName).getDescriptor();
        this.measuresDescs = this.cubeDesc.getMeasures();
        this.codec = new BufferedMeasureCodec(this.measuresDescs);
        this.aggs = new MeasureAggregators(this.measuresDescs);
        this.input = new Object[this.measuresDescs.size()];
        this.result = new Object[this.measuresDescs.size()];
        ArrayList<Integer> needAggMeasuresList = Lists.newArrayList();
        for (i = 0; i < this.measuresDescs.size(); ++i) {
            if (this.cuboidLevel == 0) {
                needAggMeasuresList.add(i);
                continue;
            }
            if (this.measuresDescs.get(i).getFunction().getMeasureType().onlyAggrInBaseCuboid()) continue;
            needAggMeasuresList.add(i);
        }
        this.needAggrMeasures = new int[needAggMeasuresList.size()];
        for (i = 0; i < needAggMeasuresList.size(); ++i) {
            this.needAggrMeasures[i] = (Integer)needAggMeasuresList.get(i);
        }
    }

    @Override
    public void doReduce(Text key, Iterable<Text> values, Reducer.Context context) throws IOException, InterruptedException {
        this.aggs.reset();
        for (Text value : values) {
            if (this.vcounter++ % 100000 == 0) {
                logger.info("Handling value with ordinal (This is not KV number!): " + this.vcounter);
            }
            this.codec.decode(ByteBuffer.wrap(value.getBytes(), 0, value.getLength()), this.input);
            this.aggs.aggregate(this.input, this.needAggrMeasures);
        }
        this.aggs.collectStates(this.result);
        ByteBuffer valueBuf = this.codec.encode(this.result);
        this.outputValue.set(valueBuf.array(), 0, valueBuf.position());
        context.write((Object)key, (Object)this.outputValue);
    }
}

