/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.common;

import org.apache.hadoop.mapreduce.Job;
import org.apache.kylin.job.constant.JobStepStatusEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopJobStatusChecker {
    protected static final Logger logger = LoggerFactory.getLogger(HadoopJobStatusChecker.class);

    public static JobStepStatusEnum checkStatus(Job job, StringBuilder output) {
        if (job == null || job.getJobID() == null) {
            output.append("Skip status check with empty job id..\n");
            return JobStepStatusEnum.WAITING;
        }
        JobStepStatusEnum status = null;
        try {
            switch (job.getStatus().getState()) {
                case SUCCEEDED: {
                    status = JobStepStatusEnum.FINISHED;
                    break;
                }
                case FAILED: {
                    status = JobStepStatusEnum.ERROR;
                    break;
                }
                case KILLED: {
                    status = JobStepStatusEnum.KILLED;
                    break;
                }
                case RUNNING: {
                    status = JobStepStatusEnum.RUNNING;
                    break;
                }
                case PREP: {
                    status = JobStepStatusEnum.WAITING;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        catch (Exception e) {
            logger.error("error check status", e);
            output.append("Exception: ").append(e.getLocalizedMessage()).append("\n");
            status = JobStepStatusEnum.ERROR;
        }
        return status;
    }
}

