/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence;

import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Locale;
import org.apache.kylin.common.persistence.JDBCSqlQueryFormat;
import org.apache.kylin.common.persistence.JDBCSqlQueryFormatProvider;

public class JDBCResourceSQL {
    private final JDBCSqlQueryFormat format;
    private String tableName;
    private final String metaTableKey;
    private final String metaTableTs;
    private final String metaTableContent;

    public JDBCResourceSQL(String dialect, String tableName, String metaTableKey, String metaTableTs, String metaTableContent) {
        this.format = JDBCSqlQueryFormatProvider.createJDBCSqlQueriesFormat(dialect);
        this.tableName = tableName;
        this.metaTableKey = metaTableKey;
        this.metaTableTs = metaTableTs;
        this.metaTableContent = metaTableContent;
    }

    public String getCheckTableExistsSql(String tableName) {
        String sql = new MessageFormat(this.format.getCheckTableExistsSql(), Locale.ROOT).format(new Object[]{tableName}, new StringBuffer(), new FieldPosition(0)).toString();
        return sql;
    }

    public String getCreateIfNeededSql(String tableName) {
        String sql = new MessageFormat(this.format.getCreateIfNeedSql(), Locale.ROOT).format(new Object[]{tableName, this.metaTableKey, this.metaTableTs, this.metaTableContent}, new StringBuffer(), new FieldPosition(0)).toString();
        return sql;
    }

    public String getCreateIndexSql(String indexName, String tableName, String indexCol) {
        String sql = new MessageFormat(this.format.getCreateIndexSql(), Locale.ROOT).format(new Object[]{indexName, tableName, indexCol}, new StringBuffer(), new FieldPosition(0)).toString();
        return sql;
    }

    public String getKeyEqualSqlString(boolean fetchContent, boolean fetchTimestamp) {
        String sql = new MessageFormat(this.format.getKeyEqualsSql(), Locale.ROOT).format(new Object[]{this.getSelectList(fetchContent, fetchTimestamp), this.tableName, this.metaTableKey}, new StringBuffer(), new FieldPosition(0)).toString();
        return sql;
    }

    public String getDeletePstatSql() {
        String sql = new MessageFormat(this.format.getDeletePstatSql(), Locale.ROOT).format(new Object[]{this.tableName, this.metaTableKey}, new StringBuffer(), new FieldPosition(0)).toString();
        return sql;
    }

    public String getAllResourceSqlString(boolean loadContent) {
        String sql = new MessageFormat(this.format.getAllResourceSql(), Locale.ROOT).format(new Object[]{this.getSelectList(loadContent, true), this.tableName, this.metaTableKey, this.metaTableTs, this.metaTableTs}, new StringBuffer(), new FieldPosition(0)).toString();
        return sql;
    }

    public String getReplaceSql() {
        String sql = new MessageFormat(this.format.getReplaceSql(), Locale.ROOT).format(new Object[]{this.tableName, this.metaTableTs, this.metaTableContent, this.metaTableKey}, new StringBuffer(), new FieldPosition(0)).toString();
        return sql;
    }

    public String getInsertSql() {
        String sql = new MessageFormat(this.format.getInsertSql(), Locale.ROOT).format(new Object[]{this.tableName, this.metaTableKey, this.metaTableTs, this.metaTableContent}, new StringBuffer(), new FieldPosition(0)).toString();
        return sql;
    }

    public String getReplaceSqlWithoutContent() {
        String sql = new MessageFormat(this.format.getReplaceSqlWithoutContent(), Locale.ROOT).format(new Object[]{this.tableName, this.metaTableTs, this.metaTableKey}, new StringBuffer(), new FieldPosition(0)).toString();
        return sql;
    }

    public String getInsertSqlWithoutContent() {
        String sql = new MessageFormat(this.format.getInsertSqlWithoutContent(), Locale.ROOT).format(new Object[]{this.tableName, this.metaTableKey, this.metaTableTs}, new StringBuffer(), new FieldPosition(0)).toString();
        return sql;
    }

    public String getUpdateContentAndTsSql() {
        String sql = new MessageFormat(this.format.getUpdateContentAndTsSql(), Locale.ROOT).format(new Object[]{this.tableName, this.metaTableTs, this.metaTableContent, this.metaTableKey, this.metaTableTs}, new StringBuffer(), new FieldPosition(0)).toString();
        return sql;
    }

    private String getSelectList(boolean fetchContent, boolean fetchTimestamp) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.metaTableKey);
        if (fetchTimestamp) {
            sb.append("," + this.metaTableTs);
        }
        if (fetchContent) {
            sb.append("," + this.metaTableContent);
        }
        return sb.toString();
    }
}

