/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.coordinator.coordinate;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.leader.LeaderSelector;
import org.apache.curator.framework.recipes.leader.LeaderSelectorListenerAdapter;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.common.util.ServerMode;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.job.execution.ExecutableManager;
import org.apache.kylin.metadata.realization.RealizationStatusEnum;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Sets;
import org.apache.kylin.stream.coordinator.StreamMetadataStore;
import org.apache.kylin.stream.coordinator.StreamMetadataStoreFactory;
import org.apache.kylin.stream.coordinator.StreamingCubeInfo;
import org.apache.kylin.stream.coordinator.StreamingUtils;
import org.apache.kylin.stream.coordinator.assign.Assigner;
import org.apache.kylin.stream.coordinator.assign.AssignmentUtil;
import org.apache.kylin.stream.coordinator.assign.AssignmentsCache;
import org.apache.kylin.stream.coordinator.assign.CubePartitionRoundRobinAssigner;
import org.apache.kylin.stream.coordinator.assign.DefaultAssigner;
import org.apache.kylin.stream.coordinator.client.CoordinatorClient;
import org.apache.kylin.stream.coordinator.coordinate.BuildJobSubmitter;
import org.apache.kylin.stream.coordinator.coordinate.ReceiverClusterManager;
import org.apache.kylin.stream.coordinator.doctor.ClusterDoctor;
import org.apache.kylin.stream.coordinator.exception.CoordinateException;
import org.apache.kylin.stream.coordinator.exception.NotLeadCoordinatorException;
import org.apache.kylin.stream.coordinator.exception.StoreException;
import org.apache.kylin.stream.core.client.HttpReceiverAdminClient;
import org.apache.kylin.stream.core.client.ReceiverAdminClient;
import org.apache.kylin.stream.core.model.AssignRequest;
import org.apache.kylin.stream.core.model.ConsumerStatsResponse;
import org.apache.kylin.stream.core.model.CubeAssignment;
import org.apache.kylin.stream.core.model.Node;
import org.apache.kylin.stream.core.model.PauseConsumersRequest;
import org.apache.kylin.stream.core.model.ReplicaSet;
import org.apache.kylin.stream.core.model.ResumeConsumerRequest;
import org.apache.kylin.stream.core.model.StartConsumersRequest;
import org.apache.kylin.stream.core.model.StopConsumersRequest;
import org.apache.kylin.stream.core.model.StreamingCubeConsumeState;
import org.apache.kylin.stream.core.model.UnAssignRequest;
import org.apache.kylin.stream.core.source.IStreamingSource;
import org.apache.kylin.stream.core.source.Partition;
import org.apache.kylin.stream.core.source.StreamingSourceFactory;
import org.apache.kylin.stream.core.source.StreamingTableSourceInfo;
import org.apache.kylin.stream.core.util.HDFSUtil;
import org.apache.kylin.stream.core.util.NamedThreadFactory;
import org.apache.kylin.stream.core.util.NodeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingCoordinator
implements CoordinatorClient {
    private static final Logger logger = LoggerFactory.getLogger(StreamingCoordinator.class);
    private static final int DEFAULT_PORT = 7070;
    private static volatile StreamingCoordinator instance = null;
    private StreamMetadataStore streamMetadataStore = StreamMetadataStoreFactory.getStreamMetaDataStore();
    private Assigner assigner;
    private ReceiverAdminClient receiverAdminClient;
    private CuratorFramework zkClient;
    private CoordinatorLeaderSelector selector;
    private ReceiverClusterManager clusterManager = new ReceiverClusterManager(this);
    private volatile boolean isLead = false;
    private ScheduledExecutorService streamingJobSubmitExecutor;
    private ScheduledExecutorService clusterStateCheckExecutor;
    private ClusterDoctor clusterDoctor;
    private BuildJobSubmitter buildJobSubmitter;

    private StreamingCoordinator() {
        this.receiverAdminClient = new HttpReceiverAdminClient();
        this.assigner = this.getAssigner();
        this.zkClient = StreamingUtils.getZookeeperClient();
        this.selector = new CoordinatorLeaderSelector();
        this.buildJobSubmitter = new BuildJobSubmitter(this);
        this.clusterDoctor = new ClusterDoctor();
        if (ServerMode.SERVER_MODE.canServeStreamingCoordinator()) {
            this.streamingJobSubmitExecutor = Executors.newScheduledThreadPool(1, new NamedThreadFactory("streaming_job_submitter"));
            this.clusterStateCheckExecutor = Executors.newScheduledThreadPool(1, new NamedThreadFactory("cluster_state_checker"));
            this.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StreamingCoordinator getInstance() {
        if (instance != null) return instance;
        Class<StreamingCoordinator> clazz = StreamingCoordinator.class;
        synchronized (StreamingCoordinator.class) {
            if (instance != null) return instance;
            instance = new StreamingCoordinator();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private void start() {
        this.selector.start();
        this.streamingJobSubmitExecutor.scheduleAtFixedRate(this.buildJobSubmitter, 0L, 2L, TimeUnit.MINUTES);
        this.clusterStateCheckExecutor.scheduleAtFixedRate(this.clusterDoctor, 5L, 10L, TimeUnit.MINUTES);
    }

    @Override
    public synchronized void assignCube(String cubeName) {
        this.checkLead();
        this.streamMetadataStore.addStreamingCube(cubeName);
        StreamingCubeInfo cube = this.getStreamCubeInfo(cubeName);
        CubeAssignment existAssignment = this.streamMetadataStore.getAssignmentsByCube(cube.getCubeName());
        if (existAssignment != null) {
            logger.warn("Cube {} is already assigned.", (Object)cube.getCubeName());
            return;
        }
        List<ReplicaSet> replicaSets = this.streamMetadataStore.getReplicaSets();
        if (replicaSets == null || replicaSets.isEmpty()) {
            throw new IllegalStateException("No replicaSet is configured in system");
        }
        CubeAssignment assignment = this.assigner.assign(cube, replicaSets, this.streamMetadataStore.getAllCubeAssignments());
        this.doAssignCube(cubeName, assignment);
    }

    @Override
    public void unAssignCube(String cubeName) {
        this.checkLead();
        CubeAssignment assignment = this.streamMetadataStore.getAssignmentsByCube(cubeName);
        if (assignment == null) {
            return;
        }
        ArrayList<Node> unAssignedFailReceivers = Lists.newArrayList();
        try {
            logger.info("Send unAssign cube:{} request to receivers", (Object)cubeName);
            for (Integer replicaSetID : assignment.getReplicaSetIDs()) {
                ReplicaSet rs = this.streamMetadataStore.getReplicaSet(replicaSetID);
                UnAssignRequest request = new UnAssignRequest();
                request.setCube(cubeName);
                for (Node receiver : rs.getNodes()) {
                    try {
                        this.unAssignToReceiver(receiver, request);
                    }
                    catch (IOException e) {
                        logger.error("Exception throws when unAssign receiver", e);
                        unAssignedFailReceivers.add(receiver);
                    }
                }
            }
            logger.debug("Remove temp hdfs files for {}", (Object)cubeName);
            this.removeCubeHDFSFiles(cubeName);
            logger.debug("Clear cube info from job check list");
            this.buildJobSubmitter.clearCheckList(cubeName);
            logger.debug("Commit unassign {} transaction.", (Object)cubeName);
            this.streamMetadataStore.removeStreamingCube(cubeName);
            AssignmentsCache.getInstance().clearCubeCache(cubeName);
        }
        catch (Exception e) {
            throw new CoordinateException(e);
        }
        if (!unAssignedFailReceivers.isEmpty()) {
            String msg = "unAssign fail for receivers:" + String.join((CharSequence)",", unAssignedFailReceivers.stream().map(Node::toString).collect(Collectors.toList()));
            throw new CoordinateException(msg);
        }
    }

    @Override
    public synchronized void reAssignCube(String cubeName, CubeAssignment assignments) {
        this.checkLead();
        CubeAssignment preAssignments = this.streamMetadataStore.getAssignmentsByCube(cubeName);
        if (preAssignments == null) {
            logger.info("no previous cube assign exists, use the new assignment:{}", (Object)assignments);
            this.doAssignCube(cubeName, assignments);
        } else {
            this.clusterManager.reassignCubeImpl(cubeName, preAssignments, assignments);
        }
    }

    @Override
    public void segmentRemoteStoreComplete(Node receiver, String cubeName, Pair<Long, Long> segment) {
        this.checkLead();
        logger.info("Segment remote store complete signal received for cube:{}, segment:{}, by {}.", cubeName, segment, receiver);
        this.buildJobSubmitter.addToCheckList(cubeName);
    }

    @Override
    public void pauseConsumers(String cubeName) {
        this.checkLead();
        CubeAssignment assignment = this.streamMetadataStore.getAssignmentsByCube(cubeName);
        PauseConsumersRequest request = new PauseConsumersRequest();
        request.setCube(cubeName);
        try {
            for (Integer rsID : assignment.getReplicaSetIDs()) {
                ReplicaSet rs = this.streamMetadataStore.getReplicaSet(rsID);
                this.clusterManager.pauseConsumersInReplicaSet(rs, request);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        logger.debug("Committing pauseConsumers {} transaction.", (Object)cubeName);
        this.streamMetadataStore.saveStreamingCubeConsumeState(cubeName, StreamingCubeConsumeState.PAUSED);
        logger.debug("Committed pauseConsumers {} transaction.", (Object)cubeName);
    }

    @Override
    public void resumeConsumers(String cubeName) {
        this.checkLead();
        CubeAssignment assignment = this.streamMetadataStore.getAssignmentsByCube(cubeName);
        ResumeConsumerRequest request = new ResumeConsumerRequest();
        request.setCube(cubeName);
        try {
            for (Integer rsID : assignment.getReplicaSetIDs()) {
                ReplicaSet rs = this.streamMetadataStore.getReplicaSet(rsID);
                this.clusterManager.resumeConsumersInReplicaSet(rs, request);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        logger.debug("Committing resumeConsumers {} transaction.", (Object)cubeName);
        this.streamMetadataStore.saveStreamingCubeConsumeState(cubeName, StreamingCubeConsumeState.RUNNING);
        logger.debug("Committed resumeConsumers {} transaction.", (Object)cubeName);
    }

    @Override
    public void replicaSetLeaderChange(int replicaSetID, Node newLeader) {
        this.checkLead();
        Map<String, List<Partition>> assignment = this.streamMetadataStore.getAssignmentsByReplicaSet(replicaSetID);
        if (assignment == null || assignment.isEmpty()) {
            return;
        }
        for (String cubeName : assignment.keySet()) {
            AssignmentsCache.getInstance().clearCubeCache(cubeName);
        }
    }

    private void doAssignCube(String cubeName, CubeAssignment assignment) {
        HashSet<ReplicaSet> successRS = Sets.newHashSet();
        try {
            for (Integer rsID : assignment.getReplicaSetIDs()) {
                ReplicaSet rs = this.streamMetadataStore.getReplicaSet(rsID);
                this.clusterManager.assignCubeToReplicaSet(rs, cubeName, assignment.getPartitionsByReplicaSetID(rsID), true, false);
                successRS.add(rs);
            }
            logger.debug("Committing assignment {} transaction.", (Object)cubeName);
            this.streamMetadataStore.saveNewCubeAssignment(assignment);
            logger.debug("Committed assignment {} transaction.", (Object)cubeName);
        }
        catch (Exception e) {
            logger.debug("Starting roll back success receivers.");
            for (ReplicaSet rs : successRS) {
                UnAssignRequest request = new UnAssignRequest();
                request.setCube(cubeName);
                this.unAssignFromReplicaSet(rs, request);
            }
            throw new CoordinateException(e);
        }
    }

    @Override
    public Map<Integer, Map<String, List<Partition>>> reBalanceRecommend() {
        this.checkLead();
        return this.reBalancePlan(this.getEnableStreamingCubes(), this.streamMetadataStore.getReplicaSets());
    }

    @Override
    public synchronized void reBalance(Map<Integer, Map<String, List<Partition>>> newAssignmentsPlan) {
        this.checkLead();
        List<CubeAssignment> currCubeAssignments = this.streamMetadataStore.getAllCubeAssignments();
        List<CubeAssignment> newCubeAssignments = AssignmentUtil.convertReplicaSetAssign2CubeAssign(newAssignmentsPlan);
        this.clusterManager.doReBalance(currCubeAssignments, newCubeAssignments);
    }

    Map<Integer, Map<String, List<Partition>>> reBalancePlan(List<StreamingCubeInfo> allCubes, List<ReplicaSet> allReplicaSets) {
        List<CubeAssignment> currCubeAssignments = this.streamMetadataStore.getAllCubeAssignments();
        return this.assigner.reBalancePlan(allReplicaSets, allCubes, currCubeAssignments);
    }

    @Override
    public synchronized void createReplicaSet(ReplicaSet rs) {
        List<ReplicaSet> allReplicaset = this.streamMetadataStore.getReplicaSets();
        for (Node node : rs.getNodes()) {
            for (ReplicaSet set : allReplicaset) {
                if (!set.containPhysicalNode(node)) continue;
                throw new CoordinateException(String.format(Locale.ROOT, "The receiver node %s is already exists in the set %s", node, set));
            }
        }
        int replicaSetID = this.streamMetadataStore.createReplicaSet(rs);
        try {
            for (Node receiver : rs.getNodes()) {
                logger.trace("Notify {} that it has been added to {} .", (Object)receiver, (Object)replicaSetID);
                this.addReceiverToReplicaSet(receiver, replicaSetID);
            }
        }
        catch (IOException iOException) {
            logger.warn("Create replica set failed.", iOException);
        }
    }

    @Override
    public synchronized void removeReplicaSet(int rsID) {
        ReplicaSet rs = this.streamMetadataStore.getReplicaSet(rsID);
        if (rs == null) {
            return;
        }
        if (rs.getNodes() != null && !rs.getNodes().isEmpty()) {
            throw new CoordinateException("Cannot remove rs, because there are nodes in it.");
        }
        Map<String, List<Partition>> assignment = this.streamMetadataStore.getAssignmentsByReplicaSet(rsID);
        if (assignment != null && !assignment.isEmpty()) {
            throw new CoordinateException("Cannot remove rs, because there are assignments.");
        }
        this.streamMetadataStore.removeReplicaSet(rsID);
    }

    @Override
    public synchronized void addNodeToReplicaSet(Integer replicaSetID, String nodeID) {
        ReplicaSet rs = this.streamMetadataStore.getReplicaSet(replicaSetID);
        Node receiver = Node.fromNormalizeString(nodeID);
        List<ReplicaSet> allReplicaSet = this.streamMetadataStore.getReplicaSets();
        for (ReplicaSet other : allReplicaSet) {
            if (other.getReplicaSetID() == replicaSetID.intValue() || !other.containPhysicalNode(receiver)) continue;
            logger.error("Error add Node {} to replicaSet {}, already exist in replicaSet {} ", nodeID, replicaSetID, other.getReplicaSetID());
            throw new IllegalStateException("Node exists in ReplicaSet!");
        }
        rs.addNode(receiver);
        this.streamMetadataStore.updateReplicaSet(rs);
        try {
            Map<String, List<Partition>> assignment = this.streamMetadataStore.getAssignmentsByReplicaSet(replicaSetID);
            if (assignment == null || assignment.isEmpty()) {
                return;
            }
            this.addReceiverToReplicaSet(receiver, replicaSetID);
            for (String cubeName : assignment.keySet()) {
                AssignmentsCache.getInstance().clearCubeCache(cubeName);
            }
        }
        catch (IOException e) {
            logger.warn("fail to add receiver to replicaSet ", e);
        }
    }

    @Override
    public synchronized void removeNodeFromReplicaSet(Integer replicaSetID, String nodeID) {
        ReplicaSet rs = this.streamMetadataStore.getReplicaSet(replicaSetID);
        Node receiver = Node.fromNormalizeString(nodeID);
        rs.removeNode(receiver);
        this.streamMetadataStore.updateReplicaSet(rs);
        try {
            Map<String, List<Partition>> assignment = this.streamMetadataStore.getAssignmentsByReplicaSet(replicaSetID);
            this.removeReceiverFromReplicaSet(receiver);
            if (assignment != null) {
                for (String cubeName : assignment.keySet()) {
                    AssignmentsCache.getInstance().clearCubeCache(cubeName);
                }
            }
        }
        catch (IOException e) {
            logger.warn("Remove node from replicaSet failed.", e);
        }
    }

    public void stopConsumers(String cubeName) {
        CubeAssignment assignment = this.streamMetadataStore.getAssignmentsByCube(cubeName);
        StopConsumersRequest request = new StopConsumersRequest();
        request.setCube(cubeName);
        try {
            for (Integer rsID : assignment.getReplicaSetIDs()) {
                ReplicaSet rs = this.streamMetadataStore.getReplicaSet(rsID);
                this.clusterManager.stopConsumersInReplicaSet(rs, request);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void unAssignFromReplicaSet(ReplicaSet rs, UnAssignRequest unAssignRequest) {
        for (Node receiver : rs.getNodes()) {
            try {
                this.unAssignToReceiver(receiver, unAssignRequest);
            }
            catch (IOException e) {
                logger.error("Error when roll back assignment", e);
            }
        }
    }

    protected void assignToReceiver(Node receiver, AssignRequest request) throws IOException {
        this.receiverAdminClient.assign(receiver, request);
    }

    private void unAssignToReceiver(Node receiver, UnAssignRequest request) throws IOException {
        this.receiverAdminClient.unAssign(receiver, request);
    }

    private void addReceiverToReplicaSet(Node receiver, int replicaSetID) throws IOException {
        this.receiverAdminClient.addToReplicaSet(receiver, replicaSetID);
    }

    private void removeReceiverFromReplicaSet(Node receiver) throws IOException {
        this.receiverAdminClient.removeFromReplicaSet(receiver);
    }

    protected void startConsumersForReceiver(Node receiver, StartConsumersRequest request) throws IOException {
        this.receiverAdminClient.startConsumers(receiver, request);
    }

    protected ConsumerStatsResponse stopConsumersForReceiver(Node receiver, StopConsumersRequest request) throws IOException {
        return this.receiverAdminClient.stopConsumers(receiver, request);
    }

    protected ConsumerStatsResponse pauseConsumersForReceiver(Node receiver, PauseConsumersRequest request) throws IOException {
        return this.receiverAdminClient.pauseConsumers(receiver, request);
    }

    protected ConsumerStatsResponse resumeConsumersForReceiver(Node receiver, ResumeConsumerRequest request) throws IOException {
        return this.receiverAdminClient.resumeConsumers(receiver, request);
    }

    protected void makeCubeImmutableForReceiver(Node receiver, String cubeName) throws IOException {
        this.receiverAdminClient.makeCubeImmutable(receiver, cubeName);
    }

    void notifyReceiverBuildSuccess(Node receiver, String cubeName, String segmentName) throws IOException {
        this.receiverAdminClient.segmentBuildComplete(receiver, cubeName, segmentName);
    }

    public ExecutableManager getExecutableManager() {
        return ExecutableManager.getInstance(this.getConfig());
    }

    public CubeManager getCubeManager() {
        return CubeManager.getInstance(this.getConfig());
    }

    public KylinConfig getConfig() {
        return KylinConfig.getInstanceFromEnv();
    }

    List<StreamingCubeInfo> getEnableStreamingCubes() {
        List<StreamingCubeInfo> allCubes = this.getStreamingCubes();
        ArrayList<StreamingCubeInfo> result = Lists.newArrayList();
        for (StreamingCubeInfo cube : allCubes) {
            CubeInstance cubeInstance = this.getCubeManager().getCube(cube.getCubeName());
            if (cubeInstance.getStatus() != RealizationStatusEnum.READY) continue;
            result.add(cube);
        }
        return result;
    }

    List<StreamingCubeInfo> getStreamingCubes() {
        List<String> cubes = this.streamMetadataStore.getCubes();
        ArrayList<StreamingCubeInfo> result = Lists.newArrayList();
        for (String cubeName : cubes) {
            StreamingCubeInfo cubeInfo = this.getStreamCubeInfo(cubeName);
            if (cubeInfo == null) continue;
            result.add(cubeInfo);
        }
        return result;
    }

    public StreamingCubeInfo getStreamCubeInfo(String cubeName) {
        CubeInstance cube = this.getCubeManager().getCube(cubeName);
        if (cube == null) {
            return null;
        }
        int numOfConsumerTasks = cube.getConfig().getStreamingCubeConsumerTasksNum();
        IStreamingSource streamingSource = StreamingSourceFactory.getStreamingSource(cube);
        StreamingTableSourceInfo tableSourceInfo = streamingSource.load(cubeName);
        return new StreamingCubeInfo(cubeName, tableSourceInfo, numOfConsumerTasks);
    }

    public void removeCubeHDFSFiles(String cubeName) {
        String segmentHDFSPath = HDFSUtil.getStreamingCubeFilePath(cubeName);
        try {
            FileSystem fs = HadoopUtil.getFileSystem(segmentHDFSPath);
            fs.delete(new Path(segmentHDFSPath), true);
        }
        catch (Exception e) {
            logger.error("Error when remove hdfs file, hdfs path:{}", (Object)segmentHDFSPath);
        }
    }

    private void checkLead() {
        if (!this.isLead) {
            Node coordinatorLeader;
            try {
                coordinatorLeader = this.streamMetadataStore.getCoordinatorNode();
            }
            catch (StoreException store) {
                throw new NotLeadCoordinatorException("Lead coordinator can not found.", store);
            }
            throw new NotLeadCoordinatorException("Current coordinator is not lead, please check host " + coordinatorLeader);
        }
    }

    private Assigner getAssigner() {
        Assigner oneAssigner;
        String assignerName = this.getConfig().getStreamingAssigner();
        logger.debug("Using assigner {}", (Object)assignerName);
        switch (assignerName) {
            case "DefaultAssigner": {
                oneAssigner = new DefaultAssigner();
                break;
            }
            case "CubePartitionRoundRobinAssigner": {
                oneAssigner = new CubePartitionRoundRobinAssigner();
                break;
            }
            default: {
                oneAssigner = new DefaultAssigner();
            }
        }
        return oneAssigner;
    }

    public ReceiverClusterManager getClusterManager() {
        return this.clusterManager;
    }

    public boolean isLead() {
        return this.isLead;
    }

    public StreamMetadataStore getStreamMetadataStore() {
        return this.streamMetadataStore;
    }

    public ReceiverAdminClient getReceiverAdminClient() {
        return this.receiverAdminClient;
    }

    private class CoordinatorLeaderSelector
    extends LeaderSelectorListenerAdapter
    implements Closeable {
        private LeaderSelector leaderSelector;

        public CoordinatorLeaderSelector() {
            String path = "/stream/coordinator";
            this.leaderSelector = new LeaderSelector(StreamingCoordinator.this.zkClient, path, this);
            this.leaderSelector.autoRequeue();
        }

        @Override
        public void close() {
            this.leaderSelector.close();
        }

        public void start() {
            this.leaderSelector.start();
        }

        @Override
        public void takeLeadership(CuratorFramework client) throws Exception {
            logger.info("Current node become the lead coordinator.");
            StreamingCoordinator.this.streamMetadataStore.setCoordinatorNode(NodeUtil.getCurrentNode(7070));
            StreamingCoordinator.this.isLead = true;
            StreamingCoordinator.this.buildJobSubmitter.restore();
            do {
                try {
                    Thread.sleep(300000L);
                }
                catch (InterruptedException exception) {
                    Thread.interrupted();
                    break;
                }
            } while (this.leaderSelector.hasLeadership());
            logger.info("Become the follower coordinator.");
            StreamingCoordinator.this.isLead = false;
        }
    }
}

