/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.kafka.job;

import java.io.IOException;
import java.util.Collections;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.CubeUpdate;
import org.apache.kylin.engine.mr.steps.CubingExecutableUtil;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableContext;
import org.apache.kylin.job.execution.ExecuteResult;
import org.apache.kylin.job.impl.threadpool.IJobRunner;
import org.apache.kylin.metadata.model.SegmentRange;
import org.apache.kylin.metadata.model.Segments;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeOffsetStep
extends AbstractExecutable {
    private static final Logger logger = LoggerFactory.getLogger(MergeOffsetStep.class);

    @Override
    protected ExecuteResult doWork(ExecutableContext context, IJobRunner jobRunner) throws ExecuteException {
        CubeManager cubeManager = CubeManager.getInstance(context.getConfig());
        CubeInstance cubeCopy = cubeManager.getCube(CubingExecutableUtil.getCubeName(this.getParams())).latestCopyForWrite();
        String segmentId = CubingExecutableUtil.getSegmentId(this.getParams());
        CubeSegment segCopy = cubeCopy.getSegmentById(segmentId);
        Preconditions.checkNotNull(segCopy, "Cube segment '" + segmentId + "' not found.");
        Segments<CubeSegment> mergingSegs = cubeCopy.getMergingSegments(segCopy);
        Preconditions.checkArgument(mergingSegs.size() > 0, "Merging segment not exist.");
        Collections.sort(mergingSegs);
        CubeSegment first = (CubeSegment)mergingSegs.get(0);
        CubeSegment last = (CubeSegment)mergingSegs.get(mergingSegs.size() - 1);
        segCopy.setSegRange(new SegmentRange(first.getSegRange().start, last.getSegRange().end));
        segCopy.setSourcePartitionOffsetStart(first.getSourcePartitionOffsetStart());
        segCopy.setSourcePartitionOffsetEnd(last.getSourcePartitionOffsetEnd());
        segCopy.setTSRange(new SegmentRange.TSRange(mergingSegs.getTSStart(), mergingSegs.getTSEnd()));
        CubeUpdate update = new CubeUpdate(cubeCopy);
        update.setToUpdateSegs(segCopy);
        try {
            cubeManager.updateCube(update);
            return ExecuteResult.createSucceed();
        }
        catch (IOException e) {
            logger.error("fail to update cube segment offset", e);
            return ExecuteResult.createError(e);
        }
    }
}

