/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.measure.map.bitmap;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.measure.MeasureAggregator;
import org.apache.kylin.measure.MeasureIngester;
import org.apache.kylin.measure.MeasureType;
import org.apache.kylin.measure.MeasureTypeFactory;
import org.apache.kylin.measure.map.bitmap.BitmapCounterMap;
import org.apache.kylin.measure.map.bitmap.BitmapMapAggregator;
import org.apache.kylin.measure.map.bitmap.BitmapMapDistinctCountAggFunc;
import org.apache.kylin.measure.map.bitmap.BitmapMapSerializer;
import org.apache.kylin.measure.map.bitmap.RoaringBitmapCounterMapFactory;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.datatype.DataTypeSerializer;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.TblColRef;

public class BitmapMapMeasureType
extends MeasureType<BitmapCounterMap> {
    public static final String FUNC_COUNT_DISTINCT = "COUNT_DISTINCT";
    public static final String DATATYPE_BITMAP_MAP = "bitmap_map";
    public DataType dataType;
    static final Map<String, Class<?>> UDAF_MAP = ImmutableMap.of("COUNT_DISTINCT", BitmapMapDistinctCountAggFunc.class);

    public BitmapMapMeasureType(String funcName, DataType dataType) {
        this.dataType = dataType;
    }

    @Override
    public void validate(FunctionDesc functionDesc) {
        Preconditions.checkArgument(FUNC_COUNT_DISTINCT.equals(functionDesc.getExpression()), "BitmapMapMeasureType only support function %s, got %s", FUNC_COUNT_DISTINCT, functionDesc.getExpression());
        Preconditions.checkArgument(functionDesc.getParameterCount() == 1, "BitmapMapMeasureType only support 1 parameter, got %d", functionDesc.getParameterCount());
        String returnType = functionDesc.getReturnDataType().getName();
        Preconditions.checkArgument(DATATYPE_BITMAP_MAP.equals(returnType), "BitmapMapMeasureType's return type must be %s, got %s", DATATYPE_BITMAP_MAP, returnType);
    }

    @Override
    public boolean isMemoryHungry() {
        return true;
    }

    @Override
    public MeasureIngester<BitmapCounterMap> newIngester() {
        final RoaringBitmapCounterMapFactory factory = RoaringBitmapCounterMapFactory.INSTANCE;
        return new MeasureIngester<BitmapCounterMap>(){
            BitmapCounterMap current;
            {
                this.current = factory.newBitmapMap();
            }

            @Override
            public BitmapCounterMap valueOf(String[] values, MeasureDesc measureDesc, Map<TblColRef, Dictionary<String>> dictionaryMap) {
                int id;
                Preconditions.checkArgument(values.length == 2, "expect 2 values, got %s", Arrays.toString(values));
                this.current.clear();
                if (values[0] == null) {
                    return this.current;
                }
                if (BitmapMapMeasureType.this.needDictionaryColumn(measureDesc.getFunction())) {
                    TblColRef literalCol = measureDesc.getFunction().getParameter().getColRefs().get(0);
                    Dictionary<String> dictionary = dictionaryMap.get(literalCol);
                    id = dictionary.getIdFromValue(values[0]);
                } else {
                    id = Integer.parseInt(values[0]);
                }
                Object key = factory.getMapKeySerializer().parseKey(values[1]);
                this.current.add(key, id);
                return this.current;
            }

            @Override
            public BitmapCounterMap reEncodeDictionary(BitmapCounterMap value, MeasureDesc measureDesc, Map<TblColRef, Dictionary<String>> oldDicts, Map<TblColRef, Dictionary<String>> newDicts) {
                return value;
            }

            @Override
            public void reset() {
                this.current = factory.newBitmapMap();
            }
        };
    }

    @Override
    public MeasureAggregator<BitmapCounterMap> newAggregator() {
        return new BitmapMapAggregator();
    }

    @Override
    public List<TblColRef> getColumnsNeedDictionary(FunctionDesc functionDesc) {
        if (this.needDictionaryColumn(functionDesc)) {
            return Collections.singletonList(functionDesc.getParameter().getColRefs().get(0));
        }
        return Collections.emptyList();
    }

    @Override
    public List<TblColRef> getColumnsNeedDictionaryForBuildingOnly(FunctionDesc functionDesc) {
        return this.getColumnsNeedDictionary(functionDesc);
    }

    private boolean needDictionaryColumn(FunctionDesc functionDesc) {
        DataType dataType = functionDesc.getParameter().getColRefs().get(0).getType();
        if (functionDesc.isMrDict()) {
            return false;
        }
        return !dataType.isIntegerFamily() || dataType.isBigInt();
    }

    @Override
    public boolean needRewrite() {
        return true;
    }

    @Override
    public Map<String, Class<?>> getRewriteCalciteAggrFunctions() {
        return UDAF_MAP;
    }

    public static class Factory
    extends MeasureTypeFactory<BitmapCounterMap> {
        @Override
        public MeasureType<BitmapCounterMap> createMeasureType(String funcName, DataType dataType) {
            return new BitmapMapMeasureType(funcName, dataType);
        }

        @Override
        public String getAggrFunctionName() {
            return BitmapMapMeasureType.FUNC_COUNT_DISTINCT;
        }

        @Override
        public String getAggrDataTypeName() {
            return BitmapMapMeasureType.DATATYPE_BITMAP_MAP;
        }

        @Override
        public Class<? extends DataTypeSerializer<BitmapCounterMap>> getAggrDataTypeSerializer() {
            return BitmapMapSerializer.class;
        }
    }
}

