/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import java.io.IOException;
import java.util.Collection;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.kylin.engine.mr.IMRInput;
import org.apache.kylin.engine.mr.MRUtil;
import org.apache.kylin.engine.mr.steps.BaseCuboidMapperBase;

public class HiveToBaseCuboidMapper<KEYIN>
extends BaseCuboidMapperBase<KEYIN, Object> {
    private IMRInput.IMRTableInputFormat flatTableInputFormat;

    @Override
    protected void doSetup(Mapper.Context context) throws IOException {
        super.doSetup(context);
        this.flatTableInputFormat = MRUtil.getBatchCubingInputSide(this.cubeSegment).getFlatTableInputFormat();
    }

    @Override
    public void doMap(KEYIN key, Object value, Mapper.Context context) throws IOException, InterruptedException {
        Collection<String[]> rowCollection = this.flatTableInputFormat.parseMapperInput(value);
        for (String[] row : rowCollection) {
            try {
                this.outputKV(row, context);
            }
            catch (Exception ex) {
                this.handleErrorRecord(row, ex);
            }
        }
    }
}

