/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.ContentWriter;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.WriteConflictException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileResourceStore
extends ResourceStore {
    private static final Logger logger = LoggerFactory.getLogger(FileResourceStore.class);
    File root;
    int failPutResourceCountDown = Integer.MAX_VALUE;
    int failVisitFolderCountDown = Integer.MAX_VALUE;

    public FileResourceStore(KylinConfig kylinConfig) {
        super(kylinConfig);
        this.root = new File(this.getPath(kylinConfig)).getAbsoluteFile();
        if (!this.root.exists()) {
            throw new IllegalArgumentException("File not exist by '" + kylinConfig.getMetadataUrl() + "': " + this.root.getAbsolutePath());
        }
    }

    protected String getPath(KylinConfig kylinConfig) {
        return kylinConfig.getMetadataUrl().getIdentifier();
    }

    @Override
    protected boolean existsImpl(String resPath) throws IOException {
        File f = this.file(resPath);
        return f.exists() && f.isFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void visitFolderImpl(String folderPath, boolean recursive, ResourceStore.VisitFilter filter, boolean loadContent, ResourceStore.Visitor visitor) throws IOException {
        if (--this.failVisitFolderCountDown == 0) {
            throw new IOException("for test");
        }
        File file = this.file(folderPath);
        if (!file.exists() || !file.isDirectory()) {
            return;
        }
        String prefix = this.fixWinPath(file);
        Collection files = FileUtils.listFiles((File)file, null, (boolean)recursive);
        for (File f : files) {
            String path = this.fixWinPath(f);
            if (!path.startsWith(prefix)) {
                throw new IllegalStateException("File path " + path + " is supposed to start with " + prefix);
            }
            String resPath = folderPath.equals("/") ? path.substring(prefix.length()) : folderPath + path.substring(prefix.length());
            if (!filter.matches(resPath, f.lastModified())) continue;
            try (RawResource raw = loadContent ? new RawResource(resPath, f.lastModified(), new FileInputStream(f)) : new RawResource(resPath, f.lastModified());){
                visitor.visit(raw);
            }
        }
    }

    private String fixWinPath(File file) {
        String path = file.getAbsolutePath();
        if (path.length() > 2 && path.charAt(1) == ':' && path.charAt(2) == '\\') {
            path = path.replace('\\', '/');
        }
        return path;
    }

    @Override
    protected RawResource getResourceImpl(String resPath) throws IOException {
        File f = this.file(resPath);
        if (f.exists() && f.isFile()) {
            if (f.length() == 0L) {
                logger.warn("Zero length file: {}. ", (Object)f.getAbsolutePath());
            }
            return new RawResource(resPath, f.lastModified(), new FileInputStream(f));
        }
        return null;
    }

    @Override
    protected long getResourceTimestampImpl(String resPath) throws IOException {
        File f = this.file(resPath);
        if (f.exists() && f.isFile()) {
            return f.lastModified();
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void putResourceImpl(String resPath, ContentWriter content, long ts) throws IOException {
        if (--this.failPutResourceCountDown == 0) {
            throw new IOException("for test");
        }
        File tmp = File.createTempFile("kylin-fileresource-", ".tmp");
        try {
            try (FileOutputStream out = new FileOutputStream(tmp);
                 DataOutputStream dout = new DataOutputStream(out);){
                content.write(dout);
                dout.flush();
            }
            File f = this.file(resPath);
            f.getParentFile().mkdirs();
            if (!tmp.renameTo(f)) {
                f.delete();
                for (int i = 0; f.exists() && i < 3; ++i) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    f.delete();
                }
                FileUtils.moveFile((File)tmp, (File)f);
            }
            f.setLastModified(ts);
        }
        finally {
            if (tmp.exists()) {
                FileUtils.forceDelete((File)tmp);
            }
        }
    }

    @Override
    protected long checkAndPutResourceImpl(String resPath, byte[] content, long oldTS, long newTS) throws IOException, WriteConflictException {
        File f = this.file(resPath);
        if (f.exists() && f.lastModified() != oldTS || !f.exists() && oldTS != 0L) {
            throw new WriteConflictException("Overwriting conflict " + resPath + ", expect old TS " + oldTS + ", but found " + f.lastModified());
        }
        this.putResourceImpl(resPath, ContentWriter.create(content), newTS);
        return f.lastModified();
    }

    @Override
    protected void updateTimestampImpl(String resPath, long timestamp) throws IOException {
        boolean success;
        File f = this.file(resPath);
        if (f.exists() && !(success = f.setLastModified(timestamp))) {
            throw new IOException("Update resource timestamp failed, resPath:" + resPath + ", timestamp: " + timestamp);
        }
    }

    @Override
    protected void deleteResourceImpl(String resPath) throws IOException {
        File f = this.file(resPath);
        try {
            if (f.exists()) {
                FileUtils.forceDelete((File)f);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    @Override
    protected void deleteResourceImpl(String resPath, long timestamp) throws IOException {
        block3: {
            File f = this.file(resPath);
            try {
                if (!f.exists()) break block3;
                long origLastModified = this.getResourceTimestampImpl(resPath);
                if (this.checkTimeStampBeforeDelete(origLastModified, timestamp)) {
                    FileUtils.forceDelete((File)f);
                    break block3;
                }
                throw new IOException("Resource " + resPath + " timestamp not match, [originLastModified: " + origLastModified + ", timestampToDelete: " + timestamp + "]");
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
    }

    @Override
    protected String getReadableResourcePathImpl(String resPath) {
        return this.file(resPath).toString();
    }

    private File file(String resPath) {
        if (resPath.equals("/")) {
            return this.root;
        }
        return new File(this.root, resPath);
    }

    public String toString() {
        return this.root.getAbsolutePath();
    }
}

