/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.type;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;

public enum SqlTypeFamily implements RelDataTypeFamily
{
    CHARACTER,
    BINARY,
    NUMERIC,
    DATE,
    TIME,
    TIMESTAMP,
    BOOLEAN,
    INTERVAL_YEAR_MONTH,
    INTERVAL_DAY_TIME,
    STRING,
    APPROXIMATE_NUMERIC,
    EXACT_NUMERIC,
    INTEGER,
    DATETIME,
    DATETIME_INTERVAL,
    MULTISET,
    ARRAY,
    MAP,
    NULL,
    ANY,
    CURSOR,
    COLUMN_LIST,
    GEO;

    private static final Map<Integer, SqlTypeFamily> JDBC_TYPE_TO_FAMILY;

    public static SqlTypeFamily getFamilyForJdbcType(int jdbcType) {
        return JDBC_TYPE_TO_FAMILY.get(jdbcType);
    }

    public Collection<SqlTypeName> getTypeNames() {
        switch (this) {
            case CHARACTER: {
                return SqlTypeName.CHAR_TYPES;
            }
            case BINARY: {
                return SqlTypeName.BINARY_TYPES;
            }
            case NUMERIC: {
                return SqlTypeName.NUMERIC_TYPES;
            }
            case DATE: {
                return ImmutableList.of(SqlTypeName.DATE);
            }
            case TIME: {
                return ImmutableList.of(SqlTypeName.TIME, SqlTypeName.TIME_WITH_LOCAL_TIME_ZONE);
            }
            case TIMESTAMP: {
                return ImmutableList.of(SqlTypeName.TIMESTAMP, SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE);
            }
            case BOOLEAN: {
                return SqlTypeName.BOOLEAN_TYPES;
            }
            case INTERVAL_YEAR_MONTH: {
                return SqlTypeName.YEAR_INTERVAL_TYPES;
            }
            case INTERVAL_DAY_TIME: {
                return SqlTypeName.DAY_INTERVAL_TYPES;
            }
            case STRING: {
                return SqlTypeName.STRING_TYPES;
            }
            case APPROXIMATE_NUMERIC: {
                return SqlTypeName.APPROX_TYPES;
            }
            case EXACT_NUMERIC: {
                return SqlTypeName.EXACT_TYPES;
            }
            case INTEGER: {
                return SqlTypeName.INT_TYPES;
            }
            case DATETIME: {
                return SqlTypeName.DATETIME_TYPES;
            }
            case DATETIME_INTERVAL: {
                return SqlTypeName.INTERVAL_TYPES;
            }
            case GEO: {
                return ImmutableList.of(SqlTypeName.GEOMETRY);
            }
            case MULTISET: {
                return ImmutableList.of(SqlTypeName.MULTISET);
            }
            case ARRAY: {
                return ImmutableList.of(SqlTypeName.ARRAY);
            }
            case MAP: {
                return ImmutableList.of(SqlTypeName.MAP);
            }
            case NULL: {
                return ImmutableList.of(SqlTypeName.NULL);
            }
            case ANY: {
                return SqlTypeName.ALL_TYPES;
            }
            case CURSOR: {
                return ImmutableList.of(SqlTypeName.CURSOR);
            }
            case COLUMN_LIST: {
                return ImmutableList.of(SqlTypeName.COLUMN_LIST);
            }
        }
        throw new IllegalArgumentException();
    }

    public boolean contains(RelDataType type) {
        return SqlTypeUtil.isOfSameTypeName(this.getTypeNames(), type);
    }

    static {
        JDBC_TYPE_TO_FAMILY = ImmutableMap.builder().put(-7, NUMERIC).put(-6, NUMERIC).put(5, NUMERIC).put(-5, NUMERIC).put(4, NUMERIC).put(2, NUMERIC).put(3, NUMERIC).put(6, NUMERIC).put(7, NUMERIC).put(8, NUMERIC).put(1, CHARACTER).put(12, CHARACTER).put(-1, CHARACTER).put(2005, CHARACTER).put(-2, BINARY).put(-3, BINARY).put(-4, BINARY).put(2004, BINARY).put(91, DATE).put(92, TIME).put(2013, TIME).put(93, TIMESTAMP).put(2014, TIMESTAMP).put(16, BOOLEAN).put(2012, CURSOR).put(2003, ARRAY).build();
    }
}

