/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions.factories;

import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetClassLoaderForClass;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class PersistenceEntityResolver
implements EntityResolver {
    protected Hashtable m_localResources = new Hashtable();
    protected static final String dtdFileName40 = "sessions_4_0.dtd";
    protected static final String doctTypeId40 = "-//Oracle Corp.//DTD TopLink for JAVA 4.0//EN";
    protected static final String dtdFileName45 = "sessions_4_5.dtd";
    protected static final String doctTypeId45 = "-//Oracle Corp.//DTD TopLink for JAVA 4.5//EN";
    protected static final String dtdFileName904 = "sessions_9_0_4.dtd";
    protected static final String doctTypeId904 = "-//Oracle Corp.//DTD TopLink Sessions 9.0.4//EN";

    public PersistenceEntityResolver() {
        this.populateLocalResources();
    }

    protected void populateLocalResources() {
        this.m_localResources.put(doctTypeId40, dtdFileName40);
        this.m_localResources.put(doctTypeId45, dtdFileName45);
        this.m_localResources.put(doctTypeId904, dtdFileName904);
    }

    protected String getDtdFileName(String docTypeId) {
        return (String)this.getLocalResources().get(docTypeId);
    }

    public Hashtable getLocalResources() {
        return this.m_localResources;
    }

    public void setLocalResources(Hashtable ht) {
        this.m_localResources = ht;
    }

    public void addLocalResource(String publicId, String localFileName) {
        this.m_localResources.put(publicId, localFileName);
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        Enumeration docTypeIds = this.m_localResources.keys();
        while (docTypeIds.hasMoreElements()) {
            String docTypeId = (String)docTypeIds.nextElement();
            if (publicId == null || !publicId.equals(docTypeId)) continue;
            InputStream localDtdStream = null;
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    localDtdStream = AccessController.doPrivileged(new PrivilegedGetClassLoaderForClass(this.getClass())).getResourceAsStream(this.getDtdFileName(docTypeId));
                }
                catch (PrivilegedActionException ex) {
                    throw (RuntimeException)ex.getCause();
                }
            } else {
                localDtdStream = PrivilegedAccessHelper.getClassLoaderForClass(this.getClass()).getResourceAsStream(this.getDtdFileName(docTypeId));
            }
            if (localDtdStream == null) continue;
            return new InputSource(localDtdStream);
        }
        return null;
    }
}

