/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiHBaseReplicationArguments;
import com.cloudera.api.swagger.model.ApiHdfsCloudReplicationArguments;
import com.cloudera.api.swagger.model.ApiHdfsReplicationArguments;
import com.cloudera.api.swagger.model.ApiHive3ReplicationArguments;
import com.cloudera.api.swagger.model.ApiHiveCloudReplicationArguments;
import com.cloudera.api.swagger.model.ApiHiveReplicationArguments;
import com.cloudera.api.swagger.model.ApiOzoneReplicationArguments;
import com.cloudera.api.swagger.model.ApiReplicationCommand;
import com.cloudera.api.swagger.model.ApiScheduleInterval;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="A replication job schedule. <p/> Replication jobs have service-specific arguments. This object has methods to retrieve arguments for all supported types of replication, but only one argument type is allowed to be set; the backend will check that the provided argument matches the service type where the replication is being scheduled. <p/> The replication job's arguments should match the underlying service. Refer to each property's documentation to find out which properties correspond to which services.")
public class ApiReplicationSchedule {
    @SerializedName(value="id")
    private BigDecimal id = null;
    @SerializedName(value="displayName")
    private String displayName = null;
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="startTime")
    private String startTime = null;
    @SerializedName(value="endTime")
    private String endTime = null;
    @SerializedName(value="interval")
    private BigDecimal interval = null;
    @SerializedName(value="intervalUnit")
    private ApiScheduleInterval intervalUnit = null;
    @SerializedName(value="nextRun")
    private String nextRun = null;
    @SerializedName(value="paused")
    private Boolean paused = null;
    @SerializedName(value="alertOnStart")
    private Boolean alertOnStart = null;
    @SerializedName(value="alertOnSuccess")
    private Boolean alertOnSuccess = null;
    @SerializedName(value="alertOnFail")
    private Boolean alertOnFail = null;
    @SerializedName(value="alertOnAbort")
    private Boolean alertOnAbort = null;
    @SerializedName(value="hdfsArguments")
    private ApiHdfsReplicationArguments hdfsArguments = null;
    @SerializedName(value="hiveArguments")
    private ApiHiveReplicationArguments hiveArguments = null;
    @SerializedName(value="hdfsCloudArguments")
    private ApiHdfsCloudReplicationArguments hdfsCloudArguments = null;
    @SerializedName(value="ozoneReplicationArguments")
    private ApiOzoneReplicationArguments ozoneReplicationArguments = null;
    @SerializedName(value="history")
    private List<ApiReplicationCommand> history = null;
    @SerializedName(value="active")
    private Boolean active = null;
    @SerializedName(value="hiveCloudArguments")
    private ApiHiveCloudReplicationArguments hiveCloudArguments = null;
    @SerializedName(value="hbaseArguments")
    private ApiHBaseReplicationArguments hbaseArguments = null;
    @SerializedName(value="hive3Arguments")
    private ApiHive3ReplicationArguments hive3Arguments = null;

    public ApiReplicationSchedule id(BigDecimal id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="The schedule id.")
    public BigDecimal getId() {
        return this.id;
    }

    public void setId(BigDecimal id) {
        this.id = id;
    }

    public ApiReplicationSchedule displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @ApiModelProperty(value="The schedule display name.")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public ApiReplicationSchedule description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="The schedule description.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ApiReplicationSchedule startTime(String startTime) {
        this.startTime = startTime;
        return this;
    }

    @ApiModelProperty(value="The time at which the scheduled activity is triggered for the first time.")
    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public ApiReplicationSchedule endTime(String endTime) {
        this.endTime = endTime;
        return this;
    }

    @ApiModelProperty(value="The time after which the scheduled activity will no longer be triggered.")
    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public ApiReplicationSchedule interval(BigDecimal interval) {
        this.interval = interval;
        return this;
    }

    @ApiModelProperty(value="The duration between consecutive triggers of a scheduled activity. Defaults to 0.")
    public BigDecimal getInterval() {
        return this.interval;
    }

    public void setInterval(BigDecimal interval) {
        this.interval = interval;
    }

    public ApiReplicationSchedule intervalUnit(ApiScheduleInterval intervalUnit) {
        this.intervalUnit = intervalUnit;
        return this;
    }

    @ApiModelProperty(value="The unit for the repeat interval.")
    public ApiScheduleInterval getIntervalUnit() {
        return this.intervalUnit;
    }

    public void setIntervalUnit(ApiScheduleInterval intervalUnit) {
        this.intervalUnit = intervalUnit;
    }

    public ApiReplicationSchedule nextRun(String nextRun) {
        this.nextRun = nextRun;
        return this;
    }

    @ApiModelProperty(value="Readonly. The time the scheduled command will run next.")
    public String getNextRun() {
        return this.nextRun;
    }

    public void setNextRun(String nextRun) {
        this.nextRun = nextRun;
    }

    public ApiReplicationSchedule paused(Boolean paused) {
        this.paused = paused;
        return this;
    }

    @ApiModelProperty(value="The paused state for the schedule. The scheduled activity will not be triggered as long as the scheduled is paused. Defaults to false.")
    public Boolean getPaused() {
        return this.paused;
    }

    public void setPaused(Boolean paused) {
        this.paused = paused;
    }

    public ApiReplicationSchedule alertOnStart(Boolean alertOnStart) {
        this.alertOnStart = alertOnStart;
        return this;
    }

    @ApiModelProperty(value="Whether to alert on start of the scheduled activity. Defaults to false.")
    public Boolean getAlertOnStart() {
        return this.alertOnStart;
    }

    public void setAlertOnStart(Boolean alertOnStart) {
        this.alertOnStart = alertOnStart;
    }

    public ApiReplicationSchedule alertOnSuccess(Boolean alertOnSuccess) {
        this.alertOnSuccess = alertOnSuccess;
        return this;
    }

    @ApiModelProperty(value="Whether to alert on successful completion of the scheduled activity. Defaults to false.")
    public Boolean getAlertOnSuccess() {
        return this.alertOnSuccess;
    }

    public void setAlertOnSuccess(Boolean alertOnSuccess) {
        this.alertOnSuccess = alertOnSuccess;
    }

    public ApiReplicationSchedule alertOnFail(Boolean alertOnFail) {
        this.alertOnFail = alertOnFail;
        return this;
    }

    @ApiModelProperty(value="Whether to alert on failure of the scheduled activity. Defaults to false.")
    public Boolean getAlertOnFail() {
        return this.alertOnFail;
    }

    public void setAlertOnFail(Boolean alertOnFail) {
        this.alertOnFail = alertOnFail;
    }

    public ApiReplicationSchedule alertOnAbort(Boolean alertOnAbort) {
        this.alertOnAbort = alertOnAbort;
        return this;
    }

    @ApiModelProperty(value="Whether to alert on abort of the scheduled activity. Defaults to false.")
    public Boolean getAlertOnAbort() {
        return this.alertOnAbort;
    }

    public void setAlertOnAbort(Boolean alertOnAbort) {
        this.alertOnAbort = alertOnAbort;
    }

    public ApiReplicationSchedule hdfsArguments(ApiHdfsReplicationArguments hdfsArguments) {
        this.hdfsArguments = hdfsArguments;
        return this;
    }

    @ApiModelProperty(value="Optional arguments for HDFS replication commands.")
    public ApiHdfsReplicationArguments getHdfsArguments() {
        return this.hdfsArguments;
    }

    public void setHdfsArguments(ApiHdfsReplicationArguments hdfsArguments) {
        this.hdfsArguments = hdfsArguments;
    }

    public ApiReplicationSchedule hiveArguments(ApiHiveReplicationArguments hiveArguments) {
        this.hiveArguments = hiveArguments;
        return this;
    }

    @ApiModelProperty(value="Optional arguments for Hive replication commands.")
    public ApiHiveReplicationArguments getHiveArguments() {
        return this.hiveArguments;
    }

    public void setHiveArguments(ApiHiveReplicationArguments hiveArguments) {
        this.hiveArguments = hiveArguments;
    }

    public ApiReplicationSchedule hdfsCloudArguments(ApiHdfsCloudReplicationArguments hdfsCloudArguments) {
        this.hdfsCloudArguments = hdfsCloudArguments;
        return this;
    }

    @ApiModelProperty(value="Optional arguments for HDFS cloud replication commands.")
    public ApiHdfsCloudReplicationArguments getHdfsCloudArguments() {
        return this.hdfsCloudArguments;
    }

    public void setHdfsCloudArguments(ApiHdfsCloudReplicationArguments hdfsCloudArguments) {
        this.hdfsCloudArguments = hdfsCloudArguments;
    }

    public ApiReplicationSchedule ozoneReplicationArguments(ApiOzoneReplicationArguments ozoneReplicationArguments) {
        this.ozoneReplicationArguments = ozoneReplicationArguments;
        return this;
    }

    @ApiModelProperty(value="Optional arguments for HDFS cloud replication commands.")
    public ApiOzoneReplicationArguments getOzoneReplicationArguments() {
        return this.ozoneReplicationArguments;
    }

    public void setOzoneReplicationArguments(ApiOzoneReplicationArguments ozoneReplicationArguments) {
        this.ozoneReplicationArguments = ozoneReplicationArguments;
    }

    public ApiReplicationSchedule history(List<ApiReplicationCommand> history) {
        this.history = history;
        return this;
    }

    public ApiReplicationSchedule addHistoryItem(ApiReplicationCommand historyItem) {
        if (this.history == null) {
            this.history = new ArrayList<ApiReplicationCommand>();
        }
        this.history.add(historyItem);
        return this;
    }

    @ApiModelProperty(value="List of active and/or finished commands for this schedule.")
    public List<ApiReplicationCommand> getHistory() {
        return this.history;
    }

    public void setHistory(List<ApiReplicationCommand> history) {
        this.history = history;
    }

    public ApiReplicationSchedule active(Boolean active) {
        this.active = active;
        return this;
    }

    @ApiModelProperty(value="Read-only field that is true if this schedule is currently active, false if not. Available since API v11.")
    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public ApiReplicationSchedule hiveCloudArguments(ApiHiveCloudReplicationArguments hiveCloudArguments) {
        this.hiveCloudArguments = hiveCloudArguments;
        return this;
    }

    @ApiModelProperty(value="Optional arguments for Hive cloud replication commands.")
    public ApiHiveCloudReplicationArguments getHiveCloudArguments() {
        return this.hiveCloudArguments;
    }

    public void setHiveCloudArguments(ApiHiveCloudReplicationArguments hiveCloudArguments) {
        this.hiveCloudArguments = hiveCloudArguments;
    }

    public ApiReplicationSchedule hbaseArguments(ApiHBaseReplicationArguments hbaseArguments) {
        this.hbaseArguments = hbaseArguments;
        return this;
    }

    @ApiModelProperty(value="Optional arguments for HBase replication commands.")
    public ApiHBaseReplicationArguments getHbaseArguments() {
        return this.hbaseArguments;
    }

    public void setHbaseArguments(ApiHBaseReplicationArguments hbaseArguments) {
        this.hbaseArguments = hbaseArguments;
    }

    public ApiReplicationSchedule hive3Arguments(ApiHive3ReplicationArguments hive3Arguments) {
        this.hive3Arguments = hive3Arguments;
        return this;
    }

    @ApiModelProperty(value="arguments for Hive3 schedules")
    public ApiHive3ReplicationArguments getHive3Arguments() {
        return this.hive3Arguments;
    }

    public void setHive3Arguments(ApiHive3ReplicationArguments hive3Arguments) {
        this.hive3Arguments = hive3Arguments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiReplicationSchedule apiReplicationSchedule = (ApiReplicationSchedule)o;
        return Objects.equals(this.id, apiReplicationSchedule.id) && Objects.equals(this.displayName, apiReplicationSchedule.displayName) && Objects.equals(this.description, apiReplicationSchedule.description) && Objects.equals(this.startTime, apiReplicationSchedule.startTime) && Objects.equals(this.endTime, apiReplicationSchedule.endTime) && Objects.equals(this.interval, apiReplicationSchedule.interval) && Objects.equals((Object)this.intervalUnit, (Object)apiReplicationSchedule.intervalUnit) && Objects.equals(this.nextRun, apiReplicationSchedule.nextRun) && Objects.equals(this.paused, apiReplicationSchedule.paused) && Objects.equals(this.alertOnStart, apiReplicationSchedule.alertOnStart) && Objects.equals(this.alertOnSuccess, apiReplicationSchedule.alertOnSuccess) && Objects.equals(this.alertOnFail, apiReplicationSchedule.alertOnFail) && Objects.equals(this.alertOnAbort, apiReplicationSchedule.alertOnAbort) && Objects.equals(this.hdfsArguments, apiReplicationSchedule.hdfsArguments) && Objects.equals(this.hiveArguments, apiReplicationSchedule.hiveArguments) && Objects.equals(this.hdfsCloudArguments, apiReplicationSchedule.hdfsCloudArguments) && Objects.equals(this.ozoneReplicationArguments, apiReplicationSchedule.ozoneReplicationArguments) && Objects.equals(this.history, apiReplicationSchedule.history) && Objects.equals(this.active, apiReplicationSchedule.active) && Objects.equals(this.hiveCloudArguments, apiReplicationSchedule.hiveCloudArguments) && Objects.equals(this.hbaseArguments, apiReplicationSchedule.hbaseArguments) && Objects.equals(this.hive3Arguments, apiReplicationSchedule.hive3Arguments);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.displayName, this.description, this.startTime, this.endTime, this.interval, this.intervalUnit, this.nextRun, this.paused, this.alertOnStart, this.alertOnSuccess, this.alertOnFail, this.alertOnAbort, this.hdfsArguments, this.hiveArguments, this.hdfsCloudArguments, this.ozoneReplicationArguments, this.history, this.active, this.hiveCloudArguments, this.hbaseArguments, this.hive3Arguments});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiReplicationSchedule {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("    endTime: ").append(this.toIndentedString(this.endTime)).append("\n");
        sb.append("    interval: ").append(this.toIndentedString(this.interval)).append("\n");
        sb.append("    intervalUnit: ").append(this.toIndentedString((Object)this.intervalUnit)).append("\n");
        sb.append("    nextRun: ").append(this.toIndentedString(this.nextRun)).append("\n");
        sb.append("    paused: ").append(this.toIndentedString(this.paused)).append("\n");
        sb.append("    alertOnStart: ").append(this.toIndentedString(this.alertOnStart)).append("\n");
        sb.append("    alertOnSuccess: ").append(this.toIndentedString(this.alertOnSuccess)).append("\n");
        sb.append("    alertOnFail: ").append(this.toIndentedString(this.alertOnFail)).append("\n");
        sb.append("    alertOnAbort: ").append(this.toIndentedString(this.alertOnAbort)).append("\n");
        sb.append("    hdfsArguments: ").append(this.toIndentedString(this.hdfsArguments)).append("\n");
        sb.append("    hiveArguments: ").append(this.toIndentedString(this.hiveArguments)).append("\n");
        sb.append("    hdfsCloudArguments: ").append(this.toIndentedString(this.hdfsCloudArguments)).append("\n");
        sb.append("    ozoneReplicationArguments: ").append(this.toIndentedString(this.ozoneReplicationArguments)).append("\n");
        sb.append("    history: ").append(this.toIndentedString(this.history)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    hiveCloudArguments: ").append(this.toIndentedString(this.hiveCloudArguments)).append("\n");
        sb.append("    hbaseArguments: ").append(this.toIndentedString(this.hbaseArguments)).append("\n");
        sb.append("    hive3Arguments: ").append(this.toIndentedString(this.hive3Arguments)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

