/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiHealthCheck;
import com.cloudera.api.swagger.model.ApiHealthSummary;
import com.cloudera.api.swagger.model.ApiRoleRef;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Provides information about an HDFS nameservice. <p> Nameservices can be either a stand-alone NameNode, a NameNode paired with a SecondaryNameNode, or a high-availability pair formed by an active and a stand-by NameNode. <p> The following fields are only available in the object's full view: <ul> <li>healthSummary</li> <li>healthChecks</li> </ul>")
public class ApiNameservice {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="active")
    private ApiRoleRef active = null;
    @SerializedName(value="activeFailoverController")
    private ApiRoleRef activeFailoverController = null;
    @SerializedName(value="standBy")
    private ApiRoleRef standBy = null;
    @SerializedName(value="standByFailoverController")
    private ApiRoleRef standByFailoverController = null;
    @SerializedName(value="secondary")
    private ApiRoleRef secondary = null;
    @SerializedName(value="mountPoints")
    private List<String> mountPoints = null;
    @SerializedName(value="healthSummary")
    private ApiHealthSummary healthSummary = null;
    @SerializedName(value="healthChecks")
    private List<ApiHealthCheck> healthChecks = null;

    public ApiNameservice name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="Name of the nameservice.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ApiNameservice active(ApiRoleRef active) {
        this.active = active;
        return this;
    }

    @ApiModelProperty(value="Reference to the active NameNode.")
    public ApiRoleRef getActive() {
        return this.active;
    }

    public void setActive(ApiRoleRef active) {
        this.active = active;
    }

    public ApiNameservice activeFailoverController(ApiRoleRef activeFailoverController) {
        this.activeFailoverController = activeFailoverController;
        return this;
    }

    @ApiModelProperty(value="Reference to the active NameNode's failover controller, if configured.")
    public ApiRoleRef getActiveFailoverController() {
        return this.activeFailoverController;
    }

    public void setActiveFailoverController(ApiRoleRef activeFailoverController) {
        this.activeFailoverController = activeFailoverController;
    }

    public ApiNameservice standBy(ApiRoleRef standBy) {
        this.standBy = standBy;
        return this;
    }

    @ApiModelProperty(value="Reference to the stand-by NameNode.")
    public ApiRoleRef getStandBy() {
        return this.standBy;
    }

    public void setStandBy(ApiRoleRef standBy) {
        this.standBy = standBy;
    }

    public ApiNameservice standByFailoverController(ApiRoleRef standByFailoverController) {
        this.standByFailoverController = standByFailoverController;
        return this;
    }

    @ApiModelProperty(value="Reference to the stand-by NameNode's failover controller, if configured.")
    public ApiRoleRef getStandByFailoverController() {
        return this.standByFailoverController;
    }

    public void setStandByFailoverController(ApiRoleRef standByFailoverController) {
        this.standByFailoverController = standByFailoverController;
    }

    public ApiNameservice secondary(ApiRoleRef secondary) {
        this.secondary = secondary;
        return this;
    }

    @ApiModelProperty(value="Reference to the SecondaryNameNode.")
    public ApiRoleRef getSecondary() {
        return this.secondary;
    }

    public void setSecondary(ApiRoleRef secondary) {
        this.secondary = secondary;
    }

    public ApiNameservice mountPoints(List<String> mountPoints) {
        this.mountPoints = mountPoints;
        return this;
    }

    public ApiNameservice addMountPointsItem(String mountPointsItem) {
        if (this.mountPoints == null) {
            this.mountPoints = new ArrayList<String>();
        }
        this.mountPoints.add(mountPointsItem);
        return this;
    }

    @ApiModelProperty(value="Mount points assigned to this nameservice in a federation.")
    public List<String> getMountPoints() {
        return this.mountPoints;
    }

    public void setMountPoints(List<String> mountPoints) {
        this.mountPoints = mountPoints;
    }

    public ApiNameservice healthSummary(ApiHealthSummary healthSummary) {
        this.healthSummary = healthSummary;
        return this;
    }

    @ApiModelProperty(value="Requires \"full\" view. The high-level health status of this nameservice.")
    public ApiHealthSummary getHealthSummary() {
        return this.healthSummary;
    }

    public void setHealthSummary(ApiHealthSummary healthSummary) {
        this.healthSummary = healthSummary;
    }

    public ApiNameservice healthChecks(List<ApiHealthCheck> healthChecks) {
        this.healthChecks = healthChecks;
        return this;
    }

    public ApiNameservice addHealthChecksItem(ApiHealthCheck healthChecksItem) {
        if (this.healthChecks == null) {
            this.healthChecks = new ArrayList<ApiHealthCheck>();
        }
        this.healthChecks.add(healthChecksItem);
        return this;
    }

    @ApiModelProperty(value="Requires \"full\" view. List of health checks performed on the nameservice.")
    public List<ApiHealthCheck> getHealthChecks() {
        return this.healthChecks;
    }

    public void setHealthChecks(List<ApiHealthCheck> healthChecks) {
        this.healthChecks = healthChecks;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiNameservice apiNameservice = (ApiNameservice)o;
        return Objects.equals(this.name, apiNameservice.name) && Objects.equals(this.active, apiNameservice.active) && Objects.equals(this.activeFailoverController, apiNameservice.activeFailoverController) && Objects.equals(this.standBy, apiNameservice.standBy) && Objects.equals(this.standByFailoverController, apiNameservice.standByFailoverController) && Objects.equals(this.secondary, apiNameservice.secondary) && Objects.equals(this.mountPoints, apiNameservice.mountPoints) && Objects.equals((Object)this.healthSummary, (Object)apiNameservice.healthSummary) && Objects.equals(this.healthChecks, apiNameservice.healthChecks);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.active, this.activeFailoverController, this.standBy, this.standByFailoverController, this.secondary, this.mountPoints, this.healthSummary, this.healthChecks});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiNameservice {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    activeFailoverController: ").append(this.toIndentedString(this.activeFailoverController)).append("\n");
        sb.append("    standBy: ").append(this.toIndentedString(this.standBy)).append("\n");
        sb.append("    standByFailoverController: ").append(this.toIndentedString(this.standByFailoverController)).append("\n");
        sb.append("    secondary: ").append(this.toIndentedString(this.secondary)).append("\n");
        sb.append("    mountPoints: ").append(this.toIndentedString(this.mountPoints)).append("\n");
        sb.append("    healthSummary: ").append(this.toIndentedString((Object)this.healthSummary)).append("\n");
        sb.append("    healthChecks: ").append(this.toIndentedString(this.healthChecks)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

