/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.server.request;

import org.apache.kerby.asn1.EnumType;
import org.apache.kerby.asn1.type.Asn1Encodeable;
import org.apache.kerby.kerberos.kerb.KrbErrorCode;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.common.EncryptionUtil;
import org.apache.kerby.kerberos.kerb.crypto.EncryptionHandler;
import org.apache.kerby.kerberos.kerb.server.KdcConfig;
import org.apache.kerby.kerberos.kerb.server.KdcContext;
import org.apache.kerby.kerberos.kerb.server.request.KdcRequest;
import org.apache.kerby.kerberos.kerb.type.KerberosTime;
import org.apache.kerby.kerberos.kerb.type.ad.AuthorizationData;
import org.apache.kerby.kerberos.kerb.type.base.EncryptedData;
import org.apache.kerby.kerberos.kerb.type.base.EncryptionKey;
import org.apache.kerby.kerberos.kerb.type.base.EncryptionType;
import org.apache.kerby.kerberos.kerb.type.base.HostAddresses;
import org.apache.kerby.kerberos.kerb.type.base.KeyUsage;
import org.apache.kerby.kerberos.kerb.type.base.NameType;
import org.apache.kerby.kerberos.kerb.type.base.PrincipalName;
import org.apache.kerby.kerberos.kerb.type.base.TransitedEncoding;
import org.apache.kerby.kerberos.kerb.type.base.TransitedEncodingType;
import org.apache.kerby.kerberos.kerb.type.kdc.KdcClientRequest;
import org.apache.kerby.kerberos.kerb.type.kdc.KdcOption;
import org.apache.kerby.kerberos.kerb.type.kdc.KdcOptions;
import org.apache.kerby.kerberos.kerb.type.kdc.KdcReq;
import org.apache.kerby.kerberos.kerb.type.ticket.EncTicketPart;
import org.apache.kerby.kerberos.kerb.type.ticket.Ticket;
import org.apache.kerby.kerberos.kerb.type.ticket.TicketFlag;
import org.apache.kerby.kerberos.kerb.type.ticket.TicketFlags;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TicketIssuer {
    private static final Logger LOG = LoggerFactory.getLogger(TicketIssuer.class);
    private final KdcRequest kdcRequest;

    public TicketIssuer(KdcRequest kdcRequest) {
        this.kdcRequest = kdcRequest;
    }

    protected KdcRequest getKdcRequest() {
        return this.kdcRequest;
    }

    public Ticket issueTicket() throws KrbException {
        KdcReq request = this.kdcRequest.getKdcReq();
        Ticket issuedTicket = new Ticket();
        PrincipalName serverPrincipal = this.getServerPrincipal();
        issuedTicket.setSname(serverPrincipal);
        String serverRealm = request.getReqBody().getRealm();
        issuedTicket.setRealm(serverRealm);
        EncTicketPart encTicketPart = this.makeEncTicketPart();
        EncryptionKey encryptionKey = this.getTicketEncryptionKey();
        EncryptedData encryptedData = EncryptionUtil.seal((Asn1Encodeable)encTicketPart, (EncryptionKey)encryptionKey, (KeyUsage)KeyUsage.KDC_REP_TICKET);
        issuedTicket.setEncryptedEncPart(encryptedData);
        issuedTicket.setEncPart(encTicketPart);
        return issuedTicket;
    }

    public EncTicketPart makeEncTicketPart() throws KrbException {
        AuthorizationData authData;
        HostAddresses hostAddresses;
        KerberosTime krbEndTime;
        KdcReq request = this.kdcRequest.getKdcReq();
        EncTicketPart encTicketPart = new EncTicketPart();
        KdcConfig config = this.kdcRequest.getKdcContext().getConfig();
        TicketFlags ticketFlags = new TicketFlags();
        encTicketPart.setFlags(ticketFlags);
        ticketFlags.setFlag((EnumType)TicketFlag.INITIAL);
        if (this.kdcRequest.isPreAuthenticated()) {
            ticketFlags.setFlag((EnumType)TicketFlag.PRE_AUTH);
        }
        if (request.getReqBody().getKdcOptions().isFlagSet((EnumType)KdcOption.FORWARDABLE)) {
            if (!config.isForwardableAllowed()) {
                LOG.warn("Forward is not allowed.");
                throw new KrbException(KrbErrorCode.KDC_ERR_POLICY);
            }
            ticketFlags.setFlag((EnumType)TicketFlag.FORWARDABLE);
        }
        if (request.getReqBody().getKdcOptions().isFlagSet((EnumType)KdcOption.PROXIABLE)) {
            if (!config.isProxiableAllowed()) {
                LOG.warn("Proxy is not allowed.");
                throw new KrbException(KrbErrorCode.KDC_ERR_POLICY);
            }
            ticketFlags.setFlag((EnumType)TicketFlag.PROXIABLE);
        }
        if (request.getReqBody().getKdcOptions().isFlagSet((EnumType)KdcOption.ALLOW_POSTDATE)) {
            if (!config.isPostdatedAllowed()) {
                LOG.warn("Post date is not allowed.");
                throw new KrbException(KrbErrorCode.KDC_ERR_POLICY);
            }
            ticketFlags.setFlag((EnumType)TicketFlag.MAY_POSTDATE);
        }
        EncryptionKey sessionKey = EncryptionHandler.random2Key((EncryptionType)this.kdcRequest.getEncryptionType());
        encTicketPart.setKey(sessionKey);
        encTicketPart.setCname(this.getclientPrincipal());
        encTicketPart.setCrealm(request.getReqBody().getRealm());
        TransitedEncoding transEnc = this.getTransitedEncoding();
        encTicketPart.setTransited(transEnc);
        KdcOptions kdcOptions = request.getReqBody().getKdcOptions();
        KerberosTime now = KerberosTime.now();
        encTicketPart.setAuthTime(now);
        KerberosTime krbStartTime = request.getReqBody().getFrom();
        if (krbStartTime == null || krbStartTime.lessThan(now) || krbStartTime.isInClockSkew(config.getAllowableClockSkew())) {
            krbStartTime = now;
        }
        if (krbStartTime.greaterThan(now) && !krbStartTime.isInClockSkew(config.getAllowableClockSkew()) && !kdcOptions.isFlagSet((EnumType)KdcOption.POSTDATED)) {
            throw new KrbException(KrbErrorCode.KDC_ERR_CANNOT_POSTDATE);
        }
        if (kdcOptions.isFlagSet((EnumType)KdcOption.POSTDATED)) {
            if (!config.isPostdatedAllowed()) {
                throw new KrbException(KrbErrorCode.KDC_ERR_POLICY);
            }
            ticketFlags.setFlag((EnumType)TicketFlag.POSTDATED);
            encTicketPart.setStartTime(krbStartTime);
        }
        if ((krbEndTime = request.getReqBody().getTill()) == null || krbEndTime.getTime() == 0L) {
            krbEndTime = krbStartTime.extend(config.getMaximumTicketLifetime() * 1000L);
        } else if (krbStartTime.greaterThan(krbEndTime)) {
            throw new KrbException(KrbErrorCode.KDC_ERR_NEVER_VALID);
        }
        encTicketPart.setEndTime(krbEndTime);
        long ticketLifeTime = Math.abs(krbEndTime.diff(krbStartTime));
        if (ticketLifeTime < config.getMinimumTicketLifetime()) {
            throw new KrbException(KrbErrorCode.KDC_ERR_NEVER_VALID);
        }
        KerberosTime krbRtime = request.getReqBody().getRtime();
        if (kdcOptions.isFlagSet((EnumType)KdcOption.RENEWABLE_OK)) {
            kdcOptions.setFlag((EnumType)KdcOption.RENEWABLE);
        }
        if (kdcOptions.isFlagSet((EnumType)KdcOption.RENEWABLE)) {
            if (!config.isRenewableAllowed()) {
                throw new KrbException(KrbErrorCode.KDC_ERR_POLICY);
            }
            ticketFlags.setFlag((EnumType)TicketFlag.RENEWABLE);
            if (krbRtime == null || krbRtime.getTime() == 0L) {
                krbRtime = krbEndTime;
            }
            KerberosTime allowedMaximumRenewableTime = krbStartTime;
            if (krbRtime.greaterThan(allowedMaximumRenewableTime = allowedMaximumRenewableTime.extend(config.getMaximumRenewableLifetime() * 1000L))) {
                krbRtime = allowedMaximumRenewableTime;
            }
            encTicketPart.setRenewtill(krbRtime);
        }
        if ((hostAddresses = request.getReqBody().getAddresses()) == null || hostAddresses.isEmpty()) {
            if (!config.isEmptyAddressesAllowed()) {
                throw new KrbException(KrbErrorCode.KDC_ERR_POLICY);
            }
        } else {
            encTicketPart.setClientAddresses(hostAddresses);
        }
        if ((authData = this.makeAuthorizationData(this.kdcRequest, encTicketPart)) != null) {
            encTicketPart.setAuthorizationData(authData);
        }
        return encTicketPart;
    }

    protected AuthorizationData makeAuthorizationData(KdcRequest kdcRequest, EncTicketPart encTicketPart) throws KrbException {
        KdcClientRequest clientRequest = new KdcClientRequest();
        clientRequest.setAnonymous(kdcRequest.isAnonymous());
        clientRequest.setClientAddress(kdcRequest.getClientAddress());
        clientRequest.setClientKey(kdcRequest.getClientKey());
        clientRequest.setClientPrincipal(kdcRequest.getClientPrincipal());
        clientRequest.setEncryptionType(kdcRequest.getEncryptionType());
        clientRequest.setPkinit(kdcRequest.isPkinit());
        clientRequest.setPreAuthenticated(kdcRequest.isPreAuthenticated());
        clientRequest.setToken(kdcRequest.getToken());
        clientRequest.setToken(kdcRequest.isToken());
        return this.getKdcContext().getIdentityService().getIdentityAuthorizationData(clientRequest, encTicketPart);
    }

    protected KdcContext getKdcContext() {
        return this.kdcRequest.getKdcContext();
    }

    protected KdcReq getKdcReq() {
        return this.kdcRequest.getKdcReq();
    }

    protected PrincipalName getclientPrincipal() {
        if (this.kdcRequest.isToken()) {
            return new PrincipalName(this.kdcRequest.getToken().getSubject());
        }
        PrincipalName principalName = this.getKdcReq().getReqBody().getCname();
        if (this.getKdcRequest().isAnonymous()) {
            principalName.setNameType(NameType.NT_WELLKNOWN);
        }
        return principalName;
    }

    protected PrincipalName getServerPrincipal() {
        return this.getKdcReq().getReqBody().getSname();
    }

    protected EncryptionType getTicketEncryptionType() throws KrbException {
        EncryptionType encryptionType = this.kdcRequest.getEncryptionType();
        return encryptionType;
    }

    protected EncryptionKey getTicketEncryptionKey() throws KrbException {
        EncryptionType encryptionType = this.getTicketEncryptionType();
        EncryptionKey serverKey = (EncryptionKey)this.kdcRequest.getServerEntry().getKeys().get(encryptionType);
        return serverKey;
    }

    protected TransitedEncoding getTransitedEncoding() {
        TransitedEncoding transEnc = new TransitedEncoding();
        transEnc.setTrType(TransitedEncodingType.DOMAIN_X500_COMPRESS);
        byte[] empty = new byte[]{};
        transEnc.setContents(empty);
        return transEnc;
    }
}

