/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiTenantUtilizationList;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Objects;

@ApiModel(description="Utilization report information of a Cluster.")
public class ApiClusterUtilization {
    @SerializedName(value="totalCpuCores")
    private BigDecimal totalCpuCores = null;
    @SerializedName(value="avgCpuUtilization")
    private BigDecimal avgCpuUtilization = null;
    @SerializedName(value="maxCpuUtilization")
    private BigDecimal maxCpuUtilization = null;
    @SerializedName(value="avgCpuDailyPeak")
    private BigDecimal avgCpuDailyPeak = null;
    @SerializedName(value="avgWorkloadCpu")
    private BigDecimal avgWorkloadCpu = null;
    @SerializedName(value="maxWorkloadCpu")
    private BigDecimal maxWorkloadCpu = null;
    @SerializedName(value="avgWorkloadCpuDailyPeak")
    private BigDecimal avgWorkloadCpuDailyPeak = null;
    @SerializedName(value="totalMemory")
    private BigDecimal totalMemory = null;
    @SerializedName(value="avgMemoryUtilization")
    private BigDecimal avgMemoryUtilization = null;
    @SerializedName(value="maxMemoryUtilization")
    private BigDecimal maxMemoryUtilization = null;
    @SerializedName(value="avgMemoryDailyPeak")
    private BigDecimal avgMemoryDailyPeak = null;
    @SerializedName(value="avgWorkloadMemory")
    private BigDecimal avgWorkloadMemory = null;
    @SerializedName(value="maxWorkloadMemory")
    private BigDecimal maxWorkloadMemory = null;
    @SerializedName(value="avgWorkloadMemoryDailyPeak")
    private BigDecimal avgWorkloadMemoryDailyPeak = null;
    @SerializedName(value="tenantUtilizations")
    private ApiTenantUtilizationList tenantUtilizations = null;
    @SerializedName(value="maxCpuUtilizationTimestampMs")
    private BigDecimal maxCpuUtilizationTimestampMs = null;
    @SerializedName(value="maxMemoryUtilizationTimestampMs")
    private BigDecimal maxMemoryUtilizationTimestampMs = null;
    @SerializedName(value="maxWorkloadCpuTimestampMs")
    private BigDecimal maxWorkloadCpuTimestampMs = null;
    @SerializedName(value="maxWorkloadMemoryTimestampMs")
    private BigDecimal maxWorkloadMemoryTimestampMs = null;
    @SerializedName(value="errorMessage")
    private String errorMessage = null;

    public ApiClusterUtilization totalCpuCores(BigDecimal totalCpuCores) {
        this.totalCpuCores = totalCpuCores;
        return this;
    }

    @ApiModelProperty(value="Average number of CPU cores available in the cluster during the report window.")
    public BigDecimal getTotalCpuCores() {
        return this.totalCpuCores;
    }

    public void setTotalCpuCores(BigDecimal totalCpuCores) {
        this.totalCpuCores = totalCpuCores;
    }

    public ApiClusterUtilization avgCpuUtilization(BigDecimal avgCpuUtilization) {
        this.avgCpuUtilization = avgCpuUtilization;
        return this;
    }

    @ApiModelProperty(value="Average CPU consumption for the entire cluster during the report window. This includes consumption by user workloads in YARN and Impala, as well as consumption by all services running in the cluster.")
    public BigDecimal getAvgCpuUtilization() {
        return this.avgCpuUtilization;
    }

    public void setAvgCpuUtilization(BigDecimal avgCpuUtilization) {
        this.avgCpuUtilization = avgCpuUtilization;
    }

    public ApiClusterUtilization maxCpuUtilization(BigDecimal maxCpuUtilization) {
        this.maxCpuUtilization = maxCpuUtilization;
        return this;
    }

    @ApiModelProperty(value="Maximum CPU consumption for the entire cluster during the report window. This includes consumption by user workloads in YARN and Impala, as well as consumption by all services running in the cluster.")
    public BigDecimal getMaxCpuUtilization() {
        return this.maxCpuUtilization;
    }

    public void setMaxCpuUtilization(BigDecimal maxCpuUtilization) {
        this.maxCpuUtilization = maxCpuUtilization;
    }

    public ApiClusterUtilization avgCpuDailyPeak(BigDecimal avgCpuDailyPeak) {
        this.avgCpuDailyPeak = avgCpuDailyPeak;
        return this;
    }

    @ApiModelProperty(value="Average daily peak CPU consumption for the entire cluster during the report window. This includes consumption by user workloads in YARN and Impala, as well as consumption by all services running in the cluster.")
    public BigDecimal getAvgCpuDailyPeak() {
        return this.avgCpuDailyPeak;
    }

    public void setAvgCpuDailyPeak(BigDecimal avgCpuDailyPeak) {
        this.avgCpuDailyPeak = avgCpuDailyPeak;
    }

    public ApiClusterUtilization avgWorkloadCpu(BigDecimal avgWorkloadCpu) {
        this.avgWorkloadCpu = avgWorkloadCpu;
        return this;
    }

    @ApiModelProperty(value="Average CPU consumption by workloads that ran on the cluster during the report window. This includes consumption by user workloads in YARN and Impala.")
    public BigDecimal getAvgWorkloadCpu() {
        return this.avgWorkloadCpu;
    }

    public void setAvgWorkloadCpu(BigDecimal avgWorkloadCpu) {
        this.avgWorkloadCpu = avgWorkloadCpu;
    }

    public ApiClusterUtilization maxWorkloadCpu(BigDecimal maxWorkloadCpu) {
        this.maxWorkloadCpu = maxWorkloadCpu;
        return this;
    }

    @ApiModelProperty(value="Maximum CPU consumption by workloads that ran on the cluster during the report window. This includes consumption by user workloads in YARN and Impala.")
    public BigDecimal getMaxWorkloadCpu() {
        return this.maxWorkloadCpu;
    }

    public void setMaxWorkloadCpu(BigDecimal maxWorkloadCpu) {
        this.maxWorkloadCpu = maxWorkloadCpu;
    }

    public ApiClusterUtilization avgWorkloadCpuDailyPeak(BigDecimal avgWorkloadCpuDailyPeak) {
        this.avgWorkloadCpuDailyPeak = avgWorkloadCpuDailyPeak;
        return this;
    }

    @ApiModelProperty(value="Average daily peak CPU consumption by workloads that ran on the cluster during the report window. This includes consumption by user workloads in YARN and Impala.")
    public BigDecimal getAvgWorkloadCpuDailyPeak() {
        return this.avgWorkloadCpuDailyPeak;
    }

    public void setAvgWorkloadCpuDailyPeak(BigDecimal avgWorkloadCpuDailyPeak) {
        this.avgWorkloadCpuDailyPeak = avgWorkloadCpuDailyPeak;
    }

    public ApiClusterUtilization totalMemory(BigDecimal totalMemory) {
        this.totalMemory = totalMemory;
        return this;
    }

    @ApiModelProperty(value="Average physical memory (in bytes) available in the cluster during the report window. This includes consumption by user workloads in YARN and Impala, as well as consumption by all services running in the cluster.")
    public BigDecimal getTotalMemory() {
        return this.totalMemory;
    }

    public void setTotalMemory(BigDecimal totalMemory) {
        this.totalMemory = totalMemory;
    }

    public ApiClusterUtilization avgMemoryUtilization(BigDecimal avgMemoryUtilization) {
        this.avgMemoryUtilization = avgMemoryUtilization;
        return this;
    }

    @ApiModelProperty(value="Average memory consumption (as percentage of total memory) for the entire cluster during the report window. This includes consumption by user workloads in YARN and Impala, as well as consumption by all services running in the cluster.")
    public BigDecimal getAvgMemoryUtilization() {
        return this.avgMemoryUtilization;
    }

    public void setAvgMemoryUtilization(BigDecimal avgMemoryUtilization) {
        this.avgMemoryUtilization = avgMemoryUtilization;
    }

    public ApiClusterUtilization maxMemoryUtilization(BigDecimal maxMemoryUtilization) {
        this.maxMemoryUtilization = maxMemoryUtilization;
        return this;
    }

    @ApiModelProperty(value="Maximum memory consumption (as percentage of total memory) for the entire cluster during the report window. This includes consumption by user workloads in YARN and Impala, as well as consumption by all services running in the cluster.")
    public BigDecimal getMaxMemoryUtilization() {
        return this.maxMemoryUtilization;
    }

    public void setMaxMemoryUtilization(BigDecimal maxMemoryUtilization) {
        this.maxMemoryUtilization = maxMemoryUtilization;
    }

    public ApiClusterUtilization avgMemoryDailyPeak(BigDecimal avgMemoryDailyPeak) {
        this.avgMemoryDailyPeak = avgMemoryDailyPeak;
        return this;
    }

    @ApiModelProperty(value="Average daily peak memory consumption (as percentage of total memory) for the entire cluster during the report window. This includes consumption by user workloads in YARN and Impala, as well as consumption by all services running in the cluster.")
    public BigDecimal getAvgMemoryDailyPeak() {
        return this.avgMemoryDailyPeak;
    }

    public void setAvgMemoryDailyPeak(BigDecimal avgMemoryDailyPeak) {
        this.avgMemoryDailyPeak = avgMemoryDailyPeak;
    }

    public ApiClusterUtilization avgWorkloadMemory(BigDecimal avgWorkloadMemory) {
        this.avgWorkloadMemory = avgWorkloadMemory;
        return this;
    }

    @ApiModelProperty(value="Average memory consumption (as percentage of total memory) by workloads that ran on the cluster during the report window. This includes consumption by user workloads in YARN and Impala.")
    public BigDecimal getAvgWorkloadMemory() {
        return this.avgWorkloadMemory;
    }

    public void setAvgWorkloadMemory(BigDecimal avgWorkloadMemory) {
        this.avgWorkloadMemory = avgWorkloadMemory;
    }

    public ApiClusterUtilization maxWorkloadMemory(BigDecimal maxWorkloadMemory) {
        this.maxWorkloadMemory = maxWorkloadMemory;
        return this;
    }

    @ApiModelProperty(value="Maximum memory consumption (as percentage of total memory) by workloads that ran on the cluster. This includes consumption by user workloads in YARN and Impala")
    public BigDecimal getMaxWorkloadMemory() {
        return this.maxWorkloadMemory;
    }

    public void setMaxWorkloadMemory(BigDecimal maxWorkloadMemory) {
        this.maxWorkloadMemory = maxWorkloadMemory;
    }

    public ApiClusterUtilization avgWorkloadMemoryDailyPeak(BigDecimal avgWorkloadMemoryDailyPeak) {
        this.avgWorkloadMemoryDailyPeak = avgWorkloadMemoryDailyPeak;
        return this;
    }

    @ApiModelProperty(value="Average daily peak memory consumption (as percentage of total memory) by workloads that ran on the cluster during the report window. This includes consumption by user workloads in YARN and Impala.")
    public BigDecimal getAvgWorkloadMemoryDailyPeak() {
        return this.avgWorkloadMemoryDailyPeak;
    }

    public void setAvgWorkloadMemoryDailyPeak(BigDecimal avgWorkloadMemoryDailyPeak) {
        this.avgWorkloadMemoryDailyPeak = avgWorkloadMemoryDailyPeak;
    }

    public ApiClusterUtilization tenantUtilizations(ApiTenantUtilizationList tenantUtilizations) {
        this.tenantUtilizations = tenantUtilizations;
        return this;
    }

    @ApiModelProperty(value="A list of tenant utilization reports.")
    public ApiTenantUtilizationList getTenantUtilizations() {
        return this.tenantUtilizations;
    }

    public void setTenantUtilizations(ApiTenantUtilizationList tenantUtilizations) {
        this.tenantUtilizations = tenantUtilizations;
    }

    public ApiClusterUtilization maxCpuUtilizationTimestampMs(BigDecimal maxCpuUtilizationTimestampMs) {
        this.maxCpuUtilizationTimestampMs = maxCpuUtilizationTimestampMs;
        return this;
    }

    @ApiModelProperty(value="Timestamp corresponding to maximum CPU utilization for the entire cluster during the report window.")
    public BigDecimal getMaxCpuUtilizationTimestampMs() {
        return this.maxCpuUtilizationTimestampMs;
    }

    public void setMaxCpuUtilizationTimestampMs(BigDecimal maxCpuUtilizationTimestampMs) {
        this.maxCpuUtilizationTimestampMs = maxCpuUtilizationTimestampMs;
    }

    public ApiClusterUtilization maxMemoryUtilizationTimestampMs(BigDecimal maxMemoryUtilizationTimestampMs) {
        this.maxMemoryUtilizationTimestampMs = maxMemoryUtilizationTimestampMs;
        return this;
    }

    @ApiModelProperty(value="Timestamp corresponding to maximum memory utilization for the entire cluster during the report window.")
    public BigDecimal getMaxMemoryUtilizationTimestampMs() {
        return this.maxMemoryUtilizationTimestampMs;
    }

    public void setMaxMemoryUtilizationTimestampMs(BigDecimal maxMemoryUtilizationTimestampMs) {
        this.maxMemoryUtilizationTimestampMs = maxMemoryUtilizationTimestampMs;
    }

    public ApiClusterUtilization maxWorkloadCpuTimestampMs(BigDecimal maxWorkloadCpuTimestampMs) {
        this.maxWorkloadCpuTimestampMs = maxWorkloadCpuTimestampMs;
        return this;
    }

    @ApiModelProperty(value="Timestamp corresponds to maximum CPU consumption by workloads that ran on the cluster during the report window.")
    public BigDecimal getMaxWorkloadCpuTimestampMs() {
        return this.maxWorkloadCpuTimestampMs;
    }

    public void setMaxWorkloadCpuTimestampMs(BigDecimal maxWorkloadCpuTimestampMs) {
        this.maxWorkloadCpuTimestampMs = maxWorkloadCpuTimestampMs;
    }

    public ApiClusterUtilization maxWorkloadMemoryTimestampMs(BigDecimal maxWorkloadMemoryTimestampMs) {
        this.maxWorkloadMemoryTimestampMs = maxWorkloadMemoryTimestampMs;
        return this;
    }

    @ApiModelProperty(value="Timestamp corresponds to maximum memory resource consumption by workloads that ran on the cluster during the report window.")
    public BigDecimal getMaxWorkloadMemoryTimestampMs() {
        return this.maxWorkloadMemoryTimestampMs;
    }

    public void setMaxWorkloadMemoryTimestampMs(BigDecimal maxWorkloadMemoryTimestampMs) {
        this.maxWorkloadMemoryTimestampMs = maxWorkloadMemoryTimestampMs;
    }

    public ApiClusterUtilization errorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    @ApiModelProperty(value="Error message while generating utilization report.")
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiClusterUtilization apiClusterUtilization = (ApiClusterUtilization)o;
        return Objects.equals(this.totalCpuCores, apiClusterUtilization.totalCpuCores) && Objects.equals(this.avgCpuUtilization, apiClusterUtilization.avgCpuUtilization) && Objects.equals(this.maxCpuUtilization, apiClusterUtilization.maxCpuUtilization) && Objects.equals(this.avgCpuDailyPeak, apiClusterUtilization.avgCpuDailyPeak) && Objects.equals(this.avgWorkloadCpu, apiClusterUtilization.avgWorkloadCpu) && Objects.equals(this.maxWorkloadCpu, apiClusterUtilization.maxWorkloadCpu) && Objects.equals(this.avgWorkloadCpuDailyPeak, apiClusterUtilization.avgWorkloadCpuDailyPeak) && Objects.equals(this.totalMemory, apiClusterUtilization.totalMemory) && Objects.equals(this.avgMemoryUtilization, apiClusterUtilization.avgMemoryUtilization) && Objects.equals(this.maxMemoryUtilization, apiClusterUtilization.maxMemoryUtilization) && Objects.equals(this.avgMemoryDailyPeak, apiClusterUtilization.avgMemoryDailyPeak) && Objects.equals(this.avgWorkloadMemory, apiClusterUtilization.avgWorkloadMemory) && Objects.equals(this.maxWorkloadMemory, apiClusterUtilization.maxWorkloadMemory) && Objects.equals(this.avgWorkloadMemoryDailyPeak, apiClusterUtilization.avgWorkloadMemoryDailyPeak) && Objects.equals(this.tenantUtilizations, apiClusterUtilization.tenantUtilizations) && Objects.equals(this.maxCpuUtilizationTimestampMs, apiClusterUtilization.maxCpuUtilizationTimestampMs) && Objects.equals(this.maxMemoryUtilizationTimestampMs, apiClusterUtilization.maxMemoryUtilizationTimestampMs) && Objects.equals(this.maxWorkloadCpuTimestampMs, apiClusterUtilization.maxWorkloadCpuTimestampMs) && Objects.equals(this.maxWorkloadMemoryTimestampMs, apiClusterUtilization.maxWorkloadMemoryTimestampMs) && Objects.equals(this.errorMessage, apiClusterUtilization.errorMessage);
    }

    public int hashCode() {
        return Objects.hash(this.totalCpuCores, this.avgCpuUtilization, this.maxCpuUtilization, this.avgCpuDailyPeak, this.avgWorkloadCpu, this.maxWorkloadCpu, this.avgWorkloadCpuDailyPeak, this.totalMemory, this.avgMemoryUtilization, this.maxMemoryUtilization, this.avgMemoryDailyPeak, this.avgWorkloadMemory, this.maxWorkloadMemory, this.avgWorkloadMemoryDailyPeak, this.tenantUtilizations, this.maxCpuUtilizationTimestampMs, this.maxMemoryUtilizationTimestampMs, this.maxWorkloadCpuTimestampMs, this.maxWorkloadMemoryTimestampMs, this.errorMessage);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiClusterUtilization {\n");
        sb.append("    totalCpuCores: ").append(this.toIndentedString(this.totalCpuCores)).append("\n");
        sb.append("    avgCpuUtilization: ").append(this.toIndentedString(this.avgCpuUtilization)).append("\n");
        sb.append("    maxCpuUtilization: ").append(this.toIndentedString(this.maxCpuUtilization)).append("\n");
        sb.append("    avgCpuDailyPeak: ").append(this.toIndentedString(this.avgCpuDailyPeak)).append("\n");
        sb.append("    avgWorkloadCpu: ").append(this.toIndentedString(this.avgWorkloadCpu)).append("\n");
        sb.append("    maxWorkloadCpu: ").append(this.toIndentedString(this.maxWorkloadCpu)).append("\n");
        sb.append("    avgWorkloadCpuDailyPeak: ").append(this.toIndentedString(this.avgWorkloadCpuDailyPeak)).append("\n");
        sb.append("    totalMemory: ").append(this.toIndentedString(this.totalMemory)).append("\n");
        sb.append("    avgMemoryUtilization: ").append(this.toIndentedString(this.avgMemoryUtilization)).append("\n");
        sb.append("    maxMemoryUtilization: ").append(this.toIndentedString(this.maxMemoryUtilization)).append("\n");
        sb.append("    avgMemoryDailyPeak: ").append(this.toIndentedString(this.avgMemoryDailyPeak)).append("\n");
        sb.append("    avgWorkloadMemory: ").append(this.toIndentedString(this.avgWorkloadMemory)).append("\n");
        sb.append("    maxWorkloadMemory: ").append(this.toIndentedString(this.maxWorkloadMemory)).append("\n");
        sb.append("    avgWorkloadMemoryDailyPeak: ").append(this.toIndentedString(this.avgWorkloadMemoryDailyPeak)).append("\n");
        sb.append("    tenantUtilizations: ").append(this.toIndentedString(this.tenantUtilizations)).append("\n");
        sb.append("    maxCpuUtilizationTimestampMs: ").append(this.toIndentedString(this.maxCpuUtilizationTimestampMs)).append("\n");
        sb.append("    maxMemoryUtilizationTimestampMs: ").append(this.toIndentedString(this.maxMemoryUtilizationTimestampMs)).append("\n");
        sb.append("    maxWorkloadCpuTimestampMs: ").append(this.toIndentedString(this.maxWorkloadCpuTimestampMs)).append("\n");
        sb.append("    maxWorkloadMemoryTimestampMs: ").append(this.toIndentedString(this.maxWorkloadMemoryTimestampMs)).append("\n");
        sb.append("    errorMessage: ").append(this.toIndentedString(this.errorMessage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

