"use strict";
function __export(m) {
    for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
}
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
const interface_1 = require("./tree/interface");
const static_1 = require("./tree/static");
var exception_1 = require("./exception/exception");
exports.SchematicsException = exception_1.SchematicsException;
__export(require("./tree/action"));
__export(require("./engine/collection"));
__export(require("./engine/engine"));
__export(require("./exception/exception"));
__export(require("./tree/interface"));
__export(require("./rules/base"));
__export(require("./rules/move"));
__export(require("./rules/random"));
__export(require("./rules/schematic"));
__export(require("./rules/template"));
__export(require("./rules/url"));
__export(require("./tree/delegate"));
__export(require("./tree/empty"));
__export(require("./tree/filesystem"));
__export(require("./tree/memory-host"));
__export(require("./tree/virtual"));
__export(require("./engine/schematic"));
__export(require("./sink/dryrun"));
var filesystem_1 = require("./sink/filesystem");
exports.FileSystemSink = filesystem_1.FileSystemSink;
const formats = require("./formats");
exports.formats = formats;
exports.Tree = {
    empty() { return static_1.empty(); },
    branch(tree) { return static_1.branch(tree); },
    merge(tree, other, strategy = interface_1.MergeStrategy.Default) {
        return static_1.merge(tree, other, strategy);
    },
    partition(tree, predicate) {
        return static_1.partition(tree, predicate);
    },
    optimize(tree) { return static_1.optimize(tree); },
};
//# sourceMappingURL=data:application/json;base64,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