/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm.tree;

import java.util.List;
import java.util.Map;
import org.eclipse.persistence.internal.libraries.asm.Label;
import org.eclipse.persistence.internal.libraries.asm.MethodVisitor;
import org.eclipse.persistence.internal.libraries.asm.tree.AbstractInsnNode;
import org.eclipse.persistence.internal.libraries.asm.tree.LabelNode;
import org.eclipse.persistence.internal.libraries.asm.tree.Util;

public class LookupSwitchInsnNode
extends AbstractInsnNode {
    public LabelNode dflt;
    public List<Integer> keys;
    public List<LabelNode> labels;

    public LookupSwitchInsnNode(LabelNode labelNode, int[] nArray, LabelNode[] labelNodeArray) {
        super(171);
        this.dflt = labelNode;
        this.keys = Util.asArrayList(nArray);
        this.labels = Util.asArrayList(labelNodeArray);
    }

    @Override
    public int getType() {
        return 12;
    }

    @Override
    public void accept(MethodVisitor methodVisitor) {
        int[] nArray = new int[this.keys.size()];
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.keys.get(i);
        }
        Label[] labelArray = new Label[this.labels.size()];
        int n2 = labelArray.length;
        for (n = 0; n < n2; ++n) {
            labelArray[n] = this.labels.get(n).getLabel();
        }
        methodVisitor.visitLookupSwitchInsn(this.dflt.getLabel(), nArray, labelArray);
        this.acceptAnnotations(methodVisitor);
    }

    @Override
    public AbstractInsnNode clone(Map<LabelNode, LabelNode> map) {
        LookupSwitchInsnNode lookupSwitchInsnNode = new LookupSwitchInsnNode(LookupSwitchInsnNode.clone(this.dflt, map), null, LookupSwitchInsnNode.clone(this.labels, map));
        lookupSwitchInsnNode.keys.addAll(this.keys);
        return lookupSwitchInsnNode.cloneAnnotations(this);
    }
}

