/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.extended.ads_impl.endTransaction.controls.actions;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.asn1.util.Oid;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.CodecControl;
import org.apache.directory.api.ldap.extras.extended.ads_impl.endTransaction.controls.ControlsContainer;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddControl
extends GrammarAction<ControlsContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(AddControl.class);

    public AddControl() {
        super("Add a new control");
    }

    public void action(ControlsContainer container) throws DecoderException {
        TLV tlv = container.getCurrentTLV();
        if (tlv.getLength() == 0) {
            String msg = I18n.err((I18n)I18n.ERR_08214_NULL_OID, (Object[])new Object[0]);
            LOG.error(msg);
            throw new DecoderException(msg);
        }
        byte[] value = tlv.getValue().getData();
        String oidValue = Strings.asciiBytesToString((byte[])value);
        if (!Oid.isOid((String)oidValue)) {
            String msg = I18n.err((I18n)I18n.ERR_08215_INVALID_CONTROL_OID, (Object[])new Object[]{oidValue});
            LOG.error(msg);
            throw new DecoderException(msg);
        }
        CodecControl control = container.getLdapCodecService().newControl(oidValue);
        container.setCurrentControl(control);
        container.addControl((Control)control);
        container.setGrammarEndAllowed(true);
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg((I18n)I18n.MSG_08201_CONTROL_OID, (Object[])new Object[]{oidValue}));
        }
    }
}

