/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm.model.hdfs;

import com.cloudera.api.swagger.client.ApiException;
import com.cloudera.api.swagger.model.ApiConfigList;
import com.cloudera.api.swagger.model.ApiRole;
import com.cloudera.api.swagger.model.ApiService;
import com.cloudera.api.swagger.model.ApiServiceConfig;
import java.util.Locale;
import org.apache.knox.gateway.topology.discovery.cm.ServiceModel;
import org.apache.knox.gateway.topology.discovery.cm.model.AbstractServiceModelGenerator;

public class NameNodeServiceModelGenerator
extends AbstractServiceModelGenerator {
    private static final String SERVICE = "NAMENODE";
    private static final String SERVICE_TYPE = "HDFS";
    private static final String ROLE_TYPE = "NAMENODE";

    @Override
    public boolean handles(ApiService service, ApiServiceConfig serviceConfig, ApiRole role, ApiConfigList roleConfig) {
        return SERVICE_TYPE.equals(service.getType()) && "NAMENODE".equals(role.getType());
    }

    @Override
    public ServiceModel generateService(ApiService service, ApiServiceConfig serviceConfig, ApiRole role, ApiConfigList roleConfig) throws ApiException {
        String serviceUrl;
        boolean haEnabled = Boolean.parseBoolean(this.getRoleConfigValue(roleConfig, "autofailover_enabled"));
        if (haEnabled) {
            String nameservice = this.getRoleConfigValue(roleConfig, "dfs_federation_namenode_nameservice");
            serviceUrl = String.format(Locale.getDefault(), "hdfs://%s", nameservice);
        } else {
            String hostname = role.getHostRef().getHostname();
            String port = this.getRoleConfigValue(roleConfig, "namenode_port");
            serviceUrl = String.format(Locale.getDefault(), "hdfs://%s:%s", hostname, port);
        }
        return new ServiceModel(ServiceModel.Type.API, "NAMENODE", serviceUrl);
    }
}

