/*
 * Decompiled with CFR 0.152.
 */
package org.cryptacular.generator;

import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.cryptacular.generator.IdGenerator;
import org.cryptacular.util.NonceUtil;

public class RandomIdGenerator
implements IdGenerator {
    public static final String DEFAULT_CHARSET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    private final int length;
    private final String charset;

    public RandomIdGenerator(int length) {
        this(length, DEFAULT_CHARSET);
    }

    public RandomIdGenerator(int length, String charset) {
        if (length < 1) {
            throw new IllegalArgumentException("Length must be positive");
        }
        this.length = length;
        if (charset == null || charset.length() < 2 || charset.length() > 128) {
            throw new IllegalArgumentException("Charset length must be in the range 2 - 128");
        }
        this.charset = charset;
    }

    @Override
    public String generate() {
        StringBuilder id = new StringBuilder(this.length);
        byte[] output = new byte[this.length];
        int outsize = NonceUtil.newRBG((Digest)new SHA256Digest(), 32).generate(output, null, false);
        if (outsize < this.length) {
            throw new IllegalStateException("Insufficient entropy");
        }
        for (int i = 0; i < output.length && id.length() < this.length; ++i) {
            int index = 0x7F & output[i];
            id.append(this.charset.charAt(index % this.charset.length()));
        }
        return id.toString();
    }
}

