/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.support.EventHelper;
import org.apache.camel.util.StopWatch;

public class EventNotifierCallback
implements AsyncCallback {
    private final AsyncCallback originalCallback;
    private final StopWatch watch;
    private final Exchange exchange;
    private final Endpoint endpoint;
    private final boolean sending;

    public EventNotifierCallback(AsyncCallback originalCallback, Exchange exchange, Endpoint endpoint) {
        this.originalCallback = originalCallback;
        this.exchange = exchange;
        this.endpoint = endpoint;
        this.sending = EventHelper.notifyExchangeSending((CamelContext)exchange.getContext(), (Exchange)exchange, (Endpoint)endpoint);
        this.watch = this.sending ? new StopWatch() : null;
    }

    public void done(boolean doneSync) {
        if (this.watch != null) {
            long timeTaken = this.watch.taken();
            EventHelper.notifyExchangeSent((CamelContext)this.exchange.getContext(), (Exchange)this.exchange, (Endpoint)this.endpoint, (long)timeTaken);
        }
        this.originalCallback.done(doneSync);
    }
}

