/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.util;

import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.utils.Utils;

public class ConcreteSubClassValidator
implements ConfigDef.Validator {
    private final Class<?> expectedSuperClass;

    private ConcreteSubClassValidator(Class<?> expectedSuperClass) {
        this.expectedSuperClass = expectedSuperClass;
    }

    public static ConcreteSubClassValidator forSuperClass(Class<?> expectedSuperClass) {
        return new ConcreteSubClassValidator(expectedSuperClass);
    }

    public void ensureValid(String name, Object value) {
        if (value == null) {
            return;
        }
        Class cls = (Class)value;
        Utils.ensureConcreteSubclass(this.expectedSuperClass, (Class)cls);
    }

    public String toString() {
        return "A concrete subclass of " + this.expectedSuperClass.getName();
    }
}

