/*
 * Decompiled with CFR 0.152.
 */
package kafka.log.remote.quota;

import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.server.SensorAccess;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Max;
import scala.Function1;
import scala.runtime.BoxedUnit;

public class RLMQuotaMetrics {
    private final Sensor sensor;

    public RLMQuotaMetrics(Metrics metrics, String name, String group, String descriptionFormat, long expirationTime) {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        SensorAccess sensorAccess = new SensorAccess(lock, metrics);
        this.sensor = sensorAccess.getOrCreate(name, expirationTime, (Function1<Sensor, BoxedUnit>)((Function1)s -> {
            s.add(metrics.metricName(name + "-avg", group, String.format(descriptionFormat, "average")), (MeasurableStat)new Avg());
            s.add(metrics.metricName(name + "-max", group, String.format(descriptionFormat, "maximum")), (MeasurableStat)new Max());
            return BoxedUnit.UNIT;
        }));
    }

    public Sensor sensor() {
        return this.sensor;
    }
}

