/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.AccessControlEntryRecord;
import org.apache.kafka.common.metadata.RemoveAccessControlEntryRecord;
import org.apache.kafka.image.AclsImage;
import org.apache.kafka.metadata.authorizer.StandardAcl;
import org.apache.kafka.metadata.authorizer.StandardAclWithId;
import org.apache.kafka.server.common.MetadataVersion;

public final class AclsDelta {
    private final AclsImage image;
    private final Map<Uuid, Optional<StandardAcl>> changes = new LinkedHashMap<Uuid, Optional<StandardAcl>>();

    public AclsDelta(AclsImage image) {
        this.image = image;
    }

    public Map<Uuid, Optional<StandardAcl>> changes() {
        return this.changes;
    }

    void finishSnapshot() {
        for (Map.Entry<Uuid, StandardAcl> entry : this.image.acls().entrySet()) {
            if (this.changes.containsKey(entry.getKey())) continue;
            this.changes.put(entry.getKey(), Optional.empty());
        }
    }

    public void handleMetadataVersionChange(MetadataVersion newVersion) {
    }

    public void replay(AccessControlEntryRecord record) {
        StandardAclWithId aclWithId = StandardAclWithId.fromRecord(record);
        this.changes.put(aclWithId.id(), Optional.of(aclWithId.acl()));
    }

    public void replay(RemoveAccessControlEntryRecord record) {
        if (this.image.acls().containsKey(record.id())) {
            this.changes.put(record.id(), Optional.empty());
        } else if (this.changes.containsKey(record.id())) {
            this.changes.remove(record.id());
        } else {
            throw new IllegalStateException("Failed to find existing ACL with ID " + record.id() + " in either image or changes");
        }
    }

    public AclsImage apply() {
        HashMap<Uuid, StandardAcl> newAcls = new HashMap<Uuid, StandardAcl>();
        for (Map.Entry<Uuid, StandardAcl> entry : this.image.acls().entrySet()) {
            Optional<StandardAcl> change = this.changes.get(entry.getKey());
            if (change == null) {
                newAcls.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (!change.isPresent()) continue;
            newAcls.put(entry.getKey(), change.get());
        }
        for (Map.Entry<Uuid, Object> entry : this.changes.entrySet()) {
            if (newAcls.containsKey(entry.getKey()) || !((Optional)entry.getValue()).isPresent()) continue;
            newAcls.put(entry.getKey(), (StandardAcl)((Optional)entry.getValue()).get());
        }
        return new AclsImage(newAcls);
    }

    public String toString() {
        return "AclsDelta(, changes=" + this.changes.entrySet().stream().map(e -> e.getKey() + "=" + e.getValue()).collect(Collectors.joining(", ")) + ")";
    }
}

