/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Stage {
    private static final Logger log = LoggerFactory.getLogger(Stage.class);
    private final String description;
    private final long started;
    private volatile Long completed;

    public Stage(String description, long started) {
        this.description = description;
        this.started = started;
        this.completed = null;
    }

    public String description() {
        return this.description;
    }

    public long started() {
        return this.started;
    }

    public Long completed() {
        return this.completed;
    }

    public synchronized void complete(long time) {
        if (time < this.started) {
            log.warn("Ignoring invalid completion time {} since it is before this stage's start time of {}", (Object)time, (Object)this.started);
            return;
        }
        if (this.completed != null) {
            log.warn("Ignoring completion time of {} since this stage was already completed at {}", (Object)time, (Object)this.completed);
            return;
        }
        this.completed = time;
    }

    public String toString() {
        return this.description + "(started " + this.started + ", completed=" + this.completed() + ")";
    }
}

